/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.local.model.DefaultProjectDependencyMetadata;
import org.gradle.internal.component.model.AttributeConfigurationSelector;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;

public class GradleDependencyMetadata
implements ModuleDependencyMetadata {
    private final ModuleComponentSelector selector;
    private final List<ExcludeMetadata> excludes;
    private final boolean pending;
    private final String reason;

    public GradleDependencyMetadata(ModuleComponentSelector selector, List<ExcludeMetadata> excludes, boolean pending, String reason) {
        this.selector = selector;
        this.excludes = excludes;
        this.reason = reason;
        this.pending = pending;
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return ImmutableList.of();
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        if (requestedVersion.equals(this.selector.getVersionConstraint())) {
            return this;
        }
        return new GradleDependencyMetadata(DefaultModuleComponentSelector.newSelector(this.selector.getModuleIdentifier(), requestedVersion, this.selector.getAttributes()), this.excludes, this.pending, this.reason);
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        if (Objects.equal((Object)reason, (Object)this.reason)) {
            return this;
        }
        return new GradleDependencyMetadata(this.selector, this.excludes, this.pending, reason);
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        if (target instanceof ModuleComponentSelector) {
            return new GradleDependencyMetadata((ModuleComponentSelector)target, this.excludes, this.pending, this.reason);
        }
        return new DefaultProjectDependencyMetadata((ProjectComponentSelector)target, this);
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return this.selector;
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.excludes;
    }

    @Override
    public List<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema) {
        return ImmutableList.of((Object)AttributeConfigurationSelector.selectConfigurationUsingAttributeMatching(consumerAttributes, targetComponent, consumerSchema));
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return true;
    }

    @Override
    public boolean isPending() {
        return this.pending;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return "GradleDependencyMetadata: " + this.selector.toString();
    }
}

