/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.GenericJUnitTestEventAdapter;
import org.gradle.api.internal.tasks.testing.junit.IgnoredTestDescriptorProvider;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitTestEventAdapter
extends RunListener {
    private static final Pattern DESCRIPTOR_PATTERN = Pattern.compile("(.*)\\((.*)\\)(\\[\\d+])?", 32);
    private final IdGenerator<?> idGenerator;
    private final GenericJUnitTestEventAdapter<Description> adapter;

    public JUnitTestEventAdapter(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator) {
        this.idGenerator = idGenerator;
        this.adapter = new GenericJUnitTestEventAdapter(resultProcessor, clock);
    }

    public void testStarted(Description description) throws Exception {
        this.adapter.testStarted(description, this.nullSafeDescriptor(this.idGenerator.generateId(), description));
    }

    public void testFailure(Failure failure) throws Exception {
        this.adapter.testFailure(failure.getDescription(), this.nullSafeDescriptor(this.idGenerator.generateId(), failure.getDescription()), failure.getException());
    }

    public void testAssumptionFailure(Failure failure) {
        this.adapter.testAssumptionFailure(failure.getDescription());
    }

    public void testIgnored(Description description) throws Exception {
        if (JUnitTestEventAdapter.methodName(description) == null) {
            this.processIgnoredClass(description);
        } else {
            this.adapter.testIgnored(this.descriptor(this.idGenerator.generateId(), description));
        }
    }

    private void processIgnoredClass(Description description) throws Exception {
        IgnoredTestDescriptorProvider provider = new IgnoredTestDescriptorProvider();
        String className = JUnitTestEventAdapter.className(description);
        for (Description childDescription : provider.getAllDescriptions(description, className)) {
            this.testIgnored(childDescription);
        }
    }

    public void testFinished(Description description) throws Exception {
        this.adapter.testFinished(description);
    }

    private TestDescriptorInternal descriptor(Object id, Description description) {
        return new DefaultTestDescriptor(id, JUnitTestEventAdapter.className(description), JUnitTestEventAdapter.methodName(description));
    }

    private TestDescriptorInternal nullSafeDescriptor(Object id, Description description) {
        String methodName = JUnitTestEventAdapter.methodName(description);
        if (methodName != null) {
            return new DefaultTestDescriptor(id, JUnitTestEventAdapter.className(description), methodName);
        }
        return new DefaultTestDescriptor(id, JUnitTestEventAdapter.className(description), "classMethod");
    }

    public static String methodName(Description description) {
        return JUnitTestEventAdapter.methodName(description.toString());
    }

    public static String methodName(String description) {
        Matcher matcher = JUnitTestEventAdapter.methodStringMatcher(description);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String className(Description description) {
        return JUnitTestEventAdapter.className(description.toString());
    }

    public static String className(String description) {
        Matcher matcher = JUnitTestEventAdapter.methodStringMatcher(description);
        return matcher.matches() ? matcher.group(2) : description;
    }

    private static Matcher methodStringMatcher(String description) {
        return DESCRIPTOR_PATTERN.matcher(description);
    }
}

