/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.serialize.AbstractEncoder;
import org.gradle.internal.serialize.FlushableEncoder;

public class OutputStreamBackedEncoder
extends AbstractEncoder
implements Closeable,
FlushableEncoder {
    private final DataOutputStream outputStream;

    public OutputStreamBackedEncoder(OutputStream outputStream) {
        this.outputStream = new DataOutputStream(outputStream);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.outputStream.writeLong(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.outputStream.writeInt(value);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.outputStream.writeBoolean(value);
    }

    @Override
    public void writeString(CharSequence value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot encode a null string.");
        }
        this.outputStream.writeUTF(value.toString());
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.outputStream.writeByte(value);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int count) throws IOException {
        this.outputStream.write(bytes, offset, count);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

