/*
 * Decompiled with CFR 0.152.
 */
package JTrrntzip.SupportedFiles.ZipFile;

import JTrrntzip.Messages;
import JTrrntzip.SupportedFiles.EnhancedSeekableByteChannel;
import JTrrntzip.SupportedFiles.ICompress;
import JTrrntzip.SupportedFiles.UnsignedTypes;
import JTrrntzip.ZipOpenType;
import JTrrntzip.ZipReturn;
import JTrrntzip.ZipStatus;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.input.BoundedInputStream;

public final class ZipFile
implements ICompress {
    private static final int CentralDirectoryHeaderSignature = 33639248;
    private static final int EndOfCentralDirSignature = 101010256;
    private static final int LocalFileHeaderSignature = 67324752;
    private static final int Zip64EndOfCentralDirectoryLocator = 117853008;
    private static final int Zip64EndOfCentralDirSignature = 101075792;
    private BigInteger _centerDirSize;
    private BigInteger _centerDirStart;
    private BigInteger _endOfCenterDir64;
    private EnhancedSeekableByteChannel _esbc;
    byte[] _fileComment;
    private final List<LocalFile> _localFiles = new ArrayList<LocalFile>();
    private BigInteger _localFilesCount;
    private EnumSet<ZipStatus> _pZipStatus = EnumSet.noneOf(ZipStatus.class);
    private int _readIndex;
    private boolean _zip64;
    private File _zipFileInfo = null;
    private AtomicReference<Deflater> deflater = new AtomicReference();
    private AtomicReference<Inflater> inflater = new AtomicReference();
    private ZipOpenType zipOpen = ZipOpenType.Closed;

    private static final void CreateDirForFile(File sFilename) {
        sFilename.getParentFile().mkdirs();
    }

    public static final String ZipErrorMessageText(ZipReturn zS) {
        String ret = Messages.getString("ZipFile.ZIPUnknown");
        switch (zS) {
            case ZipGood: {
                ret = Messages.getString("ZipFile.ZIPGood");
                break;
            }
            case ZipFileCountError: {
                ret = Messages.getString("ZipFile.ZIPFileCountError");
                break;
            }
            case ZipSignatureError: {
                ret = Messages.getString("ZipFile.ZipSignatureError");
                break;
            }
            case ZipExtraDataOnEndOfZip: {
                ret = Messages.getString("ZipFile.ZipExtraDataOnEndOfZip");
                break;
            }
            case ZipUnsupportedCompression: {
                ret = Messages.getString("ZipFile.ZipUnsipportedCompression");
                break;
            }
            case ZipLocalFileHeaderError: {
                ret = Messages.getString("ZipFile.ZipLocalFileHeaderError");
                break;
            }
            case ZipCentralDirError: {
                ret = Messages.getString("ZipFile.ZipCentralDirError");
                break;
            }
            case ZipReadingFromOutputFile: {
                ret = Messages.getString("ZipFile.ZipReadingFromOutputFile");
                break;
            }
            case ZipWritingToInputFile: {
                ret = Messages.getString("ZipFile.ZipWritingToInputFile");
                break;
            }
            case ZipErrorGettingDataStream: {
                ret = Messages.getString("ZipFile.ZipErrorGettingDataStream");
                break;
            }
            case ZipCRCDecodeError: {
                ret = Messages.getString("ZipFile.ZipCRCDecodeError");
                break;
            }
            case ZipDecodeError: {
                ret = Messages.getString("ZipFile.ZipDecodeError");
                break;
            }
            default: {
                ret = zS.toString();
            }
        }
        return ret;
    }

    @Override
    public final void close() {
        if (this.deflater.get() != null) {
            this.deflater.get().end();
        }
        if (this.inflater.get() != null) {
            this.inflater.get().end();
        }
        if (this._esbc != null) {
            try {
                this._esbc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public final byte[] CRC32(int i) {
        return this._localFiles.get((int)i).crc;
    }

    @Override
    public final void DeepScan() {
        for (LocalFile lfile : this._localFiles) {
            lfile.LocalFileCheck();
        }
    }

    private final ZipReturn EndOfCentralDirRead() throws IOException {
        long thisSignature = this._esbc.getInt();
        if (thisSignature != 101010256L) {
            return ZipReturn.ZipEndOfCentralDirectoryError;
        }
        int tushort = this._esbc.getUShort();
        if (tushort != 0) {
            return ZipReturn.ZipEndOfCentralDirectoryError;
        }
        tushort = this._esbc.getUShort();
        if (tushort != 0) {
            return ZipReturn.ZipEndOfCentralDirectoryError;
        }
        this._localFilesCount = BigInteger.valueOf(this._esbc.getUShort());
        tushort = this._esbc.getUShort();
        if (BigInteger.valueOf(tushort).compareTo(this._localFilesCount) != 0) {
            return ZipReturn.ZipEndOfCentralDirectoryError;
        }
        this._centerDirSize = BigInteger.valueOf(this._esbc.getUInt());
        this._centerDirStart = BigInteger.valueOf(this._esbc.getUInt());
        int zipFileCommentLength = this._esbc.getUShort();
        this._fileComment = new byte[zipFileCommentLength];
        this._esbc.get(this._fileComment);
        if (this._esbc.position() != this._esbc.size()) {
            this._pZipStatus.add(ZipStatus.ExtraData);
        }
        return ZipReturn.ZipGood;
    }

    private final void EndOfCentralDirWrite() throws IOException {
        this._esbc.putUInt(101010256L);
        this._esbc.putUShort(0);
        this._esbc.putUShort(0);
        this._esbc.putUShort(this._localFiles.size() >= 65535 ? 65535 : this._localFiles.size());
        this._esbc.putUShort(this._localFiles.size() >= 65535 ? 65535 : this._localFiles.size());
        this._esbc.putUInt((this._centerDirSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0 ? Long.valueOf(0xFFFFFFFFL) : this._centerDirSize).longValue());
        this._esbc.putUInt((this._centerDirStart.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0 ? Long.valueOf(0xFFFFFFFFL) : this._centerDirStart).longValue());
        this._esbc.putUShort(this._fileComment.length);
        this._esbc.put(this._fileComment, 0, this._fileComment.length);
    }

    @Override
    public final String Filename(int i) {
        return this._localFiles.get((int)i).fileName;
    }

    @Override
    public final ZipReturn FileStatus(int i) {
        return this._localFiles.get((int)i).fileStatus;
    }

    private final ZipReturn FindEndOfCentralDirSignature() throws IOException {
        long fileSize = this._esbc.size();
        long maxBackSearch = 65535L;
        if (this._esbc.size() < maxBackSearch) {
            maxBackSearch = fileSize;
        }
        int buffSize = 1024;
        byte[] buffer = new byte[1028];
        long backPosition = 4L;
        while (backPosition < maxBackSearch) {
            if ((backPosition += 1024L) > maxBackSearch) {
                backPosition = maxBackSearch;
            }
            long readSize = backPosition > 1028L ? 1028L : backPosition;
            this._esbc.position(fileSize - backPosition);
            this._esbc.get(buffer, 0, (int)readSize);
            for (int i = (int)readSize - 4; i >= 0; --i) {
                if (buffer[i] != 80 || buffer[i + 1] != 75 || buffer[i + 2] != 5 || buffer[i + 3] != 6) continue;
                this._esbc.position(fileSize - backPosition + (long)i);
                return ZipReturn.ZipGood;
            }
        }
        return ZipReturn.ZipCentralDirError;
    }

    @Override
    public final int LocalFilesCount() {
        return this._localFiles.size();
    }

    @Override
    public final BigInteger LocalHeader(int i) {
        return (this._localFiles.get((int)i)._generalPurposeBitFlag & 8) == 0 ? this._localFiles.get((int)i).relativeOffsetOfLocalHeader : null;
    }

    @Override
    public final long TimeStamp() {
        return this._zipFileInfo != null ? this._zipFileInfo.lastModified() : 0L;
    }

    @Override
    public final BigInteger UncompressedSize(int i) {
        return this._localFiles.get((int)i)._uncompressedSize;
    }

    private final ZipReturn Zip64EndOfCentralDirectoryLocatorRead() throws IOException {
        this._zip64 = true;
        long thisSignature = this._esbc.getUInt();
        if (thisSignature != 117853008L) {
            return ZipReturn.ZipEndOfCentralDirectoryError;
        }
        long tuint = this._esbc.getUInt();
        if (tuint != 0L) {
            return ZipReturn.Zip64EndOfCentralDirectoryLocatorError;
        }
        this._endOfCenterDir64 = this._esbc.getULong();
        tuint = this._esbc.getUInt();
        if (tuint != 1L) {
            return ZipReturn.Zip64EndOfCentralDirectoryLocatorError;
        }
        return ZipReturn.ZipGood;
    }

    private final void Zip64EndOfCentralDirectoryLocatorWrite() throws IOException {
        this._esbc.putInt(117853008);
        this._esbc.putUInt(0L);
        this._esbc.putULong(this._endOfCenterDir64);
        this._esbc.putUInt(1L);
    }

    private final ZipReturn Zip64EndOfCentralDirRead() throws IOException {
        this._zip64 = true;
        long thisSignature = this._esbc.getInt();
        if (thisSignature != 101075792L) {
            return ZipReturn.ZipEndOfCentralDirectoryError;
        }
        BigInteger tulong = this._esbc.getULong();
        if (tulong.compareTo(BigInteger.valueOf(44L)) != 0) {
            return ZipReturn.Zip64EndOfCentralDirError;
        }
        this._esbc.getShort();
        int tushort = this._esbc.getUShort();
        if (tushort != 45) {
            return ZipReturn.Zip64EndOfCentralDirError;
        }
        long tuint = this._esbc.getUInt();
        if (tuint != 0L) {
            return ZipReturn.Zip64EndOfCentralDirError;
        }
        tuint = this._esbc.getUInt();
        if (tuint != 0L) {
            return ZipReturn.Zip64EndOfCentralDirError;
        }
        this._localFilesCount = this._esbc.getULong();
        tulong = this._esbc.getULong();
        if (tulong != this._localFilesCount) {
            return ZipReturn.Zip64EndOfCentralDirError;
        }
        this._centerDirSize = this._esbc.getULong();
        this._centerDirStart = this._esbc.getULong();
        return ZipReturn.ZipGood;
    }

    private final void Zip64EndOfCentralDirWrite() throws IOException {
        this._esbc.putInt(101075792);
        this._esbc.putULong(BigInteger.valueOf(44L));
        this._esbc.putUShort(45);
        this._esbc.putUShort(45);
        this._esbc.putUInt(0L);
        this._esbc.putUInt(0L);
        this._esbc.putULong(BigInteger.valueOf(this._localFiles.size()));
        this._esbc.putULong(BigInteger.valueOf(this._localFiles.size()));
        this._esbc.putULong(this._centerDirSize);
        this._esbc.putULong(this._centerDirStart);
    }

    @Override
    public final void ZipFileAddDirectory() throws IOException {
        this._localFiles.get(this._localFiles.size() - 1).LocalFileAddDirectory();
    }

    @Override
    public final void ZipFileClose() throws IOException {
        if (this.zipOpen == ZipOpenType.Closed) {
            return;
        }
        if (this.zipOpen == ZipOpenType.OpenRead) {
            this.close();
            this.zipOpen = ZipOpenType.Closed;
            return;
        }
        this._zip64 = false;
        boolean lTrrntzip = true;
        this._centerDirStart = BigInteger.valueOf(this._esbc.position());
        if (this._centerDirStart.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0) {
            this._zip64 = true;
        }
        this._esbc.startChecksum();
        for (LocalFile t : this._localFiles) {
            t.CenteralDirectoryWrite(this._esbc);
            this._zip64 |= t.zip64;
            lTrrntzip &= t._trrntZip;
        }
        this._centerDirSize = BigInteger.valueOf(this._esbc.position() - this._centerDirStart.longValue());
        this._fileComment = lTrrntzip ? String.format("TORRENTZIPPED-%08X", this._esbc.endChecksum()).getBytes(Charset.forName("Cp437")) : new byte[]{};
        EnumSet<ZipStatus> enumSet = this._pZipStatus = lTrrntzip ? EnumSet.of(ZipStatus.TrrntZip) : EnumSet.noneOf(ZipStatus.class);
        if (this._zip64) {
            this._endOfCenterDir64 = BigInteger.valueOf(this._esbc.position());
            this.Zip64EndOfCentralDirWrite();
            this.Zip64EndOfCentralDirectoryLocatorWrite();
        }
        this.EndOfCentralDirWrite();
        this._esbc.truncate(this._esbc.position());
        this.close();
        this.zipOpen = ZipOpenType.Closed;
    }

    @Override
    public final void ZipFileCloseFailed() throws IOException {
        if (this.zipOpen == ZipOpenType.Closed) {
            return;
        }
        if (this.zipOpen == ZipOpenType.OpenRead) {
            this.close();
            this.zipOpen = ZipOpenType.Closed;
            return;
        }
        this.close();
        this._zipFileInfo.delete();
        this._zipFileInfo = null;
        this.zipOpen = ZipOpenType.Closed;
    }

    @Override
    public final ZipReturn ZipFileCloseReadStream() throws IOException {
        return this._localFiles.get(this._readIndex).LocalFileCloseReadStream();
    }

    @Override
    public final ZipReturn ZipFileCloseWriteStream(byte[] crc32) throws IOException {
        return this._localFiles.get(this._localFiles.size() - 1).LocalFileCloseWriteStream(crc32);
    }

    @Override
    public final ZipReturn ZipFileCreate(File newFilename) throws IOException {
        if (this.zipOpen != ZipOpenType.Closed) {
            return ZipReturn.ZipFileAlreadyOpen;
        }
        ZipFile.CreateDirForFile(newFilename);
        this._zipFileInfo = newFilename;
        this._esbc = new EnhancedSeekableByteChannel(Files.newByteChannel(newFilename.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ), ByteOrder.LITTLE_ENDIAN);
        this.zipOpen = ZipOpenType.OpenWrite;
        return ZipReturn.ZipGood;
    }

    @Override
    public final String ZipFilename() {
        return this._zipFileInfo != null ? this._zipFileInfo.getAbsolutePath() : "";
    }

    @Override
    public final ZipReturn ZipFileOpen(File newFilename, long timestamp, boolean readHeaders) throws IOException {
        this.ZipFileClose();
        this._pZipStatus = EnumSet.noneOf(ZipStatus.class);
        this._zip64 = false;
        this._centerDirStart = BigInteger.valueOf(0L);
        this._centerDirSize = BigInteger.valueOf(0L);
        this._zipFileInfo = null;
        try {
            if (!newFilename.exists()) {
                this.ZipFileClose();
                return ZipReturn.ZipErrorFileNotFound;
            }
            this._zipFileInfo = newFilename;
            if (this._zipFileInfo.lastModified() != timestamp) {
                this.ZipFileClose();
                return ZipReturn.ZipErrorTimeStamp;
            }
            this._esbc = new EnhancedSeekableByteChannel(Files.newByteChannel(newFilename.toPath(), StandardOpenOption.READ), ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            this.ZipFileClose();
            return ZipReturn.ZipErrorOpeningFile;
        }
        this.zipOpen = ZipOpenType.OpenRead;
        if (!readHeaders) {
            return ZipReturn.ZipGood;
        }
        try {
            int i;
            ZipReturn zRet = this.FindEndOfCentralDirSignature();
            if (zRet != ZipReturn.ZipGood) {
                this.ZipFileClose();
                return zRet;
            }
            long endOfCentralDir = this._esbc.position();
            zRet = this.EndOfCentralDirRead();
            if (zRet != ZipReturn.ZipGood) {
                this.ZipFileClose();
                return zRet;
            }
            if (this._centerDirStart.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) == 0 || this._centerDirSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) == 0 || this._localFilesCount.compareTo(BigInteger.valueOf(65535L)) == 0) {
                this._zip64 = true;
                this._esbc.position(endOfCentralDir - 20L);
                zRet = this.Zip64EndOfCentralDirectoryLocatorRead();
                if (zRet != ZipReturn.ZipGood) {
                    this.ZipFileClose();
                    return zRet;
                }
                this._esbc.position(this._endOfCenterDir64.longValue());
                zRet = this.Zip64EndOfCentralDirRead();
                if (zRet != ZipReturn.ZipGood) {
                    this.ZipFileClose();
                    return zRet;
                }
            }
            boolean trrntzip = false;
            if (this._fileComment.length == 22 && new String(this._fileComment, Charset.forName("Cp437")).substring(0, 14).equals("TORRENTZIPPED-")) {
                byte[] buffer = new byte[this._centerDirSize.intValue()];
                this._esbc.position(this._centerDirStart.longValue());
                this._esbc.startChecksum();
                this._esbc.get(buffer);
                long r = this._esbc.endChecksum();
                String tcrc = new String(this._fileComment, Charset.forName("Cp437")).substring(14, 22);
                String zcrc = String.format("%08X", r);
                if (tcrc.equalsIgnoreCase(zcrc)) {
                    trrntzip = true;
                }
            }
            this._esbc.position(this._centerDirStart.longValue());
            this._localFiles.clear();
            for (long i2 = 0L; i2 < this._localFilesCount.longValue(); ++i2) {
                LocalFile lc = new LocalFile(this._esbc);
                zRet = lc.CentralDirectoryRead();
                if (zRet != ZipReturn.ZipGood) {
                    this.ZipFileClose();
                    lc.close();
                    return zRet;
                }
                this._zip64 |= lc.zip64;
                this._localFiles.add(lc);
            }
            for (i = 0; i < this._localFilesCount.intValue(); ++i) {
                zRet = this._localFiles.get(i).LocalFileHeaderRead();
                if (zRet != ZipReturn.ZipGood) {
                    this.ZipFileClose();
                    return zRet;
                }
                trrntzip &= this._localFiles.get((int)i)._trrntZip;
            }
            if (trrntzip) {
                for (i = 0; i < this._localFilesCount.intValue() - 1; ++i) {
                    if (this._localFiles.get((int)i).fileName.compareToIgnoreCase(this._localFiles.get((int)(i + 1)).fileName) < 0) continue;
                    trrntzip = false;
                    break;
                }
            }
            if (trrntzip) {
                for (i = 0; i < this._localFilesCount.intValue() - 1; ++i) {
                    String filename1;
                    String filename0 = this._localFiles.get((int)i).fileName;
                    if (filename0.charAt(filename0.length() - 1) != '/' || (filename1 = this._localFiles.get((int)(i + 1)).fileName).length() <= filename0.length() || filename0.compareToIgnoreCase(filename1.substring(0, filename0.length())) != 0) continue;
                    trrntzip = false;
                    break;
                }
            }
            if (trrntzip) {
                this._pZipStatus.add(ZipStatus.TrrntZip);
            }
            return ZipReturn.ZipGood;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ZipFileClose();
            return ZipReturn.ZipErrorReadingFile;
        }
    }

    public final ZipReturn ZipFileOpenReadStream(int index, boolean raw, AtomicReference<InputStream> stream, AtomicReference<BigInteger> streamSize, AtomicInteger compressionMethod) throws IOException {
        streamSize.set(BigInteger.valueOf(0L));
        compressionMethod.set(0);
        this._readIndex = index;
        stream.set(null);
        if (this.zipOpen != ZipOpenType.OpenRead) {
            return ZipReturn.ZipReadingFromOutputFile;
        }
        ZipReturn zRet = this._localFiles.get(index).LocalFileHeaderRead();
        if (zRet != ZipReturn.ZipGood) {
            this.ZipFileClose();
            return zRet;
        }
        return this._localFiles.get(index).LocalFileOpenReadStream(raw, stream, streamSize, compressionMethod, this.inflater);
    }

    public final ZipReturn ZipFileOpenReadStreamQuick(BigInteger pos, boolean raw, AtomicReference<InputStream> stream, AtomicReference<BigInteger> streamSize, AtomicInteger compressionMethod) throws IOException {
        LocalFile tmpFile = new LocalFile(this._esbc);
        tmpFile.LocalFilePos(pos);
        this._localFiles.clear();
        this._localFiles.add(tmpFile);
        ZipReturn zr = tmpFile.LocalFileHeaderReadQuick();
        if (zr != ZipReturn.ZipGood) {
            stream.set(null);
            streamSize.set(BigInteger.valueOf(0L));
            compressionMethod.set(0);
            return zr;
        }
        this._readIndex = 0;
        return tmpFile.LocalFileOpenReadStream(raw, stream, streamSize, compressionMethod, this.inflater);
    }

    @Override
    public final ZipReturn ZipFileOpenWriteStream(boolean raw, boolean trrntzip, String filename, BigInteger uncompressedSize, short compressionMethod, AtomicReference<OutputStream> stream) throws IOException {
        stream.set(null);
        if (this.zipOpen != ZipOpenType.OpenWrite) {
            return ZipReturn.ZipWritingToInputFile;
        }
        LocalFile lf = new LocalFile(this._esbc, filename);
        ZipReturn retVal = lf.LocalFileOpenWriteStream(raw, trrntzip, uncompressedSize, compressionMethod, stream, this.deflater);
        this._localFiles.add(lf);
        return retVal;
    }

    @Override
    public final ZipReturn ZipFileRollBack() throws IOException {
        if (this.zipOpen != ZipOpenType.OpenWrite) {
            return ZipReturn.ZipWritingToInputFile;
        }
        int fileCount = this._localFiles.size();
        if (fileCount == 0) {
            return ZipReturn.ZipErrorRollBackFile;
        }
        LocalFile lf = this._localFiles.get(fileCount - 1);
        this._localFiles.remove(fileCount - 1);
        this._esbc.position(lf.LocalFilePos().longValueExact());
        return ZipReturn.ZipGood;
    }

    @Override
    public final ZipOpenType ZipOpen() {
        return this.zipOpen;
    }

    @Override
    public final EnumSet<ZipStatus> ZipStatus() {
        return this._pZipStatus;
    }

    public static final class LocalFile
    implements Closeable,
    AutoCloseable {
        private BigInteger _compressedSize;
        private int _compressionMethod;
        private long _crc32Location;
        private long _dataLocation;
        private long _extraLocation;
        public int _generalPurposeBitFlag;
        private int _lastModFileDate;
        private int _lastModFileTime;
        private InputStream _readStream;
        public boolean _trrntZip;
        public BigInteger _uncompressedSize;
        private OutputStream _writeStream;
        public byte[] crc;
        private final EnhancedSeekableByteChannel esbc;
        public String fileName;
        public ZipReturn fileStatus = ZipReturn.ZipUntested;
        public BigInteger relativeOffsetOfLocalHeader;
        public boolean zip64;

        public LocalFile(EnhancedSeekableByteChannel esbc) throws IOException {
            this.esbc = esbc;
        }

        public LocalFile(EnhancedSeekableByteChannel esbc, String filename) throws IOException {
            this.zip64 = false;
            this.esbc = esbc;
            this._generalPurposeBitFlag = 2;
            this._compressionMethod = 8;
            this._lastModFileTime = 48128;
            this._lastModFileDate = 8600;
            this.fileName = filename;
        }

        /*
         * WARNING - void declaration
         */
        public final void CenteralDirectoryWrite(EnhancedSeekableByteChannel esbc) throws IOException {
            void var11_23;
            long cdRelativeOffsetOfLocalHeader;
            long cdCompressedSize;
            long cdUncompressedSize;
            int header = 33639248;
            ArrayList<Byte> extraField = new ArrayList<Byte>();
            if (this._uncompressedSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0) {
                this.zip64 = true;
                cdUncompressedSize = 0xFFFFFFFFL;
                for (byte b : ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(UnsignedTypes.fromULong(this._uncompressedSize)).array()) {
                    extraField.add(b);
                }
            } else {
                cdUncompressedSize = UnsignedTypes.fromULong(this._uncompressedSize);
            }
            if (this._compressedSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0) {
                this.zip64 = true;
                cdCompressedSize = 0xFFFFFFFFL;
                for (byte by : ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(UnsignedTypes.fromULong(this._compressedSize)).array()) {
                    extraField.add(by);
                }
            } else {
                cdCompressedSize = UnsignedTypes.fromULong(this._compressedSize);
            }
            if (this.relativeOffsetOfLocalHeader.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0) {
                this.zip64 = true;
                cdRelativeOffsetOfLocalHeader = 0xFFFFFFFFL;
                for (byte by : ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(UnsignedTypes.fromULong(this.relativeOffsetOfLocalHeader)).array()) {
                    extraField.add(by);
                }
            } else {
                cdRelativeOffsetOfLocalHeader = UnsignedTypes.fromULong(this.relativeOffsetOfLocalHeader);
            }
            if (extraField.size() > 0) {
                int exfl = extraField.size();
                boolean bl = false;
                for (byte b : ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(UnsignedTypes.fromUShort(1)).array()) {
                    void var11_19;
                    extraField.add((int)(++var11_19), b);
                }
                for (byte b : ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(UnsignedTypes.fromUShort(exfl)).array()) {
                    void var11_20;
                    extraField.add((int)(++var11_20), b);
                }
            }
            int extraFieldLength = extraField.size();
            if (!Charset.forName("Cp437").newEncoder().canEncode(this.fileName)) {
                this._generalPurposeBitFlag |= 0x800;
                byte[] byArray = this.fileName.getBytes(Charset.forName("UTF8"));
            } else {
                byte[] byArray = this.fileName.getBytes(Charset.forName("Cp437"));
            }
            int fileNameLength = ((void)var11_23).length;
            int n = this.zip64 ? 45 : 20;
            esbc.putInt(33639248);
            esbc.putUShort(0);
            esbc.putUShort(n);
            esbc.putUShort(this._generalPurposeBitFlag);
            esbc.putUShort(this._compressionMethod);
            esbc.putUShort(this._lastModFileTime);
            esbc.putUShort(this._lastModFileDate);
            esbc.put(this.crc);
            esbc.putUInt(cdCompressedSize);
            esbc.putUInt(cdUncompressedSize);
            esbc.putUShort(fileNameLength);
            esbc.putUShort(extraFieldLength);
            esbc.putUShort(0);
            esbc.putUShort(0);
            esbc.putUShort(0);
            esbc.putUInt(0L);
            esbc.putUInt(cdRelativeOffsetOfLocalHeader);
            esbc.put((byte[])var11_23);
            Iterator iterator = extraField.iterator();
            while (iterator.hasNext()) {
                byte b;
                b = (Byte)iterator.next();
                esbc.put(b);
            }
        }

        public final ZipReturn CentralDirectoryRead() {
            try {
                int thisSignature = this.esbc.getInt();
                if (thisSignature != 33639248) {
                    return ZipReturn.ZipCentralDirError;
                }
                this.esbc.getUShort();
                this.esbc.getUShort();
                this._generalPurposeBitFlag = this.esbc.getUShort();
                this._compressionMethod = this.esbc.getUShort();
                if (this._compressionMethod != 8 && this._compressionMethod != 0) {
                    return ZipReturn.ZipUnsupportedCompression;
                }
                this._lastModFileTime = this.esbc.getUShort();
                this._lastModFileDate = this.esbc.getUShort();
                this.crc = this.ReadCRC(this.esbc);
                this._compressedSize = BigInteger.valueOf(this.esbc.getUInt());
                this._uncompressedSize = BigInteger.valueOf(this.esbc.getUInt());
                int fileNameLength = this.esbc.getUShort();
                int extraFieldLength = this.esbc.getUShort();
                int fileCommentLength = this.esbc.getUShort();
                this.esbc.getUShort();
                this.esbc.getUShort();
                this.esbc.getUInt();
                this.relativeOffsetOfLocalHeader = BigInteger.valueOf(this.esbc.getUInt());
                byte[] bFileName = new byte[fileNameLength];
                this.esbc.get(bFileName);
                this.fileName = (this._generalPurposeBitFlag & 0x800) == 0 ? new String(bFileName, Charset.forName("Cp437")) : new String(bFileName, Charset.forName("UTF8"));
                byte[] extraField = new byte[extraFieldLength];
                this.esbc.get(extraField);
                this.esbc.position(this.esbc.position() + (long)fileCommentLength);
                ByteBuffer bb = ByteBuffer.wrap(extraField).order(ByteOrder.LITTLE_ENDIAN);
                block6: while (extraFieldLength > bb.position()) {
                    int type = UnsignedTypes.toUShort(bb.getShort());
                    int blockLength = UnsignedTypes.toUShort(bb.getShort());
                    switch (type) {
                        case 1: {
                            this.zip64 = true;
                            if (this._uncompressedSize.longValue() == 0xFFFFFFFFL) {
                                this._uncompressedSize = UnsignedTypes.toULong(bb.getLong());
                            }
                            if (this._compressedSize.longValue() == 0xFFFFFFFFL) {
                                this._compressedSize = UnsignedTypes.toULong(bb.getLong());
                            }
                            if (this.relativeOffsetOfLocalHeader.longValue() != 0xFFFFFFFFL) continue block6;
                            this.relativeOffsetOfLocalHeader = UnsignedTypes.toULong(bb.getLong());
                            continue block6;
                        }
                        case 28789: {
                            byte version = bb.get();
                            long nameCRC32 = UnsignedTypes.toUInt(bb.getInt());
                            CRC32 crcTest = new CRC32();
                            crcTest.update(bFileName);
                            long fCRC = crcTest.getValue();
                            if (nameCRC32 != fCRC) {
                                return ZipReturn.ZipCentralDirError;
                            }
                            int charLen = blockLength - 5;
                            byte[] dst = new byte[charLen];
                            bb.get(dst);
                            this.fileName = new String(dst, Charset.forName("UTF8"));
                            continue block6;
                        }
                    }
                    bb.position(bb.position() + blockLength);
                }
                return ZipReturn.ZipGood;
            }
            catch (Exception e) {
                e.printStackTrace();
                return ZipReturn.ZipCentralDirError;
            }
        }

        @Override
        public final void close() throws IOException {
            if (this.esbc != null) {
                this.esbc.close();
            }
        }

        public final void LocalFileAddDirectory() throws IOException {
            this.esbc.put((byte)3);
            this.esbc.put((byte)0);
        }

        public final void LocalFileCheck() {
            if (this.fileStatus != ZipReturn.ZipUntested) {
                return;
            }
            try {
                InputStream sInput = null;
                this.esbc.position(this._dataLocation);
                switch (this._compressionMethod) {
                    case 8: {
                        sInput = new InflaterInputStream(this.esbc.getInputStream(), new Inflater(true));
                        break;
                    }
                    case 0: {
                        sInput = this.esbc.getInputStream();
                    }
                }
                if (sInput == null) {
                    this.fileStatus = ZipReturn.ZipErrorGettingDataStream;
                    return;
                }
                int Buffersize = 8192;
                byte[] buffer = new byte[8192];
                BigInteger sizetogo = this._uncompressedSize;
                CRC32 tcrc32 = new CRC32();
                int sizeNext = sizetogo.compareTo(BigInteger.valueOf(8192L)) > 0 ? 8192 : sizetogo.intValue();
                int sizebuffer = sInput.read(buffer, 0, sizeNext);
                sizetogo = sizetogo.subtract(BigInteger.valueOf(sizebuffer));
                while (sizebuffer > 0) {
                    sizeNext = sizetogo.compareTo(BigInteger.valueOf(8192L)) > 0 ? 8192 : sizetogo.intValue();
                    if (sizeNext <= 0 || (sizebuffer = sInput.read(buffer, 0, sizeNext)) <= 0) continue;
                    tcrc32.update(buffer, 0, sizebuffer);
                    sizetogo = sizetogo.subtract(BigInteger.valueOf(sizebuffer));
                }
                if (sizetogo.longValue() > 0L) {
                    this.fileStatus = ZipReturn.ZipDecodeError;
                    return;
                }
                byte[] testcrc = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(UnsignedTypes.fromUInt(tcrc32.getValue())).array();
                this.fileStatus = Arrays.equals(this.crc, testcrc) ? ZipReturn.ZipGood : ZipReturn.ZipCRCDecodeError;
            }
            catch (Exception e) {
                this.fileStatus = ZipReturn.ZipDecodeError;
            }
        }

        public final ZipReturn LocalFileCloseReadStream() throws IOException {
            InputStream dfStream = this._readStream;
            if (dfStream != null) {
                // empty if block
            }
            return ZipReturn.ZipGood;
        }

        public final ZipReturn LocalFileCloseWriteStream(byte[] crc32) throws IOException {
            OutputStream dfStream = this._writeStream;
            if (dfStream != null) {
                dfStream.flush();
            }
            this._compressedSize = BigInteger.valueOf(this.esbc.position() - this._dataLocation);
            if (this._compressedSize.longValue() == 0L && this._uncompressedSize.longValue() == 0L) {
                this.LocalFileAddDirectory();
                this._compressedSize = BigInteger.valueOf(this.esbc.position() - this._dataLocation);
            }
            this.crc = crc32;
            this.WriteCompressedSize();
            return ZipReturn.ZipGood;
        }

        public final ZipReturn LocalFileHeaderRead() {
            try {
                int tshort;
                this._trrntZip = true;
                this.esbc.position(this.relativeOffsetOfLocalHeader.longValueExact());
                int thisSignature = this.esbc.getInt();
                if (thisSignature != 67324752) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                this.esbc.getUShort();
                int generalPurposeBitFlagLocal = this.esbc.getUShort();
                if (generalPurposeBitFlagLocal != this._generalPurposeBitFlag) {
                    this._trrntZip = false;
                }
                if ((tshort = this.esbc.getUShort()) != this._compressionMethod) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                tshort = this.esbc.getUShort();
                if (tshort != this._lastModFileTime) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                tshort = this.esbc.getUShort();
                if (tshort != this._lastModFileDate) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                byte[] tCRC = this.ReadCRC(this.esbc);
                if ((this._generalPurposeBitFlag & 8) == 0 && !Arrays.equals(tCRC, this.crc)) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                long tCompressedSize = this.esbc.getUInt();
                if (this.zip64 && tCompressedSize != 0xFFFFFFFFL && tCompressedSize != this._compressedSize.longValue()) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                if ((this._generalPurposeBitFlag & 8) == 8 && tCompressedSize != 0L) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                if (!this.zip64 && (this._generalPurposeBitFlag & 8) != 8 && tCompressedSize != this._compressedSize.longValue()) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                long tUnCompressedSize = this.esbc.getUInt();
                if (this.zip64 && tUnCompressedSize != 0xFFFFFFFFL && tUnCompressedSize != this._uncompressedSize.longValue()) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                if ((this._generalPurposeBitFlag & 8) == 8 && tUnCompressedSize != 0L) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                if (!this.zip64 && (this._generalPurposeBitFlag & 8) != 8 && tUnCompressedSize != this._uncompressedSize.longValue()) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                int fileNameLength = this.esbc.getUShort();
                int extraFieldLength = this.esbc.getUShort();
                byte[] bFileName = new byte[fileNameLength];
                this.esbc.get(bFileName);
                String tFileName = (generalPurposeBitFlagLocal & 0x800) == 0 ? new String(bFileName, Charset.forName("Cp437")) : new String(bFileName, Charset.forName("UTF8"));
                byte[] extraField = new byte[extraFieldLength];
                this.esbc.get(extraField);
                this.zip64 = false;
                ByteBuffer bb = ByteBuffer.wrap(extraField).order(ByteOrder.LITTLE_ENDIAN);
                block6: while (extraFieldLength > bb.position()) {
                    int type = UnsignedTypes.toUShort(bb.getShort());
                    int blockLength = UnsignedTypes.toUShort(bb.getShort());
                    switch (type) {
                        case 1: {
                            BigInteger tLong;
                            this.zip64 = true;
                            if (tUnCompressedSize == 0xFFFFFFFFL && (tLong = UnsignedTypes.toULong(bb.getLong())).compareTo(this._uncompressedSize) != 0) {
                                return ZipReturn.ZipLocalFileHeaderError;
                            }
                            if (tCompressedSize != 0xFFFFFFFFL || (tLong = UnsignedTypes.toULong(bb.getLong())).compareTo(this._compressedSize) == 0) continue block6;
                            return ZipReturn.ZipLocalFileHeaderError;
                        }
                        case 28789: {
                            byte version = bb.get();
                            long nameCRC32 = UnsignedTypes.toUInt(bb.getInt());
                            CRC32 crcTest = new CRC32();
                            crcTest.update(bFileName);
                            long fCRC = crcTest.getValue();
                            if (nameCRC32 != fCRC) {
                                return ZipReturn.ZipLocalFileHeaderError;
                            }
                            int charLen = blockLength - 5;
                            byte[] dst = new byte[charLen];
                            bb.get(dst);
                            this.fileName = new String(dst, Charset.forName("UTF8"));
                            break;
                        }
                        default: {
                            bb.position(bb.position() + blockLength);
                        }
                    }
                }
                if (!this.fileName.equals(tFileName)) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                this._dataLocation = this.esbc.position();
                if ((this._generalPurposeBitFlag & 8) == 0) {
                    return ZipReturn.ZipGood;
                }
                this.esbc.position(this.esbc.position() + this._compressedSize.longValue());
                tCRC = this.ReadCRC(this.esbc);
                if (!Arrays.equals(tCRC, new byte[]{80, 75, 7, 8})) {
                    tCRC = this.ReadCRC(this.esbc);
                }
                if (!Arrays.equals(tCRC, this.crc)) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                long tint = this.esbc.getUInt();
                if (tint != this._compressedSize.longValue()) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                tint = this.esbc.getUInt();
                if (tint != this._uncompressedSize.longValue()) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                return ZipReturn.ZipGood;
            }
            catch (Exception e) {
                e.printStackTrace();
                return ZipReturn.ZipLocalFileHeaderError;
            }
        }

        public final ZipReturn LocalFileHeaderReadQuick() {
            try {
                this._trrntZip = true;
                this.esbc.position(this.relativeOffsetOfLocalHeader.longValue());
                int thisSignature = this.esbc.getInt();
                if (thisSignature != 67324752) {
                    return ZipReturn.ZipLocalFileHeaderError;
                }
                this.esbc.getShort();
                this._generalPurposeBitFlag = this.esbc.getUShort();
                if ((this._generalPurposeBitFlag & 8) == 8) {
                    return ZipReturn.ZipCannotFastOpen;
                }
                this._compressionMethod = this.esbc.getUShort();
                this._lastModFileTime = this.esbc.getUShort();
                this._lastModFileDate = this.esbc.getUShort();
                this.crc = this.ReadCRC(this.esbc);
                this._compressedSize = BigInteger.valueOf(this.esbc.getUInt());
                this._uncompressedSize = BigInteger.valueOf(this.esbc.getUInt());
                int fileNameLength = this.esbc.getUShort();
                int extraFieldLength = this.esbc.getUShort();
                byte[] bFileName = new byte[fileNameLength];
                this.esbc.get(bFileName);
                String tFileName = (this._generalPurposeBitFlag & 0x800) == 0 ? new String(bFileName, Charset.forName("Cp437")) : new String(bFileName, Charset.forName("UTF8"));
                byte[] extraField = new byte[extraFieldLength];
                this.esbc.get(extraField);
                this.zip64 = false;
                ByteBuffer bb = ByteBuffer.wrap(extraField).order(ByteOrder.LITTLE_ENDIAN);
                block6: while (extraFieldLength > bb.position()) {
                    int type = UnsignedTypes.toUShort(bb.getShort());
                    int blockLength = UnsignedTypes.toUShort(bb.getShort());
                    switch (type) {
                        case 1: {
                            this.zip64 = true;
                            if (this._uncompressedSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) == 0) {
                                this._uncompressedSize = UnsignedTypes.toULong(bb.getLong());
                            }
                            if (this._compressedSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) != 0) continue block6;
                            this._compressedSize = UnsignedTypes.toULong(bb.getLong());
                            continue block6;
                        }
                        case 28789: {
                            byte version = bb.get();
                            long nameCRC32 = UnsignedTypes.toUInt(bb.getInt());
                            CRC32 crcTest = new CRC32();
                            crcTest.update(bFileName);
                            long fCRC = crcTest.getValue();
                            if (nameCRC32 != fCRC) {
                                return ZipReturn.ZipLocalFileHeaderError;
                            }
                            int charLen = blockLength - 5;
                            byte[] dst = new byte[charLen];
                            bb.get(dst);
                            this.fileName = new String(dst, Charset.forName("UTF8"));
                            continue block6;
                        }
                    }
                    bb.position(bb.position() + blockLength);
                }
                this._dataLocation = this.esbc.position();
                return ZipReturn.ZipGood;
            }
            catch (Exception e) {
                e.printStackTrace();
                return ZipReturn.ZipLocalFileHeaderError;
            }
        }

        private final void LocalFileHeaderWrite() throws IOException {
            byte[] bFileName;
            ArrayList<Byte> extraField = new ArrayList<Byte>();
            boolean bl = this.zip64 = this._uncompressedSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0;
            if (this.zip64) {
                new Exception().printStackTrace();
            }
            if (!Charset.forName("Cp437").newEncoder().canEncode(this.fileName)) {
                this._generalPurposeBitFlag |= 0x800;
                bFileName = this.fileName.getBytes(Charset.forName("UTF8"));
            } else {
                bFileName = this.fileName.getBytes(Charset.forName("Cp437"));
            }
            int versionNeededToExtract = this.zip64 ? 45 : 20;
            this.relativeOffsetOfLocalHeader = BigInteger.valueOf(this.esbc.position());
            int header = 67324752;
            this.esbc.putUInt(67324752L);
            this.esbc.putUShort(versionNeededToExtract);
            this.esbc.putUShort(this._generalPurposeBitFlag);
            this.esbc.putUShort(this._compressionMethod);
            this.esbc.putUShort(this._lastModFileTime);
            this.esbc.putUShort(this._lastModFileDate);
            this._crc32Location = this.esbc.position();
            this.esbc.putUInt(0xFFFFFFFFL);
            this.esbc.putUInt(0xFFFFFFFFL);
            this.esbc.putUInt(0xFFFFFFFFL);
            if (this.zip64) {
                for (int i = 0; i < 20; ++i) {
                    extraField.add((byte)0);
                }
            }
            int fileNameLength = bFileName.length;
            this.esbc.putUShort(fileNameLength);
            int extraFieldLength = extraField.size();
            this.esbc.putUShort(extraFieldLength);
            this.esbc.put(bFileName);
            this._extraLocation = this.esbc.position();
            Iterator iterator = extraField.iterator();
            while (iterator.hasNext()) {
                byte b = (Byte)iterator.next();
                this.esbc.put(b);
            }
        }

        public final ZipReturn LocalFileOpenReadStream(boolean raw, AtomicReference<InputStream> stream, AtomicReference<BigInteger> streamSize, AtomicInteger compressionMethod, AtomicReference<Inflater> inflater) throws IOException {
            streamSize.set(BigInteger.valueOf(0L));
            compressionMethod.set(this._compressionMethod);
            this._readStream = null;
            this.esbc.position(this._dataLocation);
            switch (this._compressionMethod) {
                case 8: {
                    if (raw) {
                        this._readStream = new BoundedInputStream(this.esbc.getInputStream(), this._compressedSize.longValue());
                        streamSize.set(this._compressedSize);
                        break;
                    }
                    if (inflater.get() == null) {
                        inflater.set(new Inflater(true));
                    } else {
                        inflater.get().reset();
                    }
                    this._readStream = new InflaterInputStream(this.esbc.getInputStream(), inflater.get());
                    streamSize.set(this._uncompressedSize);
                    break;
                }
                case 0: {
                    this._readStream = new BoundedInputStream(this.esbc.getInputStream(), this._compressedSize.longValue());
                    streamSize.set(this._compressedSize);
                }
            }
            stream.set(this._readStream);
            return stream.get() == null ? ZipReturn.ZipErrorGettingDataStream : ZipReturn.ZipGood;
        }

        public final ZipReturn LocalFileOpenWriteStream(boolean raw, boolean trrntZip, BigInteger uncompressedSize, int compressionMethod, AtomicReference<OutputStream> stream, AtomicReference<Deflater> deflater) throws IOException {
            this._uncompressedSize = uncompressedSize;
            this._compressionMethod = compressionMethod;
            this.LocalFileHeaderWrite();
            this._dataLocation = this.esbc.position();
            if (raw) {
                this._writeStream = this.esbc.getOutputStream();
                this._trrntZip = trrntZip;
            } else if (compressionMethod == 0) {
                this._writeStream = this.esbc.getOutputStream();
                this._trrntZip = false;
            } else {
                if (deflater.get() == null) {
                    deflater.set(new Deflater(9, true));
                } else {
                    deflater.get().reset();
                }
                this._writeStream = new DeflaterOutputStream(this.esbc.getOutputStream(), deflater.get(), false);
                this._trrntZip = true;
            }
            stream.set(this._writeStream);
            return stream.get() == null ? ZipReturn.ZipErrorGettingDataStream : ZipReturn.ZipGood;
        }

        public final BigInteger LocalFilePos() {
            return this.relativeOffsetOfLocalHeader;
        }

        public final void LocalFilePos(BigInteger value) {
            this.relativeOffsetOfLocalHeader = value;
        }

        private final byte[] ReadCRC(EnhancedSeekableByteChannel esbc) throws IOException {
            return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(esbc.getInt()).array();
        }

        private final void WriteCompressedSize() throws IOException {
            long tUncompressedSize;
            long tCompressedSize;
            long posNow = this.esbc.position();
            this.esbc.position(this._crc32Location);
            if (this.zip64) {
                tCompressedSize = 0xFFFFFFFFL;
                tUncompressedSize = 0xFFFFFFFFL;
            } else {
                tCompressedSize = this._compressedSize.longValue();
                tUncompressedSize = this._uncompressedSize.longValue();
            }
            this.esbc.put(this.crc);
            this.esbc.putUInt(tCompressedSize);
            this.esbc.putUInt(tUncompressedSize);
            if (this.zip64) {
                this.esbc.position(this._extraLocation);
                this.esbc.putUShort(1);
                this.esbc.putUShort(16);
                this.esbc.putULong(this._uncompressedSize);
                this.esbc.putULong(this._compressedSize);
            }
            this.esbc.position(posNow);
        }
    }
}

