/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.manager;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jrm.locale.Messages;
import jrm.misc.HTMLRenderer;
import jrm.profile.Profile;
import jrm.profile.manager.Dir;
import jrm.profile.manager.ProfileNFO;
import org.apache.commons.io.FilenameUtils;

public class FileTableModel
extends AbstractTableModel
implements HTMLRenderer {
    public Dir curr_dir = null;
    private final String[] columns = new String[]{Messages.getString("FileTableModel.Profile"), Messages.getString("FileTableModel.Version"), Messages.getString("FileTableModel.HaveSets"), Messages.getString("FileTableModel.HaveRoms"), Messages.getString("FileTableModel.HaveDisks"), Messages.getString("FileTableModel.Created"), Messages.getString("FileTableModel.Scanned"), Messages.getString("FileTableModel.Fixed")};
    private final Class<?>[] columnsClass = new Class[]{Object.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    public int[] columnsWidths = new int[]{100, 50, -14, -14, -9, -19, -19, -19};
    private final List<ProfileNFO> rows = new ArrayList<ProfileNFO>();

    public FileTableModel(Dir dir) {
        this.populate(dir);
    }

    public FileTableModel() {
    }

    public void populate() {
        this.populate(this.curr_dir);
    }

    public void populate(Dir dir) {
        this.curr_dir = dir;
        this.rows.clear();
        if (dir != null && dir.getFile().exists()) {
            Arrays.asList(dir.getFile().listFiles((dir1, name) -> {
                File f = new File(dir1, name);
                return f.isFile() && !Arrays.asList("cache", "properties", "nfo", "jrm1", "jrm2").contains(FilenameUtils.getExtension(name));
            })).stream().map(f -> ProfileNFO.load(f)).forEach(pnfo -> this.rows.add((ProfileNFO)pnfo));
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    public File getFileAt(int row) {
        return this.getNfoAt((int)row).file;
    }

    public ProfileNFO getNfoAt(int row) {
        return this.rows.get(row);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ProfileNFO pnfo = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return pnfo.name;
            }
            case 1: {
                return this.toHTML(pnfo.stats.version == null ? this.toGray("???") : this.toNoBR(pnfo.stats.version));
            }
            case 2: {
                return this.toHTML(pnfo.stats.haveSets == null ? (pnfo.stats.totalSets == null ? this.toGray("?/?") : String.format("%s/%d", this.toGray("?"), pnfo.stats.totalSets)) : String.format("%s/%d", pnfo.stats.haveSets == 0L && pnfo.stats.totalSets > 0L ? this.toRed("0") : (pnfo.stats.haveSets.equals(pnfo.stats.totalSets) ? this.toGreen(pnfo.stats.haveSets + "") : this.toOrange(pnfo.stats.haveSets + "")), pnfo.stats.totalSets));
            }
            case 3: {
                return this.toHTML(pnfo.stats.haveRoms == null ? (pnfo.stats.totalRoms == null ? this.toGray("?/?") : String.format("%s/%d", this.toGray("?"), pnfo.stats.totalRoms)) : String.format("%s/%d", pnfo.stats.haveRoms == 0L && pnfo.stats.totalRoms > 0L ? this.toRed("0") : (pnfo.stats.haveRoms.equals(pnfo.stats.totalRoms) ? this.toGreen(pnfo.stats.haveRoms + "") : this.toOrange(pnfo.stats.haveRoms + "")), pnfo.stats.totalRoms));
            }
            case 4: {
                return this.toHTML(pnfo.stats.haveDisks == null ? (pnfo.stats.totalDisks == null ? this.toGray("?/?") : String.format("%s/%d", this.toGray("?"), pnfo.stats.totalDisks)) : String.format("%s/%d", pnfo.stats.haveDisks == 0L && pnfo.stats.totalDisks > 0L ? this.toRed("0") : (pnfo.stats.haveDisks.equals(pnfo.stats.totalDisks) ? this.toGreen(pnfo.stats.haveDisks + "") : this.toOrange(pnfo.stats.haveDisks + "")), pnfo.stats.totalDisks));
            }
            case 5: {
                return this.toHTML(pnfo.stats.created == null ? this.toGray("????-??-?? ??:??:??") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(pnfo.stats.created));
            }
            case 6: {
                return this.toHTML(pnfo.stats.scanned == null ? this.toGray("????-??-?? ??:??:??") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(pnfo.stats.scanned));
            }
            case 7: {
                return this.toHTML(pnfo.stats.fixed == null ? this.toGray("????-??-?? ??:??:??") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(pnfo.stats.fixed));
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            ProfileNFO pnfo = this.rows.get(rowIndex);
            Arrays.asList("", ".properties", ".cache").forEach(ext -> {
                File oldfile = new File(this.curr_dir.getFile(), pnfo.name + ext);
                File newfile = new File(this.curr_dir.getFile(), aValue + ext);
                oldfile.renameTo(newfile);
            });
            File new_nfo_file = new File(this.curr_dir.getFile(), aValue.toString());
            if (Profile.curr_profile != null && Profile.curr_profile.nfo.file.equals(pnfo.file)) {
                Profile.curr_profile.nfo.relocate(new_nfo_file);
            }
            pnfo.relocate(new_nfo_file);
            this.fireTableCellUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnsClass[columnIndex];
    }
}

