/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.file;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.dialogs.basics.file.DirectoryTreeNode;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import com.jgoodies.layout.builder.FormBuilder;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public final class DirectoryChooserView
extends Bean {
    public static final String PROPERTY_SELECTED_DIRECTORY = "selectedDirectory";
    public static final String PROPERTY_SELECTED_NODE = "selectedNode";
    public static final String PROPERTY_LEAF_SELECTION_ALLOWED = "leafSelectionAllowed";
    public static final String PROPERTY_SELECTION_VALID = "selectionValid";
    private final FileSystemView fileSystemView;
    private boolean leafSelectionAllowed;
    private DirectoryTreeNode selectedNode;
    private File selectedDirectory = null;
    private boolean selectionValid;
    private JTree directoryTree;

    public DirectoryChooserView(FileSystemView fileSystemView) {
        this.fileSystemView = fileSystemView;
        this.initComponents();
        this.initEventHandling();
    }

    private void initComponents() {
        DirectoryTreeNode root = DirectoryTreeNode.createRoot(this.fileSystemView);
        this.directoryTree = new JTree(root);
        this.directoryTree.setRootVisible(false);
        this.directoryTree.setShowsRootHandles(true);
        this.directoryTree.getSelectionModel().setSelectionMode(1);
        if (root.getChildCount() == 1) {
            this.directoryTree.expandRow(0);
        }
        this.directoryTree.setSelectionRow(0);
        this.setCellRenderer(new DefaultDirectoryTreeRenderer(this.fileSystemView));
    }

    private void initEventHandling() {
        this.directoryTree.addMouseListener(Listeners.mouseDoubleClicked(this::onMouseDoubleClicked));
        this.directoryTree.getSelectionModel().addTreeSelectionListener(this::onTreeSelectionChanged);
        this.directoryTree.addTreeWillExpandListener(new DirectoryTreeWillExpandListener());
    }

    public JTree getTree() {
        return this.directoryTree;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.getTree().getCellRenderer();
    }

    public void setCellRenderer(TreeCellRenderer cellRenderer) {
        Preconditions.checkNotNull(cellRenderer, "The %s must not be null.", "tree cell renderer");
        this.getTree().setCellRenderer(cellRenderer);
    }

    public TreeModel getDataModel() {
        return this.getTree().getModel();
    }

    public TreeSelectionModel getSelectionModel() {
        return this.getTree().getSelectionModel();
    }

    public File getSelectedDirectory() {
        return this.selectedDirectory;
    }

    public String getSelectedDirectorySystemDisplayName() {
        return this.fileSystemView.getSystemDisplayName(this.selectedDirectory);
    }

    private void setSelectedDirectory(File newValue) {
        File oldValue = this.getSelectedDirectory();
        this.selectedDirectory = newValue;
        this.firePropertyChange(PROPERTY_SELECTED_DIRECTORY, oldValue, newValue);
    }

    private DirectoryTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    private void setSelectedNode(DirectoryTreeNode newValue) {
        DirectoryTreeNode oldValue = this.getSelectedNode();
        this.selectedNode = newValue;
        this.firePropertyChange(PROPERTY_SELECTED_NODE, oldValue, newValue);
        this.setSelectedDirectory(newValue == null ? null : newValue.getDirectory());
    }

    public boolean isSelectionEmpty() {
        return this.selectedNode == null;
    }

    public boolean hasSelection() {
        return !this.isSelectionEmpty();
    }

    public boolean isSelectionValid() {
        return this.selectionValid;
    }

    private void setSelectionValid(boolean newValue) {
        boolean oldValue = this.isSelectionValid();
        this.selectionValid = newValue;
        this.firePropertyChange(PROPERTY_SELECTION_VALID, oldValue, newValue);
    }

    public boolean isLeafSelectionAllowed() {
        return this.leafSelectionAllowed;
    }

    public void setLeafSelectionAllowed(boolean newValue) {
        boolean oldValue = this.isLeafSelectionAllowed();
        this.leafSelectionAllowed = newValue;
        this.firePropertyChange(PROPERTY_LEAF_SELECTION_ALLOWED, oldValue, newValue);
    }

    public JComponent buildContent() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:200dlu:grow", new Object[0])).rows("f:175dlu:g", new Object[0])).addScrolled(this.directoryTree).xy(1, 1)).build();
    }

    private void onTreeSelectionChanged(TreeSelectionEvent evt) {
        TreePath newLeadSelectionPath = evt.getNewLeadSelectionPath();
        if (newLeadSelectionPath == null) {
            this.setSelectedNode(null);
            this.setSelectionValid(false);
            return;
        }
        this.setSelectedNode((DirectoryTreeNode)evt.getPath().getLastPathComponent());
        boolean hasChildren = this.leafSelectionAllowed || this.getSelectedNode().getChildCount() > 0;
        this.setSelectionValid(hasChildren && this.selectedNode.isFileSystem());
    }

    private void onMouseDoubleClicked(MouseEvent evt) {
        if (this.isSelectionValid()) {
            JSDLUtils.closePaneFor(evt);
        }
    }

    static final class DefaultDirectoryTreeRenderer
    extends DefaultTreeCellRenderer {
        private final FileSystemView fileSystemView;

        DefaultDirectoryTreeRenderer(FileSystemView fileSystemView) {
            this.fileSystemView = fileSystemView;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean focused) {
            super.getTreeCellRendererComponent(tree, value, isSelected, expanded, false, row, focused);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (null == userObject || !(userObject instanceof File)) {
                return this;
            }
            File directory = (File)userObject;
            this.setText(this.fileSystemView.getSystemDisplayName(directory));
            this.setIcon(this.fileSystemView.getSystemIcon(directory));
            return this;
        }
    }

    static final class DirectoryTreeWillExpandListener
    implements TreeWillExpandListener {
        DirectoryTreeWillExpandListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeWillExpand(TreeExpansionEvent evt) {
            JTree source = (JTree)evt.getSource();
            DirectoryTreeNode node = (DirectoryTreeNode)evt.getPath().getLastPathComponent();
            try {
                source.setCursor(Cursor.getPredefinedCursor(3));
                node.loadChildren();
            }
            finally {
                source.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) {
        }
    }
}

