/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.SyncSpec;
import org.gradle.api.internal.file.DefaultConfigurableFilePermissions;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;

public class DefaultFileSystemOperations
implements FileSystemOperations {
    private final Instantiator instantiator;
    private final FileOperations fileOperations;

    public DefaultFileSystemOperations(Instantiator instantiator, FileOperations fileOperations) {
        this.instantiator = instantiator;
        this.fileOperations = fileOperations;
    }

    public CopySpec copySpec(Action<? super CopySpec> action) {
        return (CopySpec)Actions.with((Object)this.copySpec(), action);
    }

    public CopySpec copySpec() {
        return this.fileOperations.copySpec();
    }

    public WorkResult copy(Action<? super CopySpec> action) {
        return this.fileOperations.copy(action);
    }

    public WorkResult sync(Action<? super SyncSpec> action) {
        return this.fileOperations.sync(action);
    }

    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.fileOperations.delete(action);
    }

    public ConfigurableFilePermissions filePermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        return this.permissions(false, configureAction);
    }

    public ConfigurableFilePermissions directoryPermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        return this.permissions(true, configureAction);
    }

    public ConfigurableFilePermissions permissions(String unixNumericOrSymbolic) {
        return this.permissions(false, (Action<? super ConfigurableFilePermissions>)((Action)filePermissions -> filePermissions.unix(unixNumericOrSymbolic)));
    }

    public ConfigurableFilePermissions permissions(int unixNumeric) {
        return this.permissions(false, (Action<? super ConfigurableFilePermissions>)((Action)filePermissions -> filePermissions.unix(unixNumeric)));
    }

    public Provider<ConfigurableFilePermissions> permissions(Provider<String> permissions) {
        return permissions.map(SerializableLambdas.transformer(this::permissions));
    }

    private ConfigurableFilePermissions permissions(boolean directory, Action<? super ConfigurableFilePermissions> configureAction) {
        ConfigurableFilePermissions permissions = (ConfigurableFilePermissions)this.instantiator.newInstance(DefaultConfigurableFilePermissions.class, new Object[]{DefaultConfigurableFilePermissions.getDefaultUnixNumeric((boolean)directory)});
        configureAction.execute((Object)permissions);
        return permissions;
    }
}

