/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.analysis.LevelFacet;
import pcgen.cdom.facet.base.AbstractListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PCTemplate;

public class ConditionalTemplateFacet
extends AbstractListFacet<CharID, PCTemplate>
implements DataFacetChangeListener<CharID, PCTemplate>,
LevelFacet.LevelChangeListener {
    private TemplateFacet templateFacet;
    private LevelFacet levelFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, PCTemplate> dfce) {
        CharID id = dfce.getCharID();
        int totalLevels = this.levelFacet.getTotalLevels(id);
        int totalHitDice = this.levelFacet.getMonsterLevelCount(id);
        PCTemplate source = dfce.getCDOMObject();
        this.addAll(id, source.getConditionalTemplates(totalLevels, totalHitDice));
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, PCTemplate> dfce) {
        CharID id = dfce.getCharID();
        int totalLevels = this.levelFacet.getTotalLevels(id);
        int totalHitDice = this.levelFacet.getMonsterLevelCount(id);
        PCTemplate source = dfce.getCDOMObject();
        this.removeAll(dfce.getCharID(), source.getConditionalTemplates(totalLevels, totalHitDice));
    }

    @Override
    public void levelChanged(LevelFacet.LevelChangeEvent lce) {
        CharID id = lce.getCharID();
        Collection oldSet = this.getSet(id);
        int totalLevels = this.levelFacet.getTotalLevels(id);
        int totalHitDice = this.levelFacet.getMonsterLevelCount(id);
        IdentityHashMap<PCTemplate, PCTemplate> newMap = new IdentityHashMap<PCTemplate, PCTemplate>();
        for (PCTemplate pCTemplate : this.templateFacet.getSet(id)) {
            List<PCTemplate> conditionalTemplates = pCTemplate.getConditionalTemplates(totalLevels, totalHitDice);
            for (PCTemplate condTempl : conditionalTemplates) {
                newMap.put(condTempl, pCTemplate);
            }
        }
        for (PCTemplate pCTemplate : oldSet) {
            if (newMap.containsKey(pCTemplate)) continue;
            this.remove(id, pCTemplate);
        }
        for (Map.Entry entry : newMap.entrySet()) {
            PCTemplate a = (PCTemplate)entry.getKey();
            boolean found = false;
            for (PCTemplate pcTemplate : oldSet) {
                if (a != pcTemplate) continue;
                found = true;
            }
            if (found) continue;
            this.add(id, a);
        }
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void setLevelFacet(LevelFacet levelFacet) {
        this.levelFacet = levelFacet;
    }

    public void init() {
        this.addDataFacetChangeListener(this.templateFacet);
        this.templateFacet.addDataFacetChangeListener(this);
    }
}

