/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.BonusSkillRankChangeFacet;
import pcgen.cdom.facet.SkillRankFacet;
import pcgen.cdom.facet.base.AbstractStorageFacet;
import pcgen.cdom.facet.event.AssociationChangeEvent;
import pcgen.cdom.facet.event.AssociationChangeListener;
import pcgen.core.Skill;

public class TotalSkillRankFacet
extends AbstractStorageFacet<CharID>
implements SkillRankFacet.SkillRankChangeListener,
BonusSkillRankChangeFacet.SkillRankChangeListener {
    private static final Double DOUBLE_ZERO = 0.0;
    private SkillRankFacet skillRankFacet;
    private BonusSkillRankChangeFacet bonusSkillRankChangeFacet;
    private AssociationChangeSupport support;

    public void set(CharID id, Skill sk, Double rank) {
        boolean isNew;
        if (sk == null) {
            throw new IllegalArgumentException("Skill cannot be null");
        }
        if (rank == null) {
            throw new IllegalArgumentException("Rank cannot be null");
        }
        Map<Skill, Double> map = this.getConstructingInfo(id);
        Double currentRank = map.get(sk);
        boolean bl = isNew = currentRank == null || rank.doubleValue() != currentRank.doubleValue();
        if (isNew) {
            map.put(sk, rank);
            if (this.support != null) {
                this.support.fireAssociationChange(id, sk, currentRank, rank);
            }
        }
    }

    public void remove(CharID id, Skill sk) {
        if (sk == null) {
            throw new IllegalArgumentException("Skill cannot be null");
        }
        Map<Skill, Double> map = this.getInfo(id);
        if (map == null) {
            return;
        }
        Double currentRank = map.get(sk);
        if (currentRank == null) {
            return;
        }
        if (this.support != null) {
            this.support.fireAssociationChange(id, sk, currentRank, DOUBLE_ZERO);
        }
    }

    @Override
    public void copyContents(CharID source, CharID copy) {
        Map<Skill, Double> map = this.getInfo(source);
        if (map != null) {
            this.getConstructingInfo(copy).putAll(map);
        }
    }

    public Double get(CharID id, Skill obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object for getting association may not be null");
        }
        Map<Skill, Double> map = this.getInfo(id);
        if (map != null) {
            return map.get(obj);
        }
        return null;
    }

    public void addAssociationChangeListener(AssociationChangeListener listener) {
        if (this.support == null) {
            this.support = new AssociationChangeSupport(this);
        }
        this.support.addAssociationChangeListener(listener);
    }

    public void removeAssociationChangeListener(AssociationChangeListener listener) {
        if (this.support == null) {
            this.support = new AssociationChangeSupport(this);
        }
        this.support.removeAssociationChangeListener(listener);
    }

    private Map<Skill, Double> getConstructingInfo(CharID id) {
        Map<Skill, Double> map = this.getInfo(id);
        if (map == null) {
            map = new IdentityHashMap<Skill, Double>();
            this.setCache(id, map);
        }
        return map;
    }

    private Map<Skill, Double> getInfo(CharID id) {
        return (Map)this.getCache(id);
    }

    @Override
    public void bonusChange(BonusSkillRankChangeFacet.SkillRankChangeEvent srce) {
        CharID id = srce.getCharID();
        Skill skill = srce.getSkill();
        double newBonus = srce.getNewVal().doubleValue();
        float rank = this.skillRankFacet.getRank(id, skill);
        this.set(id, skill, (double)rank + newBonus);
    }

    @Override
    public void rankChanged(SkillRankFacet.SkillRankChangeEvent srce) {
        CharID id = srce.getCharID();
        Skill skill = srce.getSkill();
        float newRank = srce.getNewRank();
        double bonus = this.bonusSkillRankChangeFacet.getRank(id, skill);
        this.set(id, skill, (double)newRank + bonus);
    }

    public void init() {
        this.skillRankFacet.addSkillRankChangeListener(this);
        this.bonusSkillRankChangeFacet.addSkillRankChangeListener(this);
    }

    public void setSkillRankFacet(SkillRankFacet skillRankFacet) {
        this.skillRankFacet = skillRankFacet;
    }

    public void setBonusSkillRankChangeFacet(BonusSkillRankChangeFacet bonusSkillRankChangeFacet) {
        this.bonusSkillRankChangeFacet = bonusSkillRankChangeFacet;
    }

    public static class AssociationChangeSupport {
        private final Object source;
        private List<AssociationChangeListener> listeners = new ArrayList<AssociationChangeListener>();

        public AssociationChangeSupport(Object src) {
            this.source = src;
        }

        public synchronized void addAssociationChangeListener(AssociationChangeListener listener) {
            this.listeners.add(listener);
        }

        public synchronized void removeAssociationChangeListener(AssociationChangeListener listener) {
            this.listeners.remove(listener);
        }

        public synchronized AssociationChangeListener[] getAssociationChangeListeners() {
            return this.listeners.toArray(new AssociationChangeListener[0]);
        }

        public void fireAssociationChange(CharID id, Skill skill, Number oldValue, Number newValue) {
            AssociationChangeEvent bce = new AssociationChangeEvent(id, skill, oldValue, newValue, this.source);
            for (AssociationChangeListener target : this.listeners) {
                target.bonusChange(bce);
            }
        }
    }
}

