/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.SpellResistance;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialProperty;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.EquipModFacade;
import pcgen.util.Delta;

public final class EquipmentModifier
extends PObject
implements Comparable<Object>,
EquipModFacade {
    private static final String PERCENT_CHOICE_PATTERN = Pattern.quote("%CHOICE");
    private static final Formula CHOICE_FORMULA = FormulaFactory.getFormulaFor("%CHOICE");

    public List<BonusObj> getActiveBonuses(Equipment caller, PlayerCharacter aPC) {
        ArrayList<BonusObj> aList = new ArrayList<BonusObj>();
        for (BonusObj bonus : this.getBonusList(caller)) {
            if (!PrereqHandler.passesAll(bonus.getPrerequisiteList(), caller, aPC)) continue;
            aPC.setApplied(bonus, true);
            aList.add(bonus);
        }
        return aList;
    }

    @Override
    public List<BonusObj> getBonusList(PlayerCharacter pc) {
        throw new UnsupportedOperationException("Cannot resolve bonuses on EqMod via PlayerCharacter - requires Equipment");
    }

    @Override
    public List<BonusObj> getBonusList(Equipment e) {
        return this.getBonusList(super.getBonusList(e), e.getAssociationList(this));
    }

    private List<BonusObj> getBonusList(List<BonusObj> bonusList, List<String> associations) {
        ArrayList<BonusObj> myBonusList = new ArrayList<BonusObj>(bonusList);
        for (int i = myBonusList.size() - 1; i > -1; --i) {
            BonusObj aBonus = myBonusList.get(i);
            String aString = aBonus.toString();
            int idx = aString.indexOf("%CHOICE");
            if (idx < 0) continue;
            for (String assoc : associations) {
                BonusObj newBonus = Bonus.newBonus(Globals.getContext(), aString.replaceAll(PERCENT_CHOICE_PATTERN, assoc));
                if (aBonus.hasPrerequisites()) {
                    newBonus.clearPrerequisiteList();
                    for (Prerequisite prereq : aBonus.getPrerequisiteList()) {
                        try {
                            newBonus.addPrerequisite(prereq.specify(assoc));
                        }
                        catch (CloneNotSupportedException e) {}
                    }
                }
                myBonusList.add(newBonus);
            }
            myBonusList.remove(aBonus);
        }
        return myBonusList;
    }

    public boolean isIType(String aType) {
        for (String s : this.getSafeListFor(ListKey.ITEM_TYPES)) {
            if (!aType.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public List<String> getSpecialProperties(Equipment caller, PlayerCharacter pc) {
        ArrayList<String> retList = new ArrayList<String>();
        for (SpecialProperty sp : this.getSafeListFor(ListKey.SPECIAL_PROPERTIES)) {
            String propName = sp.getParsedText(pc, caller, this);
            for (String assoc : caller.getAssociationList(this)) {
                propName = propName.replaceFirst("%CHOICE", assoc);
            }
            if (propName == null || propName.equals("")) continue;
            retList.add(propName);
        }
        return retList;
    }

    public double bonusTo(PlayerCharacter aPC, String aType, String aName, Equipment obj) {
        return BonusCalc.bonusTo(this, aType, aName, obj, this.getBonusList(obj), aPC);
    }

    @Override
    public EquipmentModifier clone() {
        EquipmentModifier aObj = null;
        try {
            aObj = (EquipmentModifier)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            ShowMessageDelegate.showMessageDialog(exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        return aObj;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public int getSR(Equipment parent, PlayerCharacter aPC) {
        SpellResistance sr = this.get(ObjectKey.SR);
        if (sr == null) {
            return 0;
        }
        if (sr.getReduction().equals(CHOICE_FORMULA) && parent.hasAssociations(this)) {
            return Delta.parseInt(parent.getFirstAssociation(this));
        }
        return sr.getReduction().resolve(parent, true, aPC, this.getQualifiedKey()).intValue();
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof EquipmentModifier) {
            return this.getKeyName().compareTo(((CDOMObject)o).getKeyName());
        }
        return this.getKeyName().compareTo(o.toString());
    }

    @Override
    public String getDisplayType() {
        List<Type> trueTypeList = this.getTrueTypeList(true);
        return StringUtil.join(trueTypeList, (String)".");
    }
}

