/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.system.LanguageBundle;

public class Prerequisite
implements Cloneable {
    private static final String PERCENT_CHOICE_PATTERN = Pattern.quote("%CHOICE");
    public static final String APPLY_KIND = "APPLY";
    private String kind;
    private String key = null;
    private String subKey = null;
    private List<Prerequisite> prerequisites;
    private PrerequisiteOperator operator = PrerequisiteOperator.GTEQ;
    private String operand = "1";
    private boolean totalValues;
    private boolean characterRequired = true;
    private boolean countMultiples;
    private boolean overrideQualify = false;
    private String categoryName;
    private boolean nativeCheckMult = false;

    public final boolean isTotalValues() {
        return this.totalValues;
    }

    public final void setTotalValues(boolean val) {
        this.totalValues = val;
    }

    public void setCountMultiples(boolean val) {
        this.countMultiples = val;
    }

    public boolean isCountMultiples() {
        return this.countMultiples;
    }

    public void setKey(String val) {
        this.key = val;
    }

    public String getKey() {
        return this.key;
    }

    public void setKind(String val) {
        this.kind = val;
    }

    public String getKind() {
        return this.kind;
    }

    public void setOperand(String val) {
        this.operand = val;
    }

    public String getOperand() {
        return this.operand;
    }

    public void setOperator(String operator) throws PrerequisiteException {
        this.operator = PrerequisiteOperator.getOperatorByName(operator);
    }

    public void setOperator(PrerequisiteOperator operator) {
        this.operator = operator;
    }

    public PrerequisiteOperator getOperator() {
        return this.operator;
    }

    public void addPrerequisite(Prerequisite prereq) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<Prerequisite>();
        }
        this.prerequisites.add(prereq);
    }

    public List<Prerequisite> getPrerequisites() {
        if (this.prerequisites == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.prerequisites);
    }

    public void setSubKey(String subKey) {
        this.subKey = subKey;
    }

    public String getSubKey() {
        return this.subKey;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(250);
        buf.append("<");
        buf.append(LanguageBundle.getString("Prerequisite.prereq_tag"));
        buf.append(" ");
        if (this.kind != null) {
            buf.append(LanguageBundle.getString("Prerequisite.kind"));
            buf.append("=\"");
            buf.append(this.kind);
            buf.append("\" ");
        }
        if (this.countMultiples) {
            buf.append(LanguageBundle.getString("Prerequisite.count-multiples"));
        }
        if (this.totalValues) {
            buf.append(LanguageBundle.getString("Prerequisite.total-values"));
        }
        if (this.categoryName != null) {
            buf.append(LanguageBundle.getString("Prerequisite.category"));
            buf.append("=\"");
            buf.append(this.categoryName);
            buf.append("\" ");
        }
        if (this.key != null) {
            buf.append(LanguageBundle.getString("Prerequisite.key"));
            buf.append("=\"");
            buf.append(this.key);
            buf.append("\" ");
        }
        if (this.subKey != null && !this.subKey.equals("")) {
            buf.append(LanguageBundle.getString("Prerequisite.sub-key"));
            buf.append("=\"");
            buf.append(this.subKey);
            buf.append("\" ");
        }
        buf.append(LanguageBundle.getString("Prerequisite.operator"));
        buf.append("=\"");
        buf.append((Object)this.operator);
        buf.append("\" ");
        if (this.operand != null) {
            buf.append(LanguageBundle.getString("Prerequisite.operand"));
            buf.append("=\"");
            buf.append(this.operand);
            buf.append("\" ");
        }
        if (this.isOverrideQualify()) {
            buf.append(LanguageBundle.getString("Prerequisite.override-qualify"));
        }
        buf.append(">\n");
        if (this.prerequisites != null) {
            for (Prerequisite prereq : this.prerequisites) {
                buf.append(prereq.toString());
            }
        }
        buf.append("</");
        buf.append(LanguageBundle.getString("Prerequisite.prereq_tag"));
        buf.append(">\n");
        return buf.toString();
    }

    public boolean isOverrideQualify() {
        return this.overrideQualify;
    }

    public void setOverrideQualify(boolean override) {
        this.overrideQualify = override;
    }

    public Prerequisite clone() throws CloneNotSupportedException {
        Prerequisite copy = (Prerequisite)super.clone();
        if (this.prerequisites != null) {
            copy.prerequisites = new ArrayList<Prerequisite>();
            for (Prerequisite subreq : this.prerequisites) {
                copy.prerequisites.add(subreq.clone());
            }
        }
        return copy;
    }

    public String getDescription(boolean shortForm) {
        StringBuilder buf = new StringBuilder(250);
        if (this.categoryName != null && !shortForm) {
            buf.append("of category ");
            buf.append(this.categoryName);
            buf.append(":");
            buf.append(' ');
        }
        if (this.kind != null && !shortForm) {
            buf.append(this.kind);
            buf.append(' ');
        }
        if (this.key != null) {
            buf.append(this.key);
            if (!shortForm) {
                buf.append(' ');
            }
        }
        if (this.subKey != null && !this.subKey.equals("")) {
            buf.append('(');
            buf.append(this.subKey);
            buf.append(')');
            if (!shortForm) {
                buf.append(' ');
            }
        }
        if (!shortForm) {
            buf.append((Object)this.operator);
            buf.append(' ');
        }
        if (this.operand != null && !shortForm) {
            buf.append(this.operand);
        }
        if (this.prerequisites != null && this.prerequisites.size() > 0 && !shortForm) {
            buf.append(" (");
            for (Prerequisite subreq : this.prerequisites) {
                buf.append(subreq.getDescription(shortForm));
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public int hashCode() {
        return (this.kind == null ? -1 : this.kind.hashCode()) ^ (this.key == null ? 0 : this.key.hashCode());
    }

    public boolean equals(Object o) {
        boolean otherHas;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Prerequisite)) {
            return false;
        }
        Prerequisite other = (Prerequisite)o;
        if (this.kind == null && other.kind != null) {
            return false;
        }
        if (this.key == null && other.key != null) {
            return false;
        }
        if (this.subKey == null && other.subKey != null) {
            return false;
        }
        if (this.categoryName == null && other.categoryName != null) {
            return false;
        }
        boolean iHave = this.prerequisites != null && !this.prerequisites.isEmpty();
        boolean bl = otherHas = other.prerequisites != null && !other.prerequisites.isEmpty();
        if (iHave) {
            if (!otherHas) {
                return false;
            }
            List<Prerequisite> otherPRL = other.prerequisites;
            if (otherPRL.size() != this.prerequisites.size()) {
                return false;
            }
            ArrayList<Prerequisite> removed = new ArrayList<Prerequisite>(this.prerequisites);
            removed.removeAll(otherPRL);
            if (!removed.isEmpty()) {
                return false;
            }
        } else if (otherHas) {
            return false;
        }
        return !(this.countMultiples != other.countMultiples || this.overrideQualify != other.overrideQualify || this.operator != other.operator || this.kind != null && !this.kind.equals(other.kind) || this.key != null && !this.key.equals(other.key) || this.subKey != null && !this.subKey.equals(other.subKey) || !this.operand.equals(other.operand) || this.categoryName != null && !this.categoryName.equals(other.categoryName));
    }

    public boolean isCharacterRequired() {
        return this.characterRequired;
    }

    public void setCharacterRequired(boolean characterRequired) {
        this.characterRequired = characterRequired;
    }

    public void setOriginalCheckmult(boolean b) {
        this.nativeCheckMult = b;
    }

    public boolean isOriginalCheckMult() {
        return this.nativeCheckMult;
    }

    public Prerequisite specify(String assoc) throws CloneNotSupportedException {
        Prerequisite copy = (Prerequisite)super.clone();
        if (copy.key != null) {
            copy.key = copy.key.replaceAll(PERCENT_CHOICE_PATTERN, assoc);
        }
        if (copy.operand != null) {
            copy.operand = copy.operand.replaceAll(PERCENT_CHOICE_PATTERN, assoc);
        }
        if (this.prerequisites != null) {
            copy.prerequisites = new ArrayList<Prerequisite>();
            for (Prerequisite subreq : this.prerequisites) {
                copy.prerequisites.add(subreq.specify(assoc));
            }
        }
        return copy;
    }

    public int getPrerequisiteCount() {
        return this.prerequisites == null ? 0 : this.prerequisites.size();
    }

    public void removePrerequisite(Prerequisite p) {
        if (this.prerequisites != null) {
            this.prerequisites.remove(p);
        }
    }
}

