/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.util.logging.Level;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public interface ParseResult {
    public static final Pass SUCCESS = new Pass();
    public static final Fail INTERNAL_ERROR = new Fail("Internal error.");

    public boolean passed();

    public void printMessages();

    public void addMessagesToLog();

    public static class Fail
    implements ParseResult {
        private final QueuedMessage error;

        public Fail(String error) {
            this.error = new QueuedMessage(Logging.LST_ERROR, error);
        }

        public Fail(String error, LoadContext context) {
            this.error = context == null || context.getSourceURI() == null ? new QueuedMessage(Logging.LST_ERROR, error) : new QueuedMessage(Logging.LST_ERROR, error + " (Source: " + context.getSourceURI() + " )");
        }

        @Override
        public boolean passed() {
            return false;
        }

        public QueuedMessage getError() {
            return this.error;
        }

        @Override
        public void addMessagesToLog() {
            Logging.addParseMessage(this.error.level, this.error.message, this.error.stackTrace);
        }

        @Override
        public void printMessages() {
            Logging.log(this.error.level, this.error.message, this.error.stackTrace);
        }

        public String toString() {
            return this.error.message;
        }
    }

    public static class Pass
    implements ParseResult {
        @Override
        public boolean passed() {
            return true;
        }

        @Override
        public void addMessagesToLog() {
        }

        @Override
        public void printMessages() {
        }
    }

    public static class QueuedMessage {
        public final Level level;
        public final String message;
        public final StackTraceElement[] stackTrace;

        public QueuedMessage(Level lvl, String msg) {
            this.level = lvl;
            this.message = msg;
            this.stackTrace = Thread.currentThread().getStackTrace();
        }
    }
}

