/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class PropertyContext
implements PropertyChangeListener {
    protected final Properties properties;
    protected final PropertyContext parent;
    protected final PropertyChangeSupport support;
    protected final String name;

    protected PropertyContext(String name) {
        this(name, null);
    }

    protected PropertyContext(String name, PropertyContext parent) {
        this.name = name;
        this.support = new PropertyChangeSupport(this);
        this.parent = parent;
        this.properties = parent == null ? new Properties() : parent.properties;
    }

    protected PropertyContext(String name, PropertyContext parent, Properties properties) {
        this.name = name;
        this.support = new PropertyChangeSupport(this);
        this.parent = parent;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public PropertyContext createChildContext(String name) {
        return new PropertyContext(name, this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(property, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(property, listener);
    }

    public String getProperty(String key) {
        if (this.parent != null) {
            return this.parent.getProperty(this.name + "." + key);
        }
        return this.properties.getProperty(key);
    }

    public String initProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value != null) {
            return value;
        }
        this.setProperty(key, defaultValue);
        return defaultValue;
    }

    public String getProperty(String key, String defaultValue) {
        if (this.parent != null) {
            return this.parent.getProperty(this.name + "." + key, defaultValue);
        }
        return this.properties.getProperty(key, defaultValue);
    }

    public Object setProperty(String key, String value) {
        if (value == null) {
            return this.removeProperty(key);
        }
        Object oldValue = this.parent != null ? this.parent.setProperty(this.name + "." + key, value) : this.properties.setProperty(key, value);
        this.support.firePropertyChange(key, oldValue, value);
        return oldValue;
    }

    public Object removeProperty(String key) {
        Object oldValue = this.parent != null ? this.parent.removeProperty(this.name + "." + key) : this.properties.remove(key);
        this.support.firePropertyChange(key, oldValue, null);
        return oldValue;
    }

    public String[] getStringArray(String key) {
        String prop = this.getProperty(key);
        if (prop == null) {
            return null;
        }
        return StringUtils.split(prop, ';');
    }

    public String[] getStringArray(String key, String[] defaultValue) {
        String prop = this.getProperty(key);
        if (prop == null) {
            return defaultValue;
        }
        return StringUtils.split(prop, ';');
    }

    public void setStringArray(String key, String[] value) {
        this.setProperty(key, StringUtils.join((Object[])value, ';'));
    }

    public void setStringArray(String key, List<String> value) {
        this.setStringArray(key, value.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
    }

    public String[] initStringArray(String key, String[] defaultValue) {
        return StringUtils.split(this.initProperty(key, StringUtils.join((Object[])defaultValue, ';')), ';');
    }

    public int getInt(String key) {
        return NumberUtils.toInt(this.getProperty(key));
    }

    public int getInt(String key, int defaultValue) {
        return NumberUtils.toInt(this.getProperty(key, Integer.toString(defaultValue)));
    }

    public void setInt(String key, int integer) {
        this.setProperty(key, Integer.toString(integer));
    }

    public int initInt(String key, int defaultValue) {
        return NumberUtils.toInt(this.initProperty(key, Integer.toString(defaultValue)));
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getProperty(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.valueOf(this.getProperty(key, Boolean.toString(defaultValue)));
    }

    public void setBoolean(String key, boolean bool) {
        this.setProperty(key, Boolean.toString(bool));
    }

    public boolean initBoolean(String key, boolean defaultValue) {
        return Boolean.valueOf(this.initProperty(key, Boolean.toString(defaultValue)));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.support.firePropertyChange(evt);
    }

    protected void afterPropertiesLoaded() {
    }

    protected void beforePropertiesSaved() {
    }
}

