/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.ArmorProf;
import pcgen.core.Equipment;
import pcgen.core.ShieldProf;
import pcgen.core.WeaponProf;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class ProficiencyToken
extends AbstractNonEmptyToken<Equipment>
implements CDOMPrimaryToken<Equipment>,
DeferredToken<Equipment> {
    @Override
    public String getTokenName() {
        return "PROFICIENCY";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, Equipment eq, String value) {
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail("Equipment Token PROFICIENCY syntax without a Subtoken is invalid: PROFICIENCY:" + value, context);
        }
        if (pipeLoc != value.lastIndexOf("|")) {
            return new ParseResult.Fail(this.getTokenName() + " expecting only one '|', " + "format is: SubToken|ProfName value was: " + value, context);
        }
        String subtoken = value.substring(0, pipeLoc);
        String prof = value.substring(pipeLoc + 1);
        if (prof == null || prof.length() == 0) {
            return new ParseResult.Fail("PROFICIENCY cannot have empty second argument: " + value, context);
        }
        if (subtoken.equals("WEAPON")) {
            CDOMSingleRef<WeaponProf> wp = context.getReferenceContext().getCDOMReference(WeaponProf.class, prof);
            context.getObjectContext().put((CDOMObject)eq, ObjectKey.WEAPON_PROF, wp);
        } else if (subtoken.equals("ARMOR")) {
            CDOMSingleRef<ArmorProf> wp = context.getReferenceContext().getCDOMReference(ArmorProf.class, prof);
            context.getObjectContext().put((CDOMObject)eq, ObjectKey.ARMOR_PROF, wp);
        } else if (subtoken.equals("SHIELD")) {
            CDOMSingleRef<ShieldProf> wp = context.getReferenceContext().getCDOMReference(ShieldProf.class, prof);
            context.getObjectContext().put((CDOMObject)eq, ObjectKey.SHIELD_PROF, wp);
        } else {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Unknown Subtoken for PROFICIENCY: " + subtoken);
            cpr.addErrorMessage("  Subtoken must be WEAPON, ARMOR or SHIELD");
            return cpr;
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Equipment eq) {
        CDOMSingleRef<WeaponProf> wp = context.getObjectContext().getObject(eq, ObjectKey.WEAPON_PROF);
        CDOMSingleRef<ShieldProf> sp = context.getObjectContext().getObject(eq, ObjectKey.SHIELD_PROF);
        CDOMSingleRef<ArmorProf> ap = context.getObjectContext().getObject(eq, ObjectKey.ARMOR_PROF);
        if (wp == null) {
            if (sp == null) {
                if (ap == null) {
                    return null;
                }
                return new String[]{"ARMOR|" + ap.getLSTformat(false)};
            }
            if (ap == null) {
                return new String[]{"SHIELD|" + sp.getLSTformat(false)};
            }
            context.addWriteMessage("Equipment may not have both ARMOR and SHIELD Proficiencies");
            return null;
        }
        if (sp == null) {
            if (ap == null) {
                return new String[]{"WEAPON|" + wp.getLSTformat(false)};
            }
            context.addWriteMessage("Equipment may not have both ARMOR and WEAPON Proficiencies");
            return null;
        }
        context.addWriteMessage("Equipment may not have both WEAPON and SHIELD Proficiencies");
        return null;
    }

    @Override
    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }

    @Override
    public Class<Equipment> getDeferredTokenClass() {
        return Equipment.class;
    }

    @Override
    public boolean process(LoadContext context, Equipment eq) {
        CDOMSingleRef<WeaponProf> wp = eq.get(ObjectKey.WEAPON_PROF);
        if (eq.get(ObjectKey.SHIELD_PROF) != null) {
            if (eq.get(ObjectKey.ARMOR_PROF) != null) {
                Logging.errorPrint("Equipment " + eq.getKeyName() + " may not have both " + "ARMOR and SHIELD Proficiencies");
                return false;
            }
            if (wp != null) {
                Logging.errorPrint("Equipment " + eq.getKeyName() + " may not have both " + "WEAPON and SHIELD Proficiencies");
                return false;
            }
        }
        if (wp != null && eq.get(ObjectKey.ARMOR_PROF) != null) {
            Logging.errorPrint("Equipment " + eq.getKeyName() + " may not have both " + "ARMOR and WEAPON Proficiencies");
            return false;
        }
        return true;
    }
}

