/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.gear;

import pcgen.core.kit.KitGear;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MaxCostToken
extends AbstractToken
implements CDOMPrimaryToken<KitGear> {
    @Override
    public String getTokenName() {
        return "MAXCOST";
    }

    @Override
    public Class<KitGear> getTokenClass() {
        return KitGear.class;
    }

    @Override
    public ParseResult parseToken(LoadContext context, KitGear kitGear, String value) {
        try {
            Integer quan = Integer.valueOf(value);
            if (quan <= 0) {
                return new ParseResult.Fail(this.getTokenName() + " expected an integer > 0", context);
            }
            kitGear.setMaxCost(quan);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>", context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, KitGear kitGear) {
        Integer bd = kitGear.getMaxCost();
        if (bd == null) {
            return null;
        }
        return new String[]{bd.toString()};
    }
}

