/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreStatTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int targetNumber = Integer.parseInt(prereq.getOperand());
        PCStat stat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, prereq.getKey());
        if (stat == null) {
            throw new PrerequisiteException("PRESTAT refers to invalid stat '" + stat + ". Prereq was " + prereq);
        }
        int statValue = display.getTotalStatFor(stat);
        int runningTotal = prereq.getOperator().compare(statValue, targetNumber);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "STAT";
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        return LanguageBundle.getFormattedString("PreStat.toHtml", prereq.getKey(), prereq.getOperator().toString(), prereq.getOperand());
    }
}

