/*
 * Decompiled with CFR 0.152.
 */
package plugin.overland.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import pcgen.system.LanguageBundle;
import plugin.overland.model.RoomBoard;
import plugin.overland.model.RoomBoardFactory;
import plugin.overland.model.TravelMethod;
import plugin.overland.model.TravelMethodFactory;
import plugin.overland.model.TravelMethodListener;
import plugin.overland.model.TravelSpeedEvent;

public class OverPanel
extends JPanel {
    private static final String VALUE_PROPERTY = "value";
    private TravelMethodTextField lastEdited = null;
    private JButton butToDist;
    private JButton butToMap;
    private JButton butToReal;
    private JButton butToTime;
    private JButton butToTime2;
    private JComboBox cmbAnimal;
    private JComboBox cmbFood;
    private JComboBox cmbInn;
    private JComboBox cmbFile;
    private JLabel jLabel11;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel imperialSpeedLabel;
    private JPanel panelScaleConv;
    private JPanel panelTravelTime;
    private JPanel panelRoomBoard;
    private JSeparator jSeparator1;
    private JLabel lblSpeed;
    private JFormattedTextField textMap;
    private JFormattedTextField textReal;
    private JFormattedTextField textScale;
    private JFormattedTextField txtAnim;
    private JFormattedTextField txtDayAnimal;
    private JFormattedTextField txtDayFood;
    private JFormattedTextField txtDayInn;
    private JFormattedTextField txtDayTotal;
    private JFormattedTextField txtDays;
    private JFormattedTextField txtDist;
    private JFormattedTextField txtPeop;
    private JLabel imperialSpeed;
    private JLabel metricSpeed;
    private JFormattedTextField txtDistMetric;
    private JFormattedTextField txtTime;
    private JLabel txtTotal;
    private JLabel txtWeekAnimal;
    private JLabel txtWeekFood;
    private JLabel txtWeekInn;
    private JLabel txtWeekTotal;
    private JTextArea ruleComment;
    private JLabel metricSpeedLabel;
    private JComboBox terrain;
    private JComboBox route;
    private JLabel percent;
    private JComboBox method;
    private JComboBox pace;
    private JComboBox choice;
    private DefaultComboBoxModel aModel;
    private TravelMethod selectedTM;
    private NumberFormat gp = NumberFormat.getNumberInstance();
    private NumberFormat nf = NumberFormat.getNumberInstance();
    private RoomBoard rb;
    private Vector<TravelMethod> tms;
    private TravelMethodListener listener = new TravelMethodListener(){
        private static final String NEWLINE = "\n";

        @Override
        public void multUpdated(TravelSpeedEvent e) {
            String changed = e.getChanged();
            if (changed != null && changed.contains(NEWLINE)) {
                changed = "<html>" + changed.replaceAll(NEWLINE, "<br>") + "</html>";
            }
            OverPanel.this.percent.setText(changed);
        }

        @Override
        public void unmodifiedSpeedUpdated(EventObject e) {
            OverPanel.this.imperialSpeedLabel.setText(OverPanel.this.selectedTM.getUnmodifiedImperialSpeedString());
            OverPanel.this.metricSpeedLabel.setText(OverPanel.this.selectedTM.getUnmodifiedMetricSpeedString());
        }

        @Override
        public void speedUpdated(EventObject e) {
            String imperialSpeedString = OverPanel.this.selectedTM.getImperialSpeedString();
            OverPanel.this.imperialSpeed.setText(imperialSpeedString);
            OverPanel.this.butToTime.setEnabled(imperialSpeedString != null);
            String metricSpeedString = OverPanel.this.selectedTM.getMetricSpeedString();
            OverPanel.this.metricSpeed.setText(metricSpeedString);
            OverPanel.this.butToTime2.setEnabled(metricSpeedString != null);
            OverPanel.this.butToDist.setEnabled(imperialSpeedString != null && metricSpeedString != null);
            if (OverPanel.this.lastEdited != null) {
                switch (OverPanel.this.lastEdited) {
                    case IMPERIAL_DISTANCE: {
                        OverPanel.this.butImperialToTimeActionPerformed();
                        break;
                    }
                    case METRIC_DISTANCE: {
                        OverPanel.this.butMetricToTimeActionPerformed();
                        break;
                    }
                    case TIME: {
                        OverPanel.this.butToDistActionPerformed();
                    }
                }
            }
        }

        @Override
        public void useDaysChanged(TravelSpeedEvent e) {
            OverPanel.this.jLabel11.setText(e.getChanged());
        }

        @Override
        public void commentChanged(TravelSpeedEvent e) {
            OverPanel.this.ruleComment.setText(e.getChanged());
        }
    };

    public OverPanel(File DataDir) {
        this.initComponents();
        this.loadData(DataDir);
        this.initData();
    }

    private void butToDistActionPerformed() {
        if (this.selectedTM == null) {
            return;
        }
        this.lastEdited = TravelMethodTextField.TIME;
        Object o = this.txtTime.getValue();
        if (o != null && o instanceof Number) {
            double time = ((Number)o).doubleValue();
            this.txtDist.setValue(this.selectedTM.convertToMiles(time));
            this.txtDistMetric.setValue(this.selectedTM.convertToKm(time));
        }
    }

    private void butImperialToTimeActionPerformed() {
        if (this.selectedTM == null) {
            return;
        }
        this.lastEdited = TravelMethodTextField.IMPERIAL_DISTANCE;
        Object o = this.txtDist.getValue();
        if (o != null && o instanceof Number) {
            double miles = ((Number)o).doubleValue();
            this.txtTime.setValue(this.selectedTM.convertToTimeFromImperial(miles));
        }
    }

    private void butMetricToTimeActionPerformed() {
        if (this.selectedTM == null) {
            return;
        }
        this.lastEdited = TravelMethodTextField.METRIC_DISTANCE;
        Object o = this.txtDistMetric.getValue();
        if (o != null && o instanceof Number) {
            double km = ((Number)o).doubleValue();
            this.txtTime.setValue(this.selectedTM.convertToTimeFromMetric(km));
        }
    }

    private void butToMapActionPerformed(ActionEvent evt) {
        float scale = ((Number)this.textScale.getValue()).floatValue();
        float realUnits = ((Number)this.textReal.getValue()).floatValue();
        float result = 0.0f;
        result = realUnits / scale;
        this.textMap.setValue(Float.valueOf(result));
    }

    private void butToRealActionPerformed(ActionEvent evt) {
        float scale = ((Number)this.textScale.getValue()).floatValue();
        float mapUnits = ((Number)this.textMap.getValue()).floatValue();
        float result = 0.0f;
        result = scale * mapUnits;
        this.textReal.setValue(Float.valueOf(result));
    }

    private void initComponents() {
        this.panelScaleConv = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.textScale = new JFormattedTextField(this.nf);
        this.textScale.setColumns(3);
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.textReal = new JFormattedTextField(this.nf);
        this.textMap = new JFormattedTextField(this.nf);
        this.butToMap = new JButton();
        this.butToReal = new JButton();
        this.panelTravelTime = new JPanel();
        this.imperialSpeedLabel = new JLabel();
        this.metricSpeedLabel = new JLabel();
        this.cmbFile = new JComboBox();
        this.txtDist = new JFormattedTextField(this.nf);
        this.txtDist.setColumns(4);
        this.txtDistMetric = new JFormattedTextField(this.nf);
        this.jLabel11 = new JLabel();
        this.txtTime = new JFormattedTextField(this.nf);
        this.txtTime.setColumns(4);
        this.butToTime = new JButton();
        this.butToTime2 = new JButton();
        this.butToDist = new JButton();
        this.lblSpeed = new JLabel();
        this.panelRoomBoard = new JPanel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.jLabel22 = new JLabel();
        this.txtDayFood = new JFormattedTextField(this.gp);
        this.txtDayInn = new JFormattedTextField(this.gp);
        this.txtDayAnimal = new JFormattedTextField(this.gp);
        this.txtWeekFood = new JLabel();
        this.txtWeekInn = new JLabel();
        this.txtWeekAnimal = new JLabel();
        this.txtDays = new JFormattedTextField(this.nf);
        this.txtTotal = new JLabel();
        this.cmbFood = new JComboBox();
        this.cmbInn = new JComboBox();
        this.cmbAnimal = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jLabel23 = new JLabel();
        this.jLabel24 = new JLabel();
        this.txtPeop = new JFormattedTextField(this.nf);
        this.txtAnim = new JFormattedTextField(this.nf);
        this.txtDayTotal = new JFormattedTextField(this.nf);
        this.txtWeekTotal = new JLabel();
        this.jLabel25 = new JLabel();
        JPanel panel = new JPanel(new GridBagLayout());
        int gap = 3;
        Insets stdInsets = new Insets(gap, gap, gap, gap);
        this.panelScaleConv.setLayout(new GridBagLayout());
        this.panelScaleConv.setBorder(BorderFactory.createTitledBorder(LanguageBundle.getString((String)"in_plugin_overland_scaleConverter")));
        this.jLabel2.setText(LanguageBundle.getString((String)"in_plugin_overland_realUnits"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = stdInsets;
        this.panelScaleConv.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelScaleConv.add((Component)this.jLabel3, gridBagConstraints);
        this.textScale.setHorizontalAlignment(0);
        this.textScale.setValue(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = stdInsets;
        this.panelScaleConv.add((Component)this.textScale, gridBagConstraints);
        this.jLabel4.setText("=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelScaleConv.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(LanguageBundle.getString((String)"in_plugin_overland_mapUnits"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = stdInsets;
        this.panelScaleConv.add((Component)this.jLabel5, gridBagConstraints);
        this.textReal.addKeyListener(new KeyListenerImplementation(this.butToMap));
        this.textReal.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = stdInsets;
        this.panelScaleConv.add((Component)this.textReal, gridBagConstraints);
        this.textMap.addKeyListener(new KeyListenerImplementation(this.butToReal));
        this.textMap.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = stdInsets;
        this.panelScaleConv.add((Component)this.textMap, gridBagConstraints);
        this.butToMap.setText(LanguageBundle.getString((String)"in_plugin_overland_leftArrow"));
        this.butToMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverPanel.this.butToMapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panelScaleConv.add((Component)this.butToMap, gridBagConstraints);
        this.butToReal.setText(LanguageBundle.getString((String)"in_plugin_overland_rightArrow"));
        this.butToReal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverPanel.this.butToRealActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.panelScaleConv.add((Component)this.butToReal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        panel.add((Component)this.panelScaleConv, gridBagConstraints);
        this.panelTravelTime.setLayout(new GridBagLayout());
        this.panelTravelTime.setBorder(BorderFactory.createTitledBorder(LanguageBundle.getString((String)"in_plugin_overland_travelTime")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 2 * gap, 2 * gap, 2 * gap);
        gridBagConstraints.fill = 2;
        this.panelTravelTime.add((Component)this.cmbFile, gridBagConstraints);
        this.method = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = stdInsets;
        gridBagConstraints.gridwidth = 2;
        this.panelTravelTime.add((Component)this.method, gridBagConstraints);
        JPanel terrainRoute = new JPanel(new GridBagLayout());
        this.terrain = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = stdInsets;
        terrainRoute.add((Component)this.terrain, gridBagConstraints);
        this.route = new JComboBox();
        terrainRoute.add((Component)this.route, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        this.panelTravelTime.add((Component)terrainRoute, gridBagConstraints);
        this.percent = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = stdInsets;
        this.panelTravelTime.add((Component)this.percent, gridBagConstraints);
        JPanel paceChoice = new JPanel(new GridBagLayout());
        this.pace = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = stdInsets;
        paceChoice.add((Component)this.pace, gridBagConstraints);
        this.choice = new JComboBox();
        paceChoice.add((Component)this.choice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        this.panelTravelTime.add((Component)paceChoice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = stdInsets;
        this.panelTravelTime.add((Component)this.imperialSpeedLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = stdInsets;
        this.panelTravelTime.add((Component)this.metricSpeedLabel, gridBagConstraints);
        this.ruleComment = new JTextArea();
        this.ruleComment.setRows(3);
        this.ruleComment.setEditable(false);
        this.ruleComment.setFocusable(false);
        this.ruleComment.setLineWrap(true);
        this.ruleComment.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        this.panelTravelTime.add((Component)new JScrollPane(this.ruleComment), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.panelTravelTime.add((Component)new JSeparator(), gridBagConstraints);
        this.imperialSpeed = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        this.panelTravelTime.add((Component)this.imperialSpeed, gridBagConstraints);
        this.metricSpeed = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        this.panelTravelTime.add((Component)this.metricSpeed, gridBagConstraints);
        JPanel conversion = new JPanel(new GridBagLayout());
        this.txtDist.addKeyListener(new KeyListenerImplementation(this.butToTime));
        this.txtDist.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = stdInsets;
        conversion.add((Component)this.txtDist, gridBagConstraints);
        JLabel miles = new JLabel(LanguageBundle.getString((String)"in_plugin_overland_fieldMiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(gap, 0, gap, gap);
        conversion.add((Component)miles, gridBagConstraints);
        this.butToTime.setText(LanguageBundle.getString((String)"in_plugin_overland_rightArrow"));
        this.butToTime.setEnabled(false);
        this.butToTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverPanel.this.butImperialToTimeActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        conversion.add((Component)this.butToTime, gridBagConstraints);
        this.txtDistMetric.addKeyListener(new KeyListenerImplementation(this.butToTime2));
        this.txtDistMetric.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = stdInsets;
        conversion.add((Component)this.txtDistMetric, gridBagConstraints);
        this.lblSpeed.setText(LanguageBundle.getString((String)"in_plugin_overland_fieldKm"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(gap, gap, gap, gap);
        conversion.add((Component)this.lblSpeed, gridBagConstraints);
        this.butToTime2.setText(LanguageBundle.getString((String)"in_plugin_overland_rightArrow"));
        this.butToTime2.setEnabled(false);
        this.butToTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverPanel.this.butMetricToTimeActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        conversion.add((Component)this.butToTime2, gridBagConstraints);
        this.txtTime.addKeyListener(new KeyListenerImplementation(this.butToDist));
        this.txtTime.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(gap, gap, gap, 0);
        conversion.add((Component)this.txtTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = stdInsets;
        conversion.add((Component)this.jLabel11, gridBagConstraints);
        this.butToDist.setText(LanguageBundle.getString((String)"in_plugin_overland_leftArrow"));
        this.butToDist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverPanel.this.butToDistActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        conversion.add((Component)this.butToDist, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        this.panelTravelTime.add((Component)conversion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        panel.add((Component)this.panelTravelTime, gridBagConstraints);
        this.panelRoomBoard.setLayout(new GridBagLayout());
        this.panelRoomBoard.setBorder(BorderFactory.createTitledBorder(LanguageBundle.getString((String)"in_plugin_overland_roomAndBoard")));
        this.jLabel15.setText(LanguageBundle.getString((String)"in_plugin_overland_perDay"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel16.setText(LanguageBundle.getString((String)"in_plugin_overland_food"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel17.setText(LanguageBundle.getString((String)"in_plugin_overland_perWeek"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel17, gridBagConstraints);
        this.jLabel18.setText(LanguageBundle.getString((String)"in_plugin_overland_lodging"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel18, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)new JPanel(), gridBagConstraints);
        this.jLabel20.setText(LanguageBundle.getString((String)"in_plugin_overland_animals"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel21.setText(LanguageBundle.getString((String)"in_plugin_overland_days"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel21, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.panelRoomBoard.add((Component)new JSeparator(), gridBagConstraints);
        this.jLabel22.setText(LanguageBundle.getString((String)"in_plugin_overland_total"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel22, gridBagConstraints);
        this.txtDayFood.setHorizontalAlignment(0);
        this.txtDayFood.addPropertyChangeListener(VALUE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OverPanel.this.txtDayFoodActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtDayFood, gridBagConstraints);
        this.txtDayInn.setHorizontalAlignment(0);
        this.txtDayInn.addPropertyChangeListener(VALUE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OverPanel.this.txtDayFoodActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtDayInn, gridBagConstraints);
        this.txtDayAnimal.setHorizontalAlignment(0);
        this.txtDayAnimal.addPropertyChangeListener(VALUE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OverPanel.this.txtDayFoodActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtDayAnimal, gridBagConstraints);
        this.txtWeekFood.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtWeekFood, gridBagConstraints);
        this.txtWeekInn.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtWeekInn, gridBagConstraints);
        this.txtWeekAnimal.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtWeekAnimal, gridBagConstraints);
        this.txtDays.setHorizontalAlignment(0);
        this.txtDays.addPropertyChangeListener(VALUE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OverPanel.this.txtDaysActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtDays, gridBagConstraints);
        this.txtTotal.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtTotal, gridBagConstraints);
        this.cmbFood.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverPanel.this.txtPeopActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.cmbFood, gridBagConstraints);
        this.cmbInn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverPanel.this.txtPeopActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.cmbInn, gridBagConstraints);
        this.cmbAnimal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverPanel.this.txtPeopActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.cmbAnimal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.panelRoomBoard.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel23.setText(LanguageBundle.getString((String)"in_plugin_overland_people"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel24.setText(LanguageBundle.getString((String)"in_plugin_overland_animals"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel24, gridBagConstraints);
        this.txtPeop.setHorizontalAlignment(0);
        this.txtPeop.setColumns(3);
        this.txtPeop.addPropertyChangeListener(VALUE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OverPanel.this.txtPeopActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtPeop, gridBagConstraints);
        this.txtAnim.setHorizontalAlignment(0);
        this.txtAnim.setColumns(3);
        this.txtAnim.addPropertyChangeListener(VALUE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OverPanel.this.txtPeopActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtAnim, gridBagConstraints);
        this.txtDayTotal.setHorizontalAlignment(0);
        this.txtDayTotal.addPropertyChangeListener(VALUE_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OverPanel.this.txtDaysActionPerformed();
            }
        });
        this.txtDayTotal.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtDayTotal, gridBagConstraints);
        this.txtWeekTotal.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.txtWeekTotal, gridBagConstraints);
        this.jLabel25.setText(LanguageBundle.getString((String)"in_plugin_overland_total"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = stdInsets;
        this.panelRoomBoard.add((Component)this.jLabel25, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        panel.add((Component)this.panelRoomBoard, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(panel), "Center");
    }

    private void initData() {
        int i;
        this.nf.setMaximumFractionDigits(2);
        this.gp.setMaximumFractionDigits(3);
        this.aModel = new DefaultComboBoxModel<TravelMethod>(this.tms);
        this.cmbFile.setModel(this.aModel);
        this.cmbFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                OverPanel.this.changedTM();
            }
        });
        this.cmbFile.setSelectedItem(this.tms.get(0));
        this.changedTM();
        this.txtPeop.setValue(1);
        this.txtAnim.setValue(1);
        this.txtDays.setValue(1);
        for (i = 0; i < this.rb.getInns().getCount(); ++i) {
            this.cmbInn.addItem(this.rb.getInns().get(i).getName());
        }
        this.cmbInn.setSelectedIndex(0);
        for (i = 0; i < this.rb.getFoods().getCount(); ++i) {
            this.cmbFood.addItem(this.rb.getFoods().get(i).getName());
        }
        this.cmbFood.setSelectedIndex(0);
        for (i = 0; i < this.rb.getAnimals().getCount(); ++i) {
            this.cmbAnimal.addItem(this.rb.getAnimals().get(i).getName());
        }
        this.cmbAnimal.setSelectedIndex(0);
    }

    private void changedTM() {
        if (this.selectedTM != null) {
            this.selectedTM.removeTravelMethodListener(this.listener);
        }
        this.selectedTM = (TravelMethod)this.aModel.getSelectedItem();
        if (this.selectedTM == null) {
            return;
        }
        this.method.setModel(this.selectedTM.getMethodsModel());
        this.method.setSelectedIndex(0);
        this.pace.setModel(this.selectedTM.getPaceModel());
        this.choice.setModel(this.selectedTM.getChoiceModel());
        this.terrain.setModel(this.selectedTM.getTerrainsModel());
        this.route.setModel(this.selectedTM.getRoutesModel());
        this.selectedTM.addTravelMethodListener(this.listener);
        this.pace.setSelectedIndex(0);
        this.choice.setSelectedIndex(0);
        this.terrain.setSelectedIndex(0);
        this.route.setSelectedIndex(0);
    }

    private void loadData(File aDataDir) {
        this.tms = TravelMethodFactory.load(aDataDir);
        this.rb = RoomBoardFactory.load(aDataDir);
    }

    private void txtDayFoodActionPerformed() {
        this.updateMidUI();
    }

    private void txtDaysActionPerformed() {
        this.updateBottomUI();
    }

    private void txtPeopActionPerformed() {
        this.updateTopUI();
    }

    private void updateBottomUI() {
        float DayTotal = ((Number)this.txtDayTotal.getValue()).floatValue();
        Object value = this.txtDays.getValue();
        if (value instanceof Number) {
            float Days = ((Number)value).floatValue();
            float result = DayTotal * Days;
            this.txtTotal.setText(this.gp.format(result));
        } else {
            this.txtTotal.setText("");
        }
    }

    private void updateMidUI() {
        Object inn = this.txtDayInn.getValue();
        float DayInn = inn instanceof Number ? ((Number)inn).floatValue() : 0.0f;
        Object food = this.txtDayFood.getValue();
        float DayFood = food instanceof Number ? ((Number)food).floatValue() : 0.0f;
        Object animal = this.txtDayAnimal.getValue();
        float DayAnimal = animal instanceof Number ? ((Number)this.txtDayAnimal.getValue()).floatValue() : 0.0f;
        float result = DayInn + DayFood + DayAnimal;
        this.txtDayTotal.setValue(Float.valueOf(result));
        this.txtWeekTotal.setText(this.gp.format(result *= 7.0f));
        this.updateBottomUI();
    }

    private void updateTopUI() {
        int i1 = this.cmbFood.getSelectedIndex();
        float food = i1 >= 0 ? this.rb.getFoods().get(i1).getCost() : 0.0f;
        int i2 = this.cmbInn.getSelectedIndex();
        float inn = i2 >= 0 ? this.rb.getInns().get(i2).getCost() : 0.0f;
        int i3 = this.cmbAnimal.getSelectedIndex();
        float animal = i3 >= 0 ? this.rb.getAnimals().get(i3).getCost() : 0.0f;
        float result = 0.0f;
        Number people = (Number)this.txtPeop.getValue();
        Number value = (Number)this.txtAnim.getValue();
        if (people != null && people instanceof Number) {
            int numPeople = people.intValue();
            result = food * (float)numPeople;
            this.txtDayFood.setValue(Float.valueOf(result));
            this.txtWeekFood.setText(this.gp.format(result *= 7.0f));
            result = inn * (float)numPeople;
            this.txtDayInn.setValue(Float.valueOf(result));
            this.txtWeekInn.setText(this.gp.format(result *= 7.0f));
        }
        if (value != null && value instanceof Number) {
            int numAnimal = value.intValue();
            result = animal * (float)numAnimal;
            this.txtDayAnimal.setValue(Float.valueOf(result));
            this.txtWeekAnimal.setText(this.gp.format(result *= 7.0f));
        }
        this.updateMidUI();
    }

    private final class KeyListenerImplementation
    implements KeyListener {
        private JButton button;

        public KeyListenerImplementation(JButton button) {
            this.button = button;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (10 == e.getKeyCode()) {
                this.button.doClick();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    }

    protected static enum TravelMethodTextField {
        IMPERIAL_DISTANCE,
        METRIC_DISTANCE,
        TIME;

    }
}

