/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.helper.ProfProvider;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;

public class PreArmorProfTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) throws PrerequisiteException {
        int number;
        int runningTotal = 0;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException exceptn) {
            throw new PrerequisiteException(LanguageBundle.getFormattedString((String)"Prereq.error", (Object[])new Object[]{"PREARMOR", prereq.toString()}));
        }
        String aString = prereq.getKey();
        Equipment keyEquip = (Equipment)Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, aString);
        boolean isType = aString.startsWith("TYPE") && aString.length() > 5;
        boolean isArmorType = aString.startsWith("ARMORTYPE") && aString.length() > 11;
        String typeString = null;
        if (isType) {
            typeString = "ARMOR." + aString.substring(5);
        } else if (isArmorType) {
            typeString = "ARMOR." + aString.substring(10);
        }
        for (ProfProvider spp : display.getArmorProfList()) {
            if (keyEquip != null && spp.providesProficiency((CDOMObject)keyEquip.getArmorProf())) {
                ++runningTotal;
                continue;
            }
            if (keyEquip != null && spp.providesEquipmentType(keyEquip.getType())) {
                ++runningTotal;
                continue;
            }
            if (isType && spp.providesEquipmentType(typeString)) {
                ++runningTotal;
                continue;
            }
            if (!isArmorType || !spp.providesEquipmentType(typeString)) continue;
            ++runningTotal;
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    public String kindHandled() {
        return "profwitharmor";
    }
}

