/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.simplecli;

import java.io.File;
import java.nio.file.Files;
import java.util.List;
import weka.gui.simplecli.AbstractCommand;

public class Script
extends AbstractCommand {
    @Override
    public String getName() {
        return "script";
    }

    @Override
    public String getHelp() {
        return "Executes commands from a script file.";
    }

    @Override
    public String getParameterHelp() {
        return "<script_file>";
    }

    @Override
    protected void doExecute(String[] params) throws Exception {
        if (params.length == 0) {
            throw new Exception("No script file provided!");
        }
        File script = new File(params[0]);
        if (!script.exists()) {
            throw new Exception("Script does not exist: " + script);
        }
        if (script.isDirectory()) {
            throw new Exception("Script points to a directory: " + script);
        }
        List<String> cmds = Files.readAllLines(script.toPath());
        for (String cmd : cmds) {
            while (this.m_Owner.isBusy()) {
                try {
                    this.wait(100L);
                }
                catch (Exception exception) {}
            }
            this.m_Owner.runCommand(cmd);
        }
    }
}

