/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.ChannelIdentifier;
import org.apache.sshd.common.channel.IoWriteFutureImpl;
import org.apache.sshd.common.channel.exception.SshChannelBufferedOutputException;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.functors.UnaryEquator;
import org.apache.sshd.core.CoreModuleProperties;

public class BufferedIoOutputStream
extends AbstractInnerCloseable
implements IoOutputStream,
ChannelIdentifier {
    protected final Object id;
    protected final long channelId;
    protected final int maxPendingBytesCount;
    protected final Duration maxWaitForPendingWrites;
    protected final IoOutputStream out;
    protected final AtomicInteger pendingBytesCount = new AtomicInteger();
    protected final AtomicLong writtenBytesCount = new AtomicLong();
    protected final Queue<IoWriteFutureImpl> writes = new ConcurrentLinkedQueue<IoWriteFutureImpl>();
    protected final AtomicReference<IoWriteFutureImpl> currentWrite = new AtomicReference();
    protected final AtomicReference<SshChannelBufferedOutputException> pendingException = new AtomicReference();

    public BufferedIoOutputStream(Object id, long channelId, IoOutputStream out, PropertyResolver resolver) {
        this(id, channelId, out, (Integer)CoreModuleProperties.BUFFERED_IO_OUTPUT_MAX_PENDING_WRITE_SIZE.getRequired(resolver), (Duration)CoreModuleProperties.BUFFERED_IO_OUTPUT_MAX_PENDING_WRITE_WAIT.getRequired(resolver));
    }

    public BufferedIoOutputStream(Object id, long channelId, IoOutputStream out, int maxPendingBytesCount, Duration maxWaitForPendingWrites) {
        this.id = Objects.requireNonNull(id, "No stream identifier provided");
        this.channelId = channelId;
        this.out = Objects.requireNonNull(out, "No delegate output stream provided");
        this.maxPendingBytesCount = maxPendingBytesCount;
        ValidateUtils.checkTrue((maxPendingBytesCount > 0 ? 1 : 0) != 0, (String)"Invalid max. pending bytes count: %d", (long)maxPendingBytesCount);
        this.maxWaitForPendingWrites = Objects.requireNonNull(maxWaitForPendingWrites, "No max. pending time value provided");
    }

    @Override
    public long getChannelId() {
        return this.channelId;
    }

    public Object getId() {
        return this.id;
    }

    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            throw new EOFException("Closed/ing - state=" + this.state);
        }
        this.waitForAvailableWriteSpace(buffer.available());
        IoWriteFutureImpl future = new IoWriteFutureImpl(this.getId(), buffer);
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForAvailableWriteSpace(int requiredSize) throws IOException {
        long expireTime = System.currentTimeMillis() + this.maxWaitForPendingWrites.toMillis();
        AtomicInteger atomicInteger = this.pendingBytesCount;
        synchronized (atomicInteger) {
            int count = this.pendingBytesCount.get();
            while (count > 0 && count + requiredSize > this.maxPendingBytesCount && this.pendingException.get() == null) {
                long remTime = expireTime - System.currentTimeMillis();
                if (remTime <= 0L) {
                    this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, "Max. pending write timeout expired after " + this.writtenBytesCount + " bytes"));
                    throw this.pendingException.get();
                }
                try {
                    this.pendingBytesCount.wait(remTime);
                }
                catch (InterruptedException e) {
                    this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, "Waiting for pending writes interrupted after " + this.writtenBytesCount + " bytes"));
                    throw this.pendingException.get();
                }
                count = this.pendingBytesCount.get();
            }
            IOException e = this.pendingException.get();
            if (e != null) {
                throw e;
            }
            this.pendingBytesCount.addAndGet(requiredSize);
        }
    }

    private IoWriteFutureImpl getWriteRequest() {
        IoWriteFutureImpl future = null;
        while (future == null) {
            future = this.writes.peek();
            if (future == null) {
                return null;
            }
            Throwable pendingError = this.pendingException.get();
            if (pendingError != null) {
                this.log.error("startWriting({})[{}] propagate to {} write requests pending error={}[{}]", new Object[]{this.getId(), this.out, this.writes.size(), this.getClass().getSimpleName(), pendingError.getMessage()});
                IoWriteFutureImpl currentFuture = this.currentWrite.getAndSet(null);
                for (IoWriteFutureImpl pendingWrite : this.writes) {
                    if (UnaryEquator.isSameReference((Object)((Object)pendingWrite), (Object)((Object)currentFuture))) continue;
                    future.setValue(pendingError);
                }
                this.writes.clear();
                return null;
            }
            if (!this.currentWrite.compareAndSet(null, future)) {
                return null;
            }
            if (!future.isDone()) continue;
            this.currentWrite.set(null);
            future = null;
        }
        return future;
    }

    protected void startWriting() throws IOException {
        IoWriteFutureImpl future = this.getWriteRequest();
        if (future == null) {
            return;
        }
        Buffer buffer = future.getBuffer();
        int bufferSize = buffer.available();
        this.out.writeBuffer(buffer).addListener(f -> {
            if (f.isWritten()) {
                future.setValue(Boolean.TRUE);
            } else {
                future.setValue(f.getException());
            }
            this.finishWrite(future, bufferSize);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishWrite(IoWriteFutureImpl future, int bufferSize) {
        if (future.isWritten()) {
            int stillPending;
            long writtenSize = this.writtenBytesCount.addAndGet(bufferSize);
            AtomicInteger atomicInteger = this.pendingBytesCount;
            synchronized (atomicInteger) {
                stillPending = this.pendingBytesCount.addAndGet(0 - bufferSize);
                this.pendingBytesCount.notifyAll();
            }
            if (stillPending < 0) {
                this.log.error("finishWrite({})[{}] - pending byte counts underflow ({}) after {} bytes", new Object[]{this.getId(), this.out, stillPending, writtenSize});
                this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, "Pending byte counts underflow"));
            }
        } else {
            Throwable t = future.getException();
            if (t instanceof SshChannelBufferedOutputException) {
                this.pendingException.compareAndSet(null, (SshChannelBufferedOutputException)t);
            } else {
                this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, t));
            }
            AtomicInteger atomicInteger = this.pendingBytesCount;
            synchronized (atomicInteger) {
                this.pendingBytesCount.notifyAll();
            }
        }
        this.writes.remove((Object)future);
        this.currentWrite.compareAndSet(future, null);
        try {
            this.startWriting();
        }
        catch (IOException e) {
            if (e instanceof SshChannelBufferedOutputException) {
                this.pendingException.compareAndSet(null, (SshChannelBufferedOutputException)e);
            } else {
                this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, (Throwable)e));
            }
            this.error("finishWrite({})[{}] failed ({}) re-start writing: {}", this.getId(), this.out, e.getClass().getSimpleName(), e.getMessage(), e);
        }
    }

    protected Closeable getInnerCloseable() {
        return this.builder().when(this.getId(), this.writes).close((Closeable)this.out).build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getId() + "@" + this.channelId + ")[" + this.out + "]";
    }
}

