/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.store.ant.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Objects;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.FileUtils;
import org.dita.dost.util.Job;

public class StoreResource
extends Resource {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final int NULL_FILE = Resource.getMagicNumber((byte[])"null file".getBytes());
    private final URI file;
    private final Job job;

    public StoreResource(Job job, URI file) {
        this.job = job;
        this.file = file;
    }

    public String getName() {
        return this.file.getPath();
    }

    public boolean isExists() {
        return this.job.getStore().exists(this.job.tempDirURI.resolve(this.file));
    }

    public long getLastModified() {
        return -1L;
    }

    public boolean isDirectory() {
        return false;
    }

    public long getSize() {
        return -1L;
    }

    public InputStream getInputStream() throws IOException {
        return this.job.getStore().getInputStream(this.job.tempDirURI.resolve(this.file));
    }

    public OutputStream getOutputStream() throws IOException {
        return this.job.getStore().getOutputStream(this.job.tempDirURI.resolve(this.file));
    }

    public int compareTo(Resource another) {
        return -1;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another == null || !another.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        StoreResource otherfr = (StoreResource)((Object)another);
        return Objects.equals(this.file, otherfr.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.job.tempDirURI.resolve(this.file).toString();
    }

    public boolean isFilesystemOnly() {
        return true;
    }

    protected StoreResource getRef() {
        return (StoreResource)((Object)this.getCheckedRef(StoreResource.class));
    }
}

