/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.bitmap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.bitmap.BitmapCompression;
import org.pentaho.reporting.libraries.pixie.wmf.bitmap.BitmapCompressionFactory;
import org.pentaho.reporting.libraries.pixie.wmf.bitmap.BitmapHeader;
import org.pentaho.reporting.libraries.pixie.wmf.bitmap.GDIPalette;

public class DIBReader {
    private GDIPalette palette;
    private BitmapHeader header;

    public BufferedImage setRecord(MfRecord record) throws IOException {
        return this.setRecord(record, 0);
    }

    public BufferedImage setRecord(MfRecord record, int offset) throws IOException {
        this.header = new BitmapHeader();
        this.header.setRecord(record, offset);
        this.palette = new GDIPalette();
        this.palette.setNoOfColors(this.header.getNoOfColors());
        int width = this.header.getWidth();
        int height = this.header.getHeight();
        int paletteStart = 6 + this.header.getHeaderSize() + 4 + offset;
        InputStream dataIn = record.getInputStream(paletteStart);
        this.palette.readPalette(dataIn);
        int compression = this.header.getCompression();
        BitmapCompression comHandler = BitmapCompressionFactory.getHandler(compression);
        comHandler.setDimension(width, height);
        comHandler.setBpp(this.header.getBitsPerPixel());
        int[] data = comHandler.decompress(dataIn, this.palette);
        BufferedImage retval = new BufferedImage(width, height, 1);
        retval.setRGB(0, 0, width, height, data, 0, width);
        return retval;
    }
}

