/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.ITopic;
import org.xmind.core.audio.AudioValues;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.AudioNotesViewer;
import org.xmind.ui.internal.audionotes.IAudioNotesAgentListener;
import org.xmind.ui.internal.audionotes.Messages;
import org.xmind.ui.tabfolder.DelegatedSelectionProvider;

public class AudioNotesDialog
extends Dialog
implements IPartListener,
ISelectionChangedListener,
IAudioNotesAgentListener {
    private static final int BUTTON_STOP_ID = 1025;
    private IEditorPart contributingPart;
    private AudioNotesViewer viewer;
    private static List<AudioNotesDialog> instances = new ArrayList<AudioNotesDialog>();

    protected AudioNotesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AudioNotesDialog_title);
    }

    protected void initializeBounds() {
        Rectangle rect = this.getParentShell().getBounds();
        this.getShell().setBounds(rect.x + rect.width * 3 / 5, rect.y + rect.height / 7, rect.width / 5, rect.height / 2);
        super.initializeBounds();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(composite.getDisplay().getSystemColor(25));
        this.viewer = new AudioNotesViewer(true);
        this.viewer.createControl(composite);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.addPartListener((IPartListener)this);
        AudioNotesPlugin.getDefault().getAgent().addAudioListener(this);
        this.partActivated((IWorkbenchPart)page.getActiveEditor());
        instances.add(this);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (12 == buttonId) {
            this.close();
        }
    }

    public boolean close() {
        ConfirmCloseDialog confirmDialog;
        int returnCode;
        if (AudioNotesDialog.isRecording() && 1025 != (returnCode = (confirmDialog = new ConfirmCloseDialog(this.getShell())).open())) {
            return false;
        }
        return this.doClose();
    }

    public boolean doClose() {
        if (AudioNotesDialog.isRecording()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    AudioNotesPlugin.getDefault().getAgent().stop();
                }
            });
        }
        if (this.viewer != null) {
            this.viewer.dispose();
        }
        AudioNotesPlugin.getDefault().getAgent().removeAudioListener(this);
        boolean isClosed = super.close();
        if (isClosed) {
            instances.remove(this);
        }
        return isClosed;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setSelection(event.getSelection(), event.getSelectionProvider());
        }
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.setContributingPart((IEditorPart)part);
        }
    }

    private void setContributingPart(IEditorPart part) {
        DelegatedSelectionProvider selectionProvider;
        if (part == this.contributingPart) {
            return;
        }
        if (this.contributingPart != null && (selectionProvider = (DelegatedSelectionProvider)this.contributingPart.getSite().getSelectionProvider()) != null) {
            selectionProvider.removeAsyncSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.contributingPart = part;
        if (this.contributingPart != null && (selectionProvider = (DelegatedSelectionProvider)this.contributingPart.getSite().getSelectionProvider()) != null) {
            selectionProvider.addAsyncSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setSelection(this.getSelection(part), part == null ? null : part.getEditorSite().getSelectionProvider());
        }
    }

    private ISelection getSelection(IEditorPart part) {
        ISelectionProvider selectionProvider;
        if (part != null && (selectionProvider = part.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.contributingPart) {
            this.setContributingPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private static boolean isRecording() {
        return AudioNotesPlugin.getDefault().getAgent().isRecording();
    }

    public void started(ITopic topic, boolean recordOrPlayback) {
    }

    public void stopped(ITopic topic, boolean recordOrPlayback) {
        this.doClose();
    }

    public void valuesChanged(ITopic topic, AudioValues values, boolean recordOrPlayback) {
    }

    public static void showAudioNotesDialog(IWorkbenchWindow window) {
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        if (instances.size() > 0) {
            for (AudioNotesDialog dialog : instances) {
                if (!dialog.getParentShell().equals(window.getShell())) continue;
                return;
            }
        }
        new AudioNotesDialog(window.getShell()).open();
    }

    private class ConfirmCloseDialog
    extends Dialog {
        protected ConfirmCloseDialog(Shell parentShell) {
            super(parentShell);
            this.setShellStyle(67680);
            this.setBlockOnOpen(true);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.AudioNotesDialog_Title);
        }

        protected void initializeBounds() {
            Rectangle rect = AudioNotesDialog.this.getParentShell().getBounds();
            this.getShell().setBounds((rect.width - 300) / 2 + rect.x, (rect.height - 200) / 2 + rect.y, 350, 200);
            super.initializeBounds();
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 0);
            label.setText(Messages.AudioNotesDialog_Message);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            return composite;
        }

        protected void buttonPressed(int buttonId) {
            if (1025 == buttonId) {
                this.setReturnCode(1025);
            }
            super.close();
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1025, Messages.AudioNotesDialog_Button_Stop, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }
}

