/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.xmind.core.AccountManager;
import net.xmind.share.FileValidationException;
import net.xmind.share.Info;
import net.xmind.share.Messages;
import net.xmind.share.jobs.UploadJob;
import net.xmind.share.jobs.UploadSession;
import net.xmind.signin.IAccountInfo;
import net.xmind.signin.IAuthenticationListener;
import net.xmind.signin.XMindNet;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.xmind.core.Core;
import org.xmind.core.IMeta;
import org.xmind.core.ISerializer;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.GEF;
import org.xmind.ui.exports.vector.svg.SVGGenerator;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapExtractor;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.resources.ColorUtils;

public class Uploader
extends JobChangeAdapter {
    private Shell parentShell;
    private IMindMapViewer sourceViewer;
    private IWorkbook workbook;
    private MindMapExtractor extractor;
    private Info info;
    private Point origin;
    private Image fullImage;
    private File file;
    private boolean trimmed = false;
    private DoneCallback callback;
    private UploadJob uploadJob;
    private boolean canceled;
    private String title;
    private String description;
    private String languageChannel;
    private String privacy;

    public Uploader(Shell parentShell, IMindMapViewer sourceViewer) {
        this.parentShell = parentShell;
        this.sourceViewer = sourceViewer;
    }

    public Uploader(Shell parentShell, IMindMapViewer sourceViewer, String title, String description, String languageChannel, String privacy) {
        this.parentShell = parentShell;
        this.sourceViewer = sourceViewer;
        this.title = title;
        this.description = description;
        this.languageChannel = languageChannel;
        this.privacy = privacy;
    }

    public void upload() {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                Uploader.this.doUpload();
            }
        });
    }

    public void upload(DoneCallback callback) {
        this.callback = callback;
        this.doUpload();
    }

    private void doUpload() {
        this.info = new Info();
        boolean prepared = false;
        try {
            prepared = this.prepare();
        }
        catch (OutOfMemoryError e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.xmindshare.uploader", Messages.ErrorDialog_OutOfMemory_message, (Throwable)e), 2);
        }
        catch (Throwable e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.xmindshare.uploader", Messages.ErrorDialog_UnexpectedError_message, e), 2);
        }
        if (!prepared) {
            this.clearTemp();
            return;
        }
        if (this.canceled) {
            return;
        }
        this.uploadJob = new UploadJob(this.info, this.createSvgGenerator());
        this.uploadJob.setSystem(true);
        this.uploadJob.setUser(false);
        this.uploadJob.addJobChangeListener((IJobChangeListener)this);
        this.uploadJob.schedule();
    }

    private boolean prepare() throws Exception {
        boolean goon;
        if (!this.signIn()) {
            return false;
        }
        if (!this.checkUserInfoValidity()) {
            return false;
        }
        if (this.callback != null && !(goon = this.callback.signInSuccess())) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.Uploader_unavailable_dialog_tile, (String)Messages.Uploader_unavailable_dialog_message);
            this.callback.cancel();
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
            if (handlerService != null) {
                handlerService.executeCommand("org.xmind.ui.command.share", null);
            }
            return false;
        }
        Display display = null;
        display = this.parentShell != null && !this.parentShell.isDisposed() ? this.parentShell.getDisplay() : Display.getDefault();
        this.info.setProperty("multiSheets", this.multiSheets(this.sourceViewer));
        this.extractor = new MindMapExtractor(this.sourceViewer);
        this.workbook = this.extractor.extract();
        this.trimWorkbook();
        this.generatePreview(display);
        if (this.fullImage == null || this.origin == null) {
            throw new RuntimeException(Messages.failedToGenerateThumbnail);
        }
        this.checkTitle();
        this.info.setProperty("Title", this.title);
        this.info.setProperty("Description", this.description);
        this.info.setProperty("Share/LanguageChannel", this.languageChannel);
        this.info.setProperty("Share/Privacy", this.privacy);
        this.info.setProperty("FullImage", this.fullImage);
        this.info.setInt("Thumbnail/Origin/X", this.origin.x);
        this.info.setInt("Thumbnail/Origin/Y", this.origin.y);
        this.info.setProperty("Thumbnail/BackgroundColor", this.getBackgroundColor());
        this.info.setProperty("Trimmed", this.trimmed);
        IMeta meta = this.workbook.getMeta();
        meta.setValue("Description", this.info.getString("Description"));
        meta.setValue("Thumbnail/X", String.valueOf(0));
        meta.setValue("Thumbnail/Y", String.valueOf(0));
        meta.setValue("Thumbnail/Scale", String.valueOf(0.5));
        meta.setValue("Thumbnail/Origin/X", String.valueOf(this.origin.x));
        meta.setValue("Thumbnail/Origin/Y", String.valueOf(this.origin.y));
        meta.setValue("Thumbnail/BackgroundColor", this.info.getString("Thumbnail/BackgroundColor"));
        meta.setValue("Share/Privacy", this.info.getString("Share/Privacy", "1"));
        meta.setValue("Share/Downloadable", this.info.getString("Share/Downloadable", "1"));
        meta.setValue("Share/LanguageChannel", this.info.getString("Share/LanguageChannel"));
        if (this.file == null) {
            String tempFile = Core.getWorkspace().getTempFile("upload/" + UUID.randomUUID().toString() + ".xmind");
            this.file = new File(tempFile);
        }
        FileOutputStream output = new FileOutputStream(this.file);
        try {
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(this.workbook);
            serializer.setOutputStream((OutputStream)output);
            serializer.serialize(null);
        }
        finally {
            ((OutputStream)output).close();
        }
        String path = this.file.getAbsolutePath();
        Uploader.validateUploadFile(path);
        if (!this.file.exists() || !this.file.canRead()) {
            throw new FileNotFoundException(Messages.failedToGenerateUploadFile);
        }
        this.info.setProperty("File", this.file);
        this.info.setProperty("Workbook", this.workbook);
        return true;
    }

    private void checkTitle() {
        if (this.title == null || this.title.equals("")) {
            if (this.sourceViewer != null && this.sourceViewer.getCentralTopic() != null) {
                this.title = this.sourceViewer.getCentralTopic().getTitleText();
                if ((this.title == null || this.title.equals("")) && this.sourceViewer.getSheet() != null) {
                    this.title = this.sourceViewer.getSheet().getTitleText();
                }
            }
            if (this.title == null || this.title.equals("")) {
                this.title = "null";
            }
        }
    }

    private boolean signIn() {
        IAccountInfo accountInfo = XMindNet.signIn();
        if (accountInfo != null) {
            this.info.setProperty("UserID", accountInfo.getUser());
            this.info.setProperty("Token", accountInfo.getAuthToken());
            this.info.setProperty("CnUser", AccountManager.getPrimaryAccount().isCnUser());
            return true;
        }
        return false;
    }

    private boolean checkUserInfoValidity() {
        IAccountInfo accountInfo;
        String token;
        String userID = this.info.getString("UserID");
        return !this.isInvalidToken(userID, token = this.info.getString("Token"), accountInfo = XMindNet.getAccountInfo());
    }

    private boolean isInvalidToken(String userID, String token, IAccountInfo currentInfo) {
        if (userID == null || token == null) {
            return true;
        }
        if (currentInfo == null) {
            return true;
        }
        return !userID.equals(currentInfo.getUser()) || !token.equals(currentInfo.getAuthToken());
    }

    private Boolean multiSheets(IMindMapViewer sourceViewer) {
        IWorkbook workbook = (IWorkbook)sourceViewer.getAdapter(IWorkbook.class);
        if (workbook.getSheets().size() > 1) {
            return true;
        }
        return false;
    }

    private void trimWorkbook() {
        this.trim();
    }

    private void trim() {
        for (ISheet sheet : this.workbook.getSheets()) {
            this.trim(sheet.getRootTopic());
        }
    }

    private void trim(ITopic topic) {
        String hyperlink = topic.getHyperlink();
        if (hyperlink != null) {
            if (HyperlinkUtils.isAttachmentURL((String)hyperlink)) {
                topic.setHyperlink(null);
                this.trimmed = true;
            }
            if (HyperlinkUtils.getProtocolName((String)hyperlink) != null && HyperlinkUtils.getProtocolName((String)hyperlink).equals("file")) {
                topic.setHyperlink(null);
                this.trimmed = true;
            }
            if (HyperlinkUtils.isInternalURL((String)hyperlink) && this.workbook.findTopic(hyperlink.substring(hyperlink.indexOf(35) + 1)) == null) {
                topic.setHyperlink(null);
                this.trimmed = true;
            }
        }
        if (topic.getExtension("org.xmind.ui.audionotes") != null) {
            topic.deleteExtension("org.xmind.ui.audionotes");
            this.trimmed = true;
        }
        for (ITopic c : topic.getAllChildren()) {
            this.trim(c);
        }
    }

    private void generatePreview(Display display) {
        MindMapImageExporter exporter = new MindMapImageExporter(display);
        exporter.setSource((Object)new MindMap(this.workbook.getPrimarySheet()), null, null);
        exporter.setTargetWorkbook(this.workbook);
        this.fullImage = exporter.createImage();
        exporter.export(this.fullImage);
        this.origin = exporter.calcRelativeOrigin();
    }

    private String getBackgroundColor() {
        Color color;
        Layer layer = this.sourceViewer.getLayer(GEF.LAYER_BACKGROUND);
        if (layer != null && (color = layer.getBackgroundColor()) != null) {
            return ColorUtils.toString((Color)color);
        }
        return "#ffffff";
    }

    private void clearTemp() {
        if (this.fullImage != null) {
            this.fullImage.dispose();
            this.fullImage = null;
        }
        if (this.extractor != null) {
            this.extractor.delete();
            this.extractor = null;
        }
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
        this.workbook = null;
    }

    private SVGGenerator createSvgGenerator() {
        Display display = Display.getCurrent();
        Shell parentShell = display.getActiveShell();
        IMindMap mindmap = this.sourceViewer.getMindMap();
        return new SVGGenerator(mindmap, this.sourceViewer, display, parentShell, true, true, true);
    }

    public void done(IJobChangeEvent event) {
        final IStatus result = event.getResult();
        final UploadSession session = ((UploadJob)event.getJob()).getSession();
        this.runInUI(new Runnable(){

            public void run() {
                if (result.isOK()) {
                    Uploader.this.clearTemp();
                    if (Uploader.this.callback != null) {
                        Uploader.this.callback.done(session.getDataMap());
                    }
                } else if (result.matches(6)) {
                    if (!Uploader.this.canceled) {
                        Uploader.this.promptError(session.getStatus(), result);
                    } else {
                        Uploader.this.clearTemp();
                    }
                }
            }
        });
    }

    private void runInUI(Runnable runnable) {
        Display display = null;
        display = this.parentShell != null && !this.parentShell.isDisposed() ? this.parentShell.getDisplay() : Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void promptError(int uploadStatus, IStatus error) {
        int httpStatus = error.getCode();
        String message = null;
        boolean tryAgainAllowed = true;
        if (uploadStatus == 1) {
            if (httpStatus == 401) {
                this.resignin();
                return;
            }
        } else if (uploadStatus == 2) {
            if (httpStatus == 404) {
                this.internalCancel();
                return;
            }
            if (httpStatus == 1001) {
                message = Messages.ErrorDialog_Unauthorized_message;
                tryAgainAllowed = false;
            }
        }
        if (message == null) {
            message = Messages.ErrorDialog_message;
        }
        if (tryAgainAllowed) {
            if (MessageDialog.openQuestion(null, (String)Messages.ErrorDialog_title, (String)message)) {
                this.retry();
                return;
            }
        } else {
            MessageDialog.openError(null, (String)Messages.ErrorDialog_title, (String)message);
        }
        this.internalCancel();
    }

    private void resignin() {
        XMindNet.signOut();
        XMindNet.signIn((IAuthenticationListener)new IAuthenticationListener(){

            public void postSignIn(IAccountInfo accountInfo) {
                Uploader.this.retry();
            }

            public void postSignOut(IAccountInfo oldAccountInfo) {
            }
        }, (boolean)false);
    }

    private void retry() {
        this.runInUI(new Runnable(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        Uploader.this.uploadJob.schedule();
                    }
                });
            }
        });
    }

    private void internalCancel() {
        this.clearTemp();
        if (this.callback != null) {
            this.callback.cancel();
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.uploadJob != null) {
            this.uploadJob.cancel();
        }
    }

    public static void validateUploadFile(String path) throws FileValidationException {
        HashSet<String> entries = new HashSet<String>();
        try {
            ZipInputStream zin = new ZipInputStream(new FileInputStream(path));
            try {
                ZipEntry e;
                while ((e = zin.getNextEntry()) != null) {
                    String name = e.getName();
                    entries.add(name);
                }
            }
            finally {
                zin.close();
            }
        }
        catch (Throwable e) {
            throw new FileValidationException("File Validation Failed: " + e.getLocalizedMessage(), e);
        }
        if (!entries.contains("Thumbnails/thumbnail.png")) {
            throw new FileValidationException("File Validation Failed: missing entry 'Thumbnails/thumbnail.png'");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoneCallback {
        public boolean signInSuccess();

        public void done(Map<Object, Object> var1);

        public void cancel();
    }
}

