/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.verify.ui.internal;

import java.util.Properties;
import net.xmind.signin.XMindNet;
import net.xmind.verify.internal.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.SWTUtils;

public class LicenseKeyInputDialog2
extends TitleAreaDialog {
    public static final int CLEARED = 1024;
    public static final int CLOSE = 1025;
    private Properties data;
    private IStatus validity;
    private boolean sheet;
    private boolean showClear;
    private String errorMessage = null;
    private Image titleImage;
    private ResourceManager resources;
    private static String __PLACEHOLDER_TEXT__ = null;

    public LicenseKeyInputDialog2(Shell parentShell, Properties data, int requiredStatus, IStatus validity, boolean sheet, boolean showClear) {
        super(parentShell);
        Assert.isNotNull((Object)data);
        this.data = data;
        this.validity = validity;
        this.sheet = sheet;
        this.showClear = showClear;
        if (sheet) {
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }
    }

    public Properties getData() {
        return this.data;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.sheet) {
            newShell.setText(this.getParentShell().getText());
        } else {
            newShell.setText(Messages.LicenseKeyInputDialog_LicenseKey_Title);
        }
    }

    public void create() {
        super.create();
        this.setTitle(this.getTitleMessage());
        if (this.titleImage == null) {
            this.titleImage = XMindNet.createBannerLogo();
        }
        if (this.titleImage != null) {
            this.setTitleImage(this.titleImage);
        }
        if (this.errorMessage == null) {
            this.setMessage(this.getDialogMessage());
        } else {
            this.setMessage(this.errorMessage, 2);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite detailArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 15;
        layout.marginWidth = 13;
        detailArea.setLayout((Layout)layout);
        detailArea.setLayoutData((Object)new GridData(1808));
        this.createInputs(detailArea);
        return composite;
    }

    private String getTitleMessage() {
        String plan;
        String brandingVersion = System.getProperty("org.xmind.product.brandingVersion", "");
        if ((this.validity.getCode() & 2) != 0) {
            plan = NLS.bind((String)Messages.LicenseInputDialog_proTitle, (Object)brandingVersion);
        } else if ((this.validity.getCode() & 4) != 0 && (this.validity.getCode() & 2) == 0) {
            plan = NLS.bind((String)Messages.LicenseInputDialog_plusTitle, (Object)brandingVersion);
        } else {
            return Messages.LicenseKeyInputDialog_LicenseKey_Title;
        }
        return plan;
    }

    private String getDialogMessage() {
        String plan;
        String brandingVersion = System.getProperty("org.xmind.product.brandingVersion", "");
        if ((this.validity.getCode() & 2) != 0) {
            plan = NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindProLicense, (Object)brandingVersion);
        } else if ((this.validity.getCode() & 4) != 0 && (this.validity.getCode() & 2) == 0) {
            plan = NLS.bind((String)Messages.LicenseInputDialog_LicenseName_XMindPlusLicense, (Object)brandingVersion);
        } else {
            String plan2 = "Pro/Plus";
            return NLS.bind((String)Messages.LicenseKeyInputDialog_DialogMessage, (Object)plan2, (Object)brandingVersion);
        }
        return NLS.bind((String)Messages.LicenseInputDialog_LicensedMessage, (Object)plan, (Object)(this.getLicenseTo() == null ? Messages.LicenseInputDialog_UnknownLicensee : this.getLicenseTo()));
    }

    private String getLicenseTo() {
        return this.data.getProperty("TimeSmilesInMyHand");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtonStatus();
        return contents;
    }

    private void createInputs(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createInputLabel(composite, Messages.LicenseKeyInputDialog_License_label);
        this.createInput(composite, "TimeSmilesInMyHand", false, -1, -1);
        this.createInputLabel(composite, Messages.LicenseKeyInputDialog_LicenseKey_label);
        this.createInput(composite, "WalkingInTheMorning", true, 130, 12);
        this.createInputLabel(composite, "");
        if (this.data.getProperty("TimeSmilesInMyHand") != null && this.showClear) {
            this.createClearLink(composite);
        }
    }

    private Control createInputLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(0x1000008, 1, false, false));
        label.setFont(JFaceResources.getDefaultFont());
        return label;
    }

    private Control createInput(Composite parent, final String propName, boolean wrap, int height, int fontSize) {
        String initValue = this.data.getProperty(propName);
        if (!this.showClear) {
            int style = 2048;
            style = wrap ? (style |= 0x40) : (style |= 4);
            Text input = new Text(parent, style);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.minimumWidth = 320;
            gridData.widthHint = 320;
            gridData.heightHint = height;
            input.setLayoutData((Object)gridData);
            this.setFont((Control)input, fontSize);
            if (initValue != null) {
                input.setText(initValue);
            }
            input.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LicenseKeyInputDialog2.this.setErrorMessage(null);
                    String value = ((Text)e.widget).getText();
                    LicenseKeyInputDialog2.this.data.setProperty(propName, value);
                    LicenseKeyInputDialog2.this.updateButtonStatus();
                }
            });
            if (wrap) {
                input.addListener(1, new Listener(){

                    public void handleEvent(Event event) {
                        if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)13)) {
                            LicenseKeyInputDialog2.this.buttonPressed(0);
                            event.doit = false;
                        }
                    }
                });
            }
            return input;
        }
        Label label = new Label(parent, 64);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 320;
        gridData.widthHint = 320;
        gridData.heightHint = height;
        label.setLayoutData((Object)gridData);
        this.setFont((Control)label, fontSize);
        label.setText(initValue);
        return label;
    }

    private void setFont(final Control control, final int fontSize) {
        if (fontSize > 0) {
            control.setFont((Font)this.resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setHeight(fontSize)));
            control.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle area = control.getBounds();
                    int newFontSize = LicenseKeyInputDialog2.this.calcFontSize(fontSize, area.width - 10, area.height - 10);
                    if (newFontSize != fontSize) {
                        control.setFont((Font)LicenseKeyInputDialog2.this.resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setHeight(newFontSize)));
                    }
                }
            });
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int calcFontSize(int defaultFontSize, int maxWidth, int maxHeight) {
        int fontSize = defaultFontSize;
        GC gc = new GC((Drawable)this.getShell());
        try {
            block7: {
                Point size;
                block6: {
                    size = null;
                    if (!true) break block6;
                    if (size != null) return fontSize;
                    if (fontSize <= 0) break block7;
                }
                do {
                    gc.setFont((Font)this.resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setHeight(fontSize)));
                    size = gc.textExtent(LicenseKeyInputDialog2.getPlaceholderText(), 2);
                    if (size.x > maxWidth || size.y > maxHeight) {
                        --fontSize;
                        size = null;
                    }
                    if (size != null) return fontSize;
                } while (fontSize > 0);
            }
            return fontSize;
        }
        finally {
            gc.dispose();
        }
    }

    private void createClearLink(Composite parent) {
        Hyperlink clearLink = new Hyperlink(parent, 0);
        parent.setFocus();
        clearLink.setText(Messages.LicenseKeyInputDialog_Clear_linkText);
        clearLink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        clearLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LicenseKeyInputDialog2.this.clearPressed();
            }
        });
    }

    private void clearPressed() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.LicenseKeyInputDialog_ClearDialog_title, (String)Messages.LicenseKeyInputDialog_ClearDialog_message)) {
            this.data.remove("TimeSmilesInMyHand");
            this.data.remove("WalkingInTheMorning");
            this.setReturnCode(1024);
            this.close();
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.widthHint = -1;
        layoutData.heightHint = -1;
        composite.setLayoutData((Object)layoutData);
        Composite leftBar = new Composite(composite, 0);
        GridLayout leftLayout = new GridLayout();
        leftLayout.numColumns = 0;
        leftLayout.makeColumnsEqualWidth = true;
        leftLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        leftLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        leftLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        leftLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        leftBar.setLayout((Layout)leftLayout);
        GridData leftLayoutData = new GridData(1, 0x1000000, true, false);
        leftLayoutData.widthHint = -1;
        leftLayoutData.heightHint = -1;
        leftBar.setLayoutData((Object)leftLayoutData);
        leftBar.setFont(parent.getFont());
        if (!this.showClear) {
            this.createButtonsFroLeftButtonBar(leftBar);
        }
        Composite buttonBar = (Composite)super.createButtonBar(composite);
        return buttonBar;
    }

    protected void createButtonsFroLeftButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.LicenseKeyInputDialog_BackButton_Text, false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.showClear) {
            this.createButton(parent, 0, Messages.LicenseKeyInputDialog_VerifyButton_Text, true);
        }
        this.createButton(parent, 12, Messages.LicenseKeyInputDialog_CloseButton_Text, this.showClear);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.closeDialog();
        }
        if (buttonId == 1) {
            if (this.showClear) {
                this.closeDialog();
            } else {
                super.cancelPressed();
            }
        }
        if (buttonId == 0) {
            super.okPressed();
        }
    }

    private void closeDialog() {
        this.setReturnCode(1025);
        this.close();
    }

    private void updateButtonStatus() {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(this.canFinish() && !this.showClear);
        }
        if ((button = this.getButton(1)) != null && !button.isDisposed()) {
            button.setEnabled(!this.showClear);
        }
    }

    private boolean canFinish() {
        return this.hasValue("TimeSmilesInMyHand") && this.hasValue("WalkingInTheMorning");
    }

    private boolean hasValue(String propName) {
        String value = this.data.getProperty(propName);
        return value != null && !"".equals(value);
    }

    private static synchronized String getPlaceholderText() {
        if (__PLACEHOLDER_TEXT__ == null) {
            StringBuilder sb = new StringBuilder(315);
            int i = 0;
            while (i < 7) {
                int j = 0;
                while (j < 9) {
                    if (j > 0) {
                        sb.append('-');
                    }
                    sb.append("XXXXX");
                    ++j;
                }
                sb.append(System.getProperty("line.separator"));
                ++i;
            }
            __PLACEHOLDER_TEXT__ = sb.toString();
        }
        return __PLACEHOLDER_TEXT__;
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }
}

