/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.geometry;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Size;

public final class Region {
    private final Position position;
    private final Size size;

    public Region(Position position, Size size) {
        if (position == null) {
            throw new NullPointerException("Position cannot be null.");
        }
        if (size == null) {
            throw new NullPointerException("Size cannot be null.");
        }
        this.position = position;
        this.size = size;
    }

    public Position getPosition() {
        return this.position;
    }

    public Size getSize() {
        return this.size;
    }

    public Rectangle calculate(int width, int height) {
        Dimension d = this.size.calculate(width, height);
        Point p = this.position.calculate(width, height, d.width, d.height, 0, 0, 0, 0);
        Rectangle outerRectangle = new Rectangle(0, 0, width, height);
        Rectangle innerRectangle = new Rectangle(p, d);
        return outerRectangle.intersection(innerRectangle);
    }

    public String toString() {
        return "Region [position=" + this.position + ", size=" + this.size + "]";
    }
}

