/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import org.xmind.gef.draw2d.AbstractAnchor;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.gantt2.gefext.GraphicalEditPart;
import org.xmind.ui.gantt2.gefext.IConnection;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.INodePart;

public class ConnectionPart
extends GraphicalEditPart
implements IConnectionPart {
    private static final PrecisionPoint DEFAULT_LOCATION = new PrecisionPoint();
    private static final IAnchor DEFAULT_ANCHOR = new AbstractAnchor(){

        public PrecisionPoint getLocation(double x, double y, double expansion) {
            return DEFAULT_LOCATION;
        }
    };
    private INodePart sourceNode = null;
    private INodePart targetNode = null;

    public INodePart getSourceNode() {
        return this.sourceNode;
    }

    public INodePart getTargetNode() {
        return this.targetNode;
    }

    public void setSourceNode(INodePart node) {
        if (node == this.sourceNode) {
            return;
        }
        INodePart oldNode = this.sourceNode;
        this.sourceNode = node;
        this.sourceNodeChanged(this.sourceNode, oldNode);
    }

    protected void sourceNodeChanged(INodePart node, INodePart oldNode) {
        this.refreshSourceAnchor();
    }

    public void setTargetNode(INodePart node) {
        if (node == this.targetNode) {
            return;
        }
        INodePart oldNode = this.targetNode;
        this.targetNode = node;
        this.targetNodeChanged(node, oldNode);
    }

    protected void targetNodeChanged(INodePart node, INodePart oldNode) {
        this.refreshTargetAnchor();
    }

    protected void refreshSourceAnchor() {
        if (this.getFigure() instanceof IConnection) {
            IAnchor sourceAnchor = null;
            if (this.getSourceNode() != null) {
                sourceAnchor = this.getSourceNode().getSourceAnchor((IGraphicalPart)this);
            }
            if (sourceAnchor == null) {
                sourceAnchor = DEFAULT_ANCHOR;
            }
            ((IConnection)this.getFigure()).setSourceAnchor(sourceAnchor);
        }
    }

    protected void refreshTargetAnchor() {
        if (this.getFigure() instanceof IConnection) {
            IAnchor targetAnchor = null;
            if (this.getTargetNode() != null) {
                targetAnchor = this.getTargetNode().getTargetAnchor((IGraphicalPart)this);
            }
            if (targetAnchor == null) {
                targetAnchor = DEFAULT_ANCHOR;
            }
            ((IConnection)this.getFigure()).setTargetAnchor(targetAnchor);
        }
    }
}

