/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.util.Log;

public class DialogUtil {
    public static void displayCoreErrorDialog(Shell parent, String errorId, CoreException coreEx) {
        String title = IntroPlugin.getString("ErrorDialog.errorTitle");
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        IStatus status = coreEx.getStatus();
        String msg = IntroPlugin.getString(errorId);
        ErrorDialog.openError((Shell)parent, (String)title, (String)msg, (IStatus)status);
        Log.error(msg, (Throwable)coreEx);
    }

    public static void displayErrorMessage(Shell parent, String msg, Throwable ex) {
        String title = IntroPlugin.getString("MessageDialog.errorTitle");
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        MessageDialog.openError((Shell)parent, (String)title, (String)msg);
        Log.error(msg, ex);
    }

    public static void displayErrorMessage(Shell parent, String errorId, Object[] variables, Throwable ex) {
        String msg = null;
        msg = variables != null ? IntroPlugin.getFormattedString(errorId, variables) : IntroPlugin.getString(errorId);
        DialogUtil.displayErrorMessage(parent, msg, ex);
    }

    public static void displayWarningMessage(Shell parent, String msg) {
        String title = IntroPlugin.getString("MessageDialog.warningTitle");
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        MessageDialog.openWarning((Shell)parent, (String)title, (String)msg);
        Log.warning(msg);
    }

    public static void displayWarningMessage(Shell parent, String warningId, Object[] variables) {
        String msg = null;
        msg = variables != null ? IntroPlugin.getFormattedString(warningId, variables) : IntroPlugin.getString(warningId);
        DialogUtil.displayWarningMessage(parent, msg);
    }

    public static void displayInfoMessage(Shell parent, String msg) {
        String title = IntroPlugin.getString("MessageDialog.infoTitle");
        if (parent == null) {
            parent = DialogUtil.getActiveShell();
        }
        MessageDialog.openInformation((Shell)parent, (String)title, (String)msg);
        Log.info(msg);
    }

    public static void displayInfoMessage(Shell parent, String infoId, Object[] variables) {
        String msg = null;
        msg = variables != null ? IntroPlugin.getFormattedString(infoId, variables) : IntroPlugin.getString(infoId);
        DialogUtil.displayInfoMessage(parent, msg);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveShell() {
        Display display = DialogUtil.getCurrentDisplay();
        Shell activeShell = display.getActiveShell();
        if (activeShell == null) {
            return DialogUtil.getActiveWorkbenchWindow().getShell();
        }
        return activeShell;
    }

    public static Display getCurrentDisplay() {
        Display display = Display.getCurrent();
        if (display != null) {
            return display;
        }
        return Display.getDefault();
    }
}

