/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views;

import org.eclipse.ant.internal.ui.model.AntImageDescriptor;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.views.AntViewMessages;
import org.eclipse.ant.internal.ui.views.elements.ProjectNode;
import org.eclipse.ant.internal.ui.views.elements.TargetNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class AntViewLabelProvider
implements ILabelProvider,
IColorProvider {
    public Image getImage(Object element) {
        if (element instanceof ProjectNode) {
            ProjectNode project = (ProjectNode)element;
            int flags = 0;
            if (project.isErrorNode()) {
                flags |= 1;
            }
            AntImageDescriptor descriptor = new AntImageDescriptor(AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antProject"), flags);
            return AntUIImages.getImage(descriptor);
        }
        if (element instanceof TargetNode) {
            TargetNode target = (TargetNode)element;
            int flags = 0;
            ImageDescriptor base = null;
            base = target.equals(target.getProject().getDefaultTarget()) ? AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antDefaultTarget") : (target.getDescription() == null ? AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antPrivateTarget") : AntUIImages.getImageDescriptor("org.eclipse.ant.ui.antTarget"));
            if (target.isErrorNode()) {
                flags |= 1;
            }
            return AntUIImages.getImage(new AntImageDescriptor(base, flags));
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TargetNode) {
            TargetNode node = (TargetNode)element;
            StringBuffer name = new StringBuffer(node.getName());
            if (node.getName().equals(node.getProject().getDefaultTargetName())) {
                name.append(AntViewMessages.getString("TargetNode.default"));
            }
            return name.toString();
        }
        if (element instanceof ProjectNode) {
            ProjectNode project = (ProjectNode)element;
            StringBuffer buffer = new StringBuffer(project.getName());
            String defaultTarget = project.getDefaultTargetName();
            if (defaultTarget != null) {
                buffer.append(" [").append(defaultTarget).append(']');
            }
            return buffer.toString();
        }
        return element.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getForeground(Object element) {
        TargetNode target;
        if (element instanceof TargetNode && (target = (TargetNode)element) == target.getProject().getDefaultTarget()) {
            return Display.getDefault().getSystemColor(9);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

