/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.PDETemplateSection;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.TemplateOption;

public class HelloWorldTemplate
extends PDETemplateSection {
    public static final String KEY_CLASS_NAME = "className";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_ADD_TO_PERSPECTIVE = "addToPerspective";
    public static final String CLASS_NAME = "SampleAction";
    private static final String KEY_TITLE = "HelloWorldTemplate.title";
    private static final String KEY_DESC = "HelloWorldTemplate.desc";
    private static final String KEY_PACKAGE_LABEL = "HelloWorldTemplate.packageName";
    private static final String KEY_CLASS_LABEL = "HelloWorldTemplate.className";
    private static final String KEY_TEXT_LABEL = "HelloWorldTemplate.messageText";
    private static final String KEY_DEFAULT_MESSAGE = "HelloWorldTemplate.defaultMessage";
    private static final String KEY_SAMPLE_ACTION_SET = "HelloWorldTemplate.sampleActionSet";
    private static final String KEY_SAMPLE_MENU = "HelloWorldTemplate.sampleMenu";
    private static final String KEY_SAMPLE_ACTION = "HelloWorldTemplate.sampleAction";

    public HelloWorldTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public String getSectionId() {
        return "helloWorld";
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    private void createOptions() {
        this.addOption("packageName", PDEPlugin.getResourceString(KEY_PACKAGE_LABEL), null, 0);
        this.addOption(KEY_CLASS_NAME, PDEPlugin.getResourceString(KEY_CLASS_LABEL), CLASS_NAME, 0);
        this.addOption(KEY_MESSAGE, PDEPlugin.getResourceString(KEY_TEXT_LABEL), PDEPlugin.getResourceString(KEY_DEFAULT_MESSAGE), 0);
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_hello_world");
        page.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        page.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] allPageOptions = this.getOptions(0);
        for (int i = 0; i < allPageOptions.length; ++i) {
            TemplateOption nextOption = allPageOptions[i];
            if (!nextOption.isRequired() || !nextOption.isEmpty()) continue;
            this.flagMissingRequiredOption(nextOption);
            return;
        }
        this.resetPageState();
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", id + ".actions");
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", pluginId + ".actions");
    }

    public String getUsedExtensionPoint() {
        return "org.eclipse.ui.actionSets";
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension("org.eclipse.ui.actionSets", true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginElement setElement = factory.createElement((IPluginObject)extension);
        setElement.setName("actionSet");
        setElement.setAttribute("id", plugin.getId() + ".actionSet");
        setElement.setAttribute("label", PDEPlugin.getResourceString(KEY_SAMPLE_ACTION_SET));
        setElement.setAttribute("visible", "true");
        IPluginElement menuElement = factory.createElement((IPluginObject)setElement);
        menuElement.setName("menu");
        menuElement.setAttribute("label", PDEPlugin.getResourceString(KEY_SAMPLE_MENU));
        menuElement.setAttribute("id", "sampleMenu");
        IPluginElement groupElement = factory.createElement((IPluginObject)menuElement);
        groupElement.setName("separator");
        groupElement.setAttribute("name", "sampleGroup");
        menuElement.add((IPluginObject)groupElement);
        setElement.add((IPluginObject)menuElement);
        String fullClassName = this.getStringOption("packageName") + "." + this.getStringOption(KEY_CLASS_NAME);
        IPluginElement actionElement = factory.createElement((IPluginObject)setElement);
        actionElement.setName("action");
        actionElement.setAttribute("id", fullClassName);
        actionElement.setAttribute("label", PDEPlugin.getResourceString(KEY_SAMPLE_ACTION));
        actionElement.setAttribute("menubarPath", "sampleMenu/sampleGroup");
        actionElement.setAttribute("toolbarPath", "sampleGroup");
        actionElement.setAttribute("icon", "icons/sample.gif");
        actionElement.setAttribute("tooltip", PDEPlugin.getResourceString(KEY_DEFAULT_MESSAGE));
        actionElement.setAttribute("class", fullClassName);
        setElement.add((IPluginObject)actionElement);
        extension.add((IPluginObject)setElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }

    public String[] getNewFiles() {
        return new String[]{"icons/"};
    }
}

