/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.Tokenizer;
import org.osgi.framework.BundleException;

public class ManifestElement {
    protected String value;
    protected String[] valueComponents;
    protected Hashtable attributes;

    protected ManifestElement() {
    }

    public String getValue() {
        return this.value;
    }

    public String[] getValueComponents() {
        return this.valueComponents;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        Object result = this.attributes.get(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        ArrayList valueList = (ArrayList)result;
        return (String)valueList.get(valueList.size() - 1);
    }

    public String[] getAttributes(String key) {
        if (this.attributes == null) {
            return null;
        }
        Object result = this.attributes.get(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return new String[]{(String)result};
        }
        ArrayList valueList = (ArrayList)result;
        return valueList.toArray(new String[valueList.size()]);
    }

    public Enumeration getKeys() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.keys();
    }

    protected void addAttribute(String key, String value) {
        Object curValue;
        if (this.attributes == null) {
            this.attributes = new Hashtable(7);
        }
        if ((curValue = this.attributes.get(key)) != null) {
            ArrayList<String> newList;
            if (curValue instanceof ArrayList) {
                newList = (ArrayList<String>)curValue;
            } else {
                newList = new ArrayList<String>(5);
                newList.add((String)curValue);
            }
            newList.add(value);
            this.attributes.put(key, newList);
        } else {
            this.attributes.put(key, value);
        }
    }

    public static ManifestElement[] parseHeader(String header, String value) throws BundleException {
        char c;
        if (value == null) {
            return null;
        }
        Vector<ManifestElement> headerElements = new Vector<ManifestElement>(10, 10);
        Tokenizer tokenizer = new Tokenizer(value);
        do {
            String next;
            if ((next = tokenizer.getToken(";,")) == null) {
                throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", header, value));
            }
            ArrayList<String> headerValues = new ArrayList<String>();
            StringBuffer headerValue = new StringBuffer(next);
            headerValues.add(next);
            if (Debug.DEBUG_MANIFEST) {
                Debug.print("paserHeader: " + next);
            }
            c = tokenizer.getChar();
            while (c == ';') {
                next = tokenizer.getToken(";,=");
                if (next == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", header, value));
                }
                c = tokenizer.getChar();
                if (c != ';') continue;
                headerValues.add(next);
                headerValue.append(";").append(next);
                if (!Debug.DEBUG_MANIFEST) continue;
                Debug.print(";" + next);
            }
            ManifestElement manifestElement = new ManifestElement();
            manifestElement.value = headerValue.toString();
            manifestElement.valueComponents = headerValues.toArray(new String[headerValues.size()]);
            while (c == '=') {
                String val = tokenizer.getString(";,");
                if (val == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", header, value));
                }
                if (Debug.DEBUG_MANIFEST) {
                    Debug.print(";" + next + "=" + val);
                }
                try {
                    manifestElement.addAttribute(next, val);
                }
                catch (Exception e) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", header, value), (Throwable)e);
                }
                c = tokenizer.getChar();
                if (c != ';') continue;
                next = tokenizer.getToken("=");
                if (next == null) {
                    throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", header, value));
                }
                c = tokenizer.getChar();
            }
            headerElements.addElement(manifestElement);
            if (!Debug.DEBUG_MANIFEST) continue;
            Debug.println("");
        } while (c == ',');
        if (c != '\u0000') {
            throw new BundleException(Msg.formatter.getString("MANIFEST_INVALID_HEADER_EXCEPTION", header, value));
        }
        int size = headerElements.size();
        if (size == 0) {
            return null;
        }
        Object[] result = new ManifestElement[size];
        headerElements.copyInto(result);
        return result;
    }
}

