/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.AmountOfWorkCalculator;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchVisitor;
import org.eclipse.search.internal.ui.SearchMessages;

public class TextSearchEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IStatus search(IWorkspace workspace, ISearchScope scope, boolean visitDerived, ITextSearchResultCollector collector, MatchLocator matchLocator) {
        MultiStatus status;
        block11: {
            Assert.isNotNull((Object)workspace);
            Assert.isNotNull((Object)scope);
            Assert.isNotNull((Object)collector);
            Assert.isNotNull((Object)matchLocator);
            IProgressMonitor monitor = collector.getProgressMonitor();
            IProject[] projects = workspace.getRoot().getProjects();
            ArrayList<IProject> openProjects = new ArrayList<IProject>(10);
            for (int i = 0; i < projects.length; ++i) {
                IProject project = projects[i];
                if (!project.isOpen()) continue;
                openProjects.add(project);
            }
            String message = SearchMessages.getString("TextSearchEngine.statusMessage");
            status = new MultiStatus("org.eclipse.search", 0, message, null);
            if (!openProjects.isEmpty()) {
                int amountOfWork = new AmountOfWorkCalculator(status, visitDerived).process(openProjects, scope);
                monitor.beginTask("", amountOfWork);
                if (amountOfWork > 0) {
                    Object[] args = new Integer[]{new Integer(1), new Integer(amountOfWork)};
                    monitor.setTaskName(SearchMessages.getFormattedString("TextSearchEngine.scanning", args));
                }
                collector.aboutToStart();
                TextSearchVisitor visitor = new TextSearchVisitor(matchLocator, scope, visitDerived, collector, status, amountOfWork);
                visitor.process(openProjects);
                Object var14_15 = null;
                monitor.done();
                try {
                    collector.done();
                }
                catch (CoreException ex2) {
                    status.add(ex2.getStatus());
                }
                break block11;
                {
                    catch (CoreException ex) {
                        status.add(ex.getStatus());
                        Object var14_16 = null;
                        monitor.done();
                        try {
                            collector.done();
                        }
                        catch (CoreException ex2) {
                            status.add(ex2.getStatus());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    monitor.done();
                    try {
                        collector.done();
                    }
                    catch (CoreException ex2) {
                        status.add(ex2.getStatus());
                    }
                    throw throwable;
                }
            }
        }
        return status;
    }
}

