/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginLibrary
extends PluginObject
implements IPluginLibrary {
    private String[] contentFilters;
    private String[] packages;
    private boolean exported = false;
    private String type;
    private static final int GROUP_COUNT = Integer.MAX_VALUE;

    public boolean isValid() {
        return this.name != null;
    }

    public String[] getContentFilters() {
        return this.contentFilters;
    }

    public void addContentFilter(String filter) throws CoreException {
    }

    public void removeContentFilter(String filter) throws CoreException {
    }

    public String[] getPackages() {
        return this.packages;
    }

    public boolean isExported() {
        return this.exported;
    }

    public boolean isFullyExported() {
        return this.exported && (this.contentFilters == null || this.contentFilters.length == 0);
    }

    public String getType() {
        return this.type;
    }

    public void load(String name) {
        this.name = name;
        this.exported = true;
    }

    void load(Node node, Hashtable lineTable) {
        this.name = this.getNodeAttribute(node, "name");
        this.type = this.getNodeAttribute(node, "type");
        NodeList children = node.getChildNodes();
        Vector<String> exports = new Vector<String>();
        Vector<String> prefixes = new Vector<String>();
        boolean all = false;
        for (int i = 0; i < children.getLength(); ++i) {
            String ename;
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String tag = child.getNodeName().toLowerCase();
            if (tag.equals("export")) {
                ename = this.getNodeAttribute(child, "name");
                if (ename == null) continue;
                if ((ename = ename.trim()).equals("*")) {
                    all = true;
                    continue;
                }
                exports.add(ename);
                continue;
            }
            if (!tag.equals("packages") || (ename = this.getNodeAttribute(child, "prefixes")) == null) continue;
            ename = ename.trim();
            StringTokenizer stok = new StringTokenizer(ename, ",");
            while (stok.hasMoreTokens()) {
                prefixes.add(stok.nextToken());
            }
        }
        if (exports.size() > 0) {
            this.contentFilters = new String[exports.size()];
            exports.copyInto(this.contentFilters);
        }
        if (prefixes.size() > 0) {
            this.packages = new String[prefixes.size()];
            prefixes.copyInto(this.packages);
        }
        this.exported = all || exports.size() > 0;
        this.bindSourceLocation(node, lineTable);
    }

    public void setContentFilters(String[] filters) throws CoreException {
        this.ensureModelEditable();
        ArrayList oldValue = this.createArrayList(this.contentFilters);
        this.contentFilters = filters;
        this.firePropertyChanged("contentFilters", oldValue, this.createArrayList(filters));
    }

    public void setPackages(String[] packages) throws CoreException {
        this.ensureModelEditable();
        ArrayList oldValue = this.createArrayList(this.packages);
        this.packages = packages;
        this.firePropertyChanged("packages", oldValue, this.createArrayList(packages));
    }

    public void setExported(boolean value) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = new Boolean(this.exported);
        this.exported = value;
        this.firePropertyChanged("export", oldValue, new Boolean(value));
    }

    public void setType(String type) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.type;
        this.type = type;
        this.firePropertyChanged("type", oldValue, type);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("contentFilters")) {
            ArrayList list = (ArrayList)newValue;
            if (list != null) {
                this.setContentFilters(list.toArray(new String[list.size()]));
            } else {
                this.setContentFilters(null);
            }
            return;
        }
        if (name.equals("packages")) {
            ArrayList list = (ArrayList)newValue;
            if (list != null) {
                this.setPackages(list.toArray(new String[list.size()]));
            } else {
                this.setPackages(null);
            }
            return;
        }
        if (name.equals("export")) {
            this.setExported((Boolean)newValue);
            return;
        }
        if (name.equals("type")) {
            this.setType(newValue != null ? newValue.toString() : null);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    private ArrayList createArrayList(String[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            list.add(array[i]);
        }
        return list;
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.print("<library name=\"" + this.getName() + "\"");
        if (this.type != null) {
            writer.print(" type=\"" + this.type + "\"");
        }
        if (!this.isExported() && this.packages == null) {
            writer.println("/>");
        } else {
            writer.println(">");
            String indent2 = indent + "   ";
            if (this.isExported()) {
                if (this.isFullyExported()) {
                    writer.println(indent2 + "<export name=\"*\"/>");
                } else {
                    for (int i = 0; i < this.contentFilters.length; ++i) {
                        writer.println(indent2 + "<export name=\"" + this.contentFilters[i] + "\"/>");
                    }
                }
            }
            if (this.packages != null) {
                ArrayList groups = this.computePackageGroups(this.packages);
                for (int i = 0; i < groups.size(); ++i) {
                    writer.println(indent2 + "<packages prefixes=\"" + (String)groups.get(i) + "\"/>");
                }
            }
            writer.println(indent + "</library>");
        }
    }

    private ArrayList computePackageGroups(String[] packages) {
        StringBuffer buff = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int counter = 0;
        for (int i = 0; i < packages.length; ++i) {
            if (++counter > 1) {
                buff.append(",");
            }
            buff.append(packages[i]);
            if (counter != Integer.MAX_VALUE) continue;
            counter = 0;
            list.add(buff.toString());
            buff.delete(0, buff.length());
        }
        if (counter > 0) {
            list.add(buff.toString());
        }
        return list;
    }
}

