/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.debug.ui.console.IConsoleLineTrackerExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.ListenerList;

public class ConsoleLineNotifier {
    private int fLinesProcessed = 0;
    private boolean fClosed = false;
    private ListenerList fListeners = new ListenerList(2);
    private IConsole fConsole = null;

    public void connect(IConsole console) {
        this.fConsole = console;
        Object[] listeners = this.fListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            IConsoleLineTracker listener = (IConsoleLineTracker)listeners[i];
            listener.init(console);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ConsoleLineNotifier consoleLineNotifier = this;
        synchronized (consoleLineNotifier) {
            Object[] listeners = this.fListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                IConsoleLineTracker listener = (IConsoleLineTracker)listeners[i];
                listener.dispose();
            }
            this.fListeners = null;
            this.fConsole = null;
        }
    }

    public void consoleChanged(DocumentEvent event) {
        this.processNewLines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamsClosed() {
        ConsoleLineNotifier consoleLineNotifier = this;
        synchronized (consoleLineNotifier) {
            if (this.fConsole == null) {
                return;
            }
            this.fClosed = true;
            this.processNewLines();
            Object[] listeners = this.fListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                Object obj = listeners[i];
                if (!(obj instanceof IConsoleLineTrackerExtension)) continue;
                ((IConsoleLineTrackerExtension)obj).consoleClosed();
            }
        }
    }

    protected synchronized void processNewLines() {
        IDocument document = this.fConsole.getDocument();
        int lines = document.getNumberOfLines();
        Object[] listeners = this.fListeners.getListeners();
        for (int line = this.fLinesProcessed; line < lines; ++line) {
            String delimiter = null;
            try {
                delimiter = document.getLineDelimiter(line);
            }
            catch (BadLocationException e) {
                DebugUIPlugin.log(e);
                return;
            }
            if (delimiter == null && !this.fClosed) {
                return;
            }
            ++this.fLinesProcessed;
            IRegion lineRegion = null;
            try {
                lineRegion = document.getLineInformation(line);
            }
            catch (BadLocationException e) {
                DebugUIPlugin.log(e);
                return;
            }
            for (int i = 0; i < listeners.length; ++i) {
                IConsoleLineTracker listener = (IConsoleLineTracker)listeners[i];
                listener.lineAppended(lineRegion);
            }
        }
    }

    public void addConsoleListener(IConsoleLineTracker listener) {
        this.fListeners.add((Object)listener);
    }

    protected void setLinesProcessed(int linesProcessed) {
        this.fLinesProcessed = linesProcessed;
    }

    protected int getLinesProcessed() {
        return this.fLinesProcessed;
    }
}

