/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class ReorgUtils {
    private static final ISourceRange fgUnknownRange = new SourceRange(-1, 0);

    private ReorgUtils() {
    }

    public static boolean containsOnlyProjects(List elements) {
        if (elements.isEmpty()) {
            return false;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (ReorgUtils.isProject(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProject(Object element) {
        return element instanceof IJavaProject || element instanceof IProject;
    }

    public static boolean isInsideCompilationUnit(IJavaElement element) {
        return !(element instanceof ICompilationUnit) && ReorgUtils.hasAncestorOfType(element, 5);
    }

    public static boolean isInsideClassFile(IJavaElement element) {
        return !(element instanceof IClassFile) && ReorgUtils.hasAncestorOfType(element, 6);
    }

    public static boolean hasAncestorOfType(IJavaElement element, int type) {
        return element.getAncestor(type) != null;
    }

    public static ICompilationUnit getCompilationUnit(IJavaElement javaElement) {
        if (javaElement instanceof ICompilationUnit) {
            return (ICompilationUnit)javaElement;
        }
        return (ICompilationUnit)javaElement.getAncestor(5);
    }

    public static ICompilationUnit[] getCompilationUnits(IJavaElement[] javaElements) {
        ICompilationUnit[] result = new ICompilationUnit[javaElements.length];
        for (int i = 0; i < javaElements.length; ++i) {
            result[i] = ReorgUtils.getCompilationUnit(javaElements[i]);
        }
        return result;
    }

    public static IResource getResource(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return JavaModelUtil.toOriginal((ICompilationUnit)element).getResource();
        }
        return element.getResource();
    }

    public static IResource[] getResources(IJavaElement[] elements) {
        IResource[] result = new IResource[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            result[i] = ReorgUtils.getResource(elements[i]);
        }
        return result;
    }

    public static String getName(IResource resource) {
        String pattern = ReorgUtils.createNamePattern(resource);
        Object[] args = ReorgUtils.createNameArguments(resource);
        return MessageFormat.format(pattern, args);
    }

    private static String createNamePattern(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return RefactoringCoreMessages.getString("ReorgUtils.0");
            }
            case 2: {
                return RefactoringCoreMessages.getString("ReorgUtils.1");
            }
            case 4: {
                return RefactoringCoreMessages.getString("ReorgUtils.2");
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private static String[] createNameArguments(IResource resource) {
        return new String[]{resource.getName()};
    }

    public static String getName(IJavaElement element) throws JavaModelException {
        String pattern = ReorgUtils.createNamePattern(element);
        Object[] args = ReorgUtils.createNameArguments(element);
        return MessageFormat.format(pattern, args);
    }

    private static String[] createNameArguments(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 6: {
                return new String[]{element.getElementName()};
            }
            case 5: {
                return new String[]{element.getElementName()};
            }
            case 8: {
                return new String[]{element.getElementName()};
            }
            case 12: {
                return new String[0];
            }
            case 13: {
                return new String[]{element.getElementName()};
            }
            case 10: {
                return new String[0];
            }
            case 2: {
                return new String[]{element.getElementName()};
            }
            case 9: {
                return new String[]{element.getElementName()};
            }
            case 11: {
                if (JavaElementUtil.isDefaultPackage(element)) {
                    return new String[0];
                }
                return new String[]{element.getElementName()};
            }
            case 4: {
                return new String[]{element.getElementName()};
            }
            case 3: {
                return new String[]{element.getElementName()};
            }
            case 7: {
                IType type = (IType)element;
                String name = type.getElementName();
                if (name.length() == 0 && type.isAnonymous()) {
                    String superclassName = Signature.getSimpleName((String)type.getSuperclassName());
                    return new String[]{RefactoringCoreMessages.getFormattedString("ReorgUtils.19", superclassName)};
                }
                return new String[]{element.getElementName()};
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private static String createNamePattern(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 6: {
                return RefactoringCoreMessages.getString("ReorgUtils.3");
            }
            case 5: {
                return RefactoringCoreMessages.getString("ReorgUtils.4");
            }
            case 8: {
                return RefactoringCoreMessages.getString("ReorgUtils.5");
            }
            case 12: {
                return RefactoringCoreMessages.getString("ReorgUtils.6");
            }
            case 13: {
                return RefactoringCoreMessages.getString("ReorgUtils.7");
            }
            case 10: {
                return RefactoringCoreMessages.getString("ReorgUtils.8");
            }
            case 2: {
                return RefactoringCoreMessages.getString("ReorgUtils.9");
            }
            case 9: {
                if (((IMethod)element).isConstructor()) {
                    return RefactoringCoreMessages.getString("ReorgUtils.10");
                }
                return RefactoringCoreMessages.getString("ReorgUtils.11");
            }
            case 11: {
                return RefactoringCoreMessages.getString("ReorgUtils.12");
            }
            case 4: {
                if (JavaElementUtil.isDefaultPackage(element)) {
                    return RefactoringCoreMessages.getString("ReorgUtils.13");
                }
                return RefactoringCoreMessages.getString("ReorgUtils.14");
            }
            case 3: {
                if (ReorgUtils.isSourceFolder(element)) {
                    return RefactoringCoreMessages.getString("ReorgUtils.15");
                }
                if (ReorgUtils.isClassFolder(element)) {
                    return RefactoringCoreMessages.getString("ReorgUtils.16");
                }
                return RefactoringCoreMessages.getString("ReorgUtils.17");
            }
            case 7: {
                IType type = (IType)element;
                if (type.getElementName().length() == 0 && type.isAnonymous()) {
                    return RefactoringCoreMessages.getString("ReorgUtils.20");
                }
                return RefactoringCoreMessages.getString("ReorgUtils.18");
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public static IJavaElement toWorkingCopy(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return JavaModelUtil.toWorkingCopy((ICompilationUnit)element);
        }
        if (element instanceof IMember) {
            return JavaModelUtil.toWorkingCopy((IMember)element);
        }
        if (element instanceof IPackageDeclaration) {
            return JavaModelUtil.toWorkingCopy((IPackageDeclaration)element);
        }
        if (element instanceof IImportContainer) {
            return JavaModelUtil.toWorkingCopy((IImportContainer)element);
        }
        if (element instanceof IImportDeclaration) {
            return JavaModelUtil.toWorkingCopy((IImportDeclaration)element);
        }
        return element;
    }

    public static IJavaElement[] toWorkingCopies(IJavaElement[] javaElements) {
        IJavaElement[] result = new IJavaElement[javaElements.length];
        for (int i = 0; i < javaElements.length; ++i) {
            result[i] = ReorgUtils.toWorkingCopy(javaElements[i]);
        }
        return result;
    }

    public static IResource[] getResources(List elements) {
        ArrayList resources = new ArrayList(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IResource)) continue;
            resources.add(element);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IJavaElement[] getJavaElements(List elements) {
        ArrayList resources = new ArrayList(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IJavaElement)) continue;
            resources.add(element);
        }
        return resources.toArray(new IJavaElement[resources.size()]);
    }

    public static boolean isDeletedFromEditor(IJavaElement elem) throws JavaModelException {
        if (!ReorgUtils.isInsideCompilationUnit(elem)) {
            return false;
        }
        if (elem instanceof IMember && ((IMember)elem).isBinary()) {
            return false;
        }
        ICompilationUnit cu = ReorgUtils.getCompilationUnit(elem);
        if (cu == null) {
            return false;
        }
        ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
        if (cu.equals(wc)) {
            return false;
        }
        IJavaElement wcElement = JavaModelUtil.findInCompilationUnit(wc, elem);
        return wcElement == null || !wcElement.exists();
    }

    public static boolean hasSourceAvailable(IMember member) throws JavaModelException {
        return !member.isBinary() || member.getSourceRange() != null && !fgUnknownRange.equals(member.getSourceRange());
    }

    public static IResource[] setMinus(IResource[] setToRemoveFrom, IResource[] elementsToRemove) {
        HashSet<IResource> setMinus = new HashSet<IResource>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IResource[setMinus.size()]);
    }

    public static IJavaElement[] setMinus(IJavaElement[] setToRemoveFrom, IJavaElement[] elementsToRemove) {
        HashSet<IJavaElement> setMinus = new HashSet<IJavaElement>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IJavaElement[setMinus.size()]);
    }

    public static IJavaElement[] union(IJavaElement[] set1, IJavaElement[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(set1, union);
        ReorgUtils.addAll(set2, union);
        return union.toArray(new IJavaElement[union.size()]);
    }

    public static IResource[] union(IResource[] set1, IResource[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set1), union);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set2), union);
        return union.toArray(new IResource[union.size()]);
    }

    private static void addAll(Object[] array, List list) {
        for (int i = 0; i < array.length; ++i) {
            if (list.contains(array[i])) continue;
            list.add(array[i]);
        }
    }

    public static Set union(Set set1, Set set2) {
        HashSet union = new HashSet(set1.size() + set2.size());
        union.addAll(set1);
        union.addAll(set2);
        return union;
    }

    public static IType[] getMainTypes(IJavaElement[] javaElements) throws JavaModelException {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>();
        for (int i = 0; i < javaElements.length; ++i) {
            IJavaElement element = javaElements[i];
            if (!(element instanceof IType) || !JavaElementUtil.isMainType((IType)element)) continue;
            result.add(element);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IFolder[] getFolders(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 2);
        return result.toArray(new IFolder[result.size()]);
    }

    public static IFile[] getFiles(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 1);
        return result.toArray(new IFile[result.size()]);
    }

    public static Set getResourcesOfType(IResource[] resources, int typeMask) {
        HashSet<IResource> result = new HashSet<IResource>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            if (!ReorgUtils.isOfType(resources[i], typeMask)) continue;
            result.add(resources[i]);
        }
        return result;
    }

    public static List getElementsOfType(IJavaElement[] javaElements, int type) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(javaElements.length);
        for (int i = 0; i < javaElements.length; ++i) {
            if (!ReorgUtils.isOfType(javaElements[i], type)) continue;
            result.add(javaElements[i]);
        }
        return result;
    }

    public static boolean hasElementsNotOfType(IResource[] resources, int typeMask) {
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (resource == null || ReorgUtils.isOfType(resource, typeMask)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IJavaElement[] javaElements, int type) {
        for (int i = 0; i < javaElements.length; ++i) {
            IJavaElement element = javaElements[i];
            if (element == null || ReorgUtils.isOfType(element, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElementsOfType(IJavaElement[] javaElements, int type) {
        for (int i = 0; i < javaElements.length; ++i) {
            IJavaElement element = javaElements[i];
            if (element == null || !ReorgUtils.isOfType(element, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElementsOfType(IJavaElement[] javaElements, int[] types) {
        for (int i = 0; i < types.length; ++i) {
            if (!ReorgUtils.hasElementsOfType(javaElements, types[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasElementsOfType(IResource[] resources, int typeMask) {
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (resource == null || !ReorgUtils.isOfType(resource, typeMask)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOfType(IJavaElement element, int type) {
        return element.getElementType() == type;
    }

    private static boolean isOfType(IResource resource, int type) {
        return resource != null && ReorgUtils.isFlagSet(resource.getType(), type);
    }

    private static boolean isFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static boolean isSourceFolder(IJavaElement javaElement) throws JavaModelException {
        return javaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)javaElement).getKind() == 1;
    }

    public static boolean isClassFolder(IJavaElement javaElement) throws JavaModelException {
        return javaElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)javaElement).getKind() == 2;
    }

    public static boolean isPackageFragmentRoot(IJavaProject javaProject) throws JavaModelException {
        return ReorgUtils.getCorrespondingPackageFragmentRoot(javaProject) != null;
    }

    private static boolean isPackageFragmentRootCorrespondingToProject(IPackageFragmentRoot root) throws JavaModelException {
        return root.getResource() instanceof IProject;
    }

    public static IPackageFragmentRoot getCorrespondingPackageFragmentRoot(IJavaProject p) throws JavaModelException {
        IPackageFragmentRoot[] roots = p.getPackageFragmentRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (!ReorgUtils.isPackageFragmentRootCorrespondingToProject(roots[i])) continue;
            return roots[i];
        }
        return null;
    }

    public static boolean containsLinkedResources(IResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null || !resources[i].isLinked()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsLinkedResources(IJavaElement[] javaElements) {
        for (int i = 0; i < javaElements.length; ++i) {
            IResource res = ReorgUtils.getResource(javaElements[i]);
            if (res == null || !res.isLinked()) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeDestinationForLinkedResources(IResource resource) {
        return resource.isAccessible() && resource instanceof IProject;
    }

    public static boolean canBeDestinationForLinkedResources(IJavaElement javaElement) throws JavaModelException {
        if (javaElement instanceof IPackageFragmentRoot) {
            return ReorgUtils.isPackageFragmentRootCorrespondingToProject((IPackageFragmentRoot)javaElement);
        }
        return javaElement instanceof IJavaProject;
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragment pack, IPackageFragmentRoot root) {
        if (pack == null) {
            return false;
        }
        IJavaElement packParent = pack.getParent();
        if (packParent == null) {
            return false;
        }
        if (packParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource(pack);
        IResource packageRootResource = ResourceUtil.getResource(root);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IPackageFragmentRoot root, IJavaProject javaProject) {
        if (root == null) {
            return false;
        }
        IJavaElement rootParent = root.getParent();
        if (rootParent == null) {
            return false;
        }
        if (rootParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource(root);
        IResource packageRootResource = ResourceUtil.getResource(javaProject);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(packageResource, packageRootResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(ICompilationUnit cu, IPackageFragment dest) {
        if (cu == null) {
            return false;
        }
        IJavaElement cuParent = cu.getParent();
        if (cuParent == null) {
            return false;
        }
        if (cuParent.equals(dest)) {
            return true;
        }
        IResource cuResource = ResourceUtil.getResource(cu);
        IResource packageResource = ResourceUtil.getResource(dest);
        return ReorgUtils.isParentInWorkspaceOrOnDisk(cuResource, packageResource);
    }

    public static boolean isParentInWorkspaceOrOnDisk(IResource res, IResource maybeParent) {
        if (res == null) {
            return false;
        }
        return ReorgUtils.areEqualInWorkspaceOrOnDisk((IResource)res.getParent(), maybeParent);
    }

    public static boolean areEqualInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals(r2)) {
            return true;
        }
        IPath r1Location = r1.getLocation();
        IPath r2Location = r2.getLocation();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals(r2Location);
    }

    public static boolean equalInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals(r2)) {
            return true;
        }
        IPath r1Location = r1.getLocation();
        IPath r2Location = r2.getLocation();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals(r2Location);
    }

    public static IResource[] getNotNulls(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (resource == null || result.contains(resource)) continue;
            result.add(resource);
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IResource[] getNotLinked(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (resource == null || result.contains(resource) || resource.isLinked()) continue;
            result.add(resource);
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static Map groupByCompilationUnit(List javaElements) {
        HashMap result = new HashMap();
        Iterator iter = javaElements.iterator();
        while (iter.hasNext()) {
            IJavaElement element = (IJavaElement)iter.next();
            ICompilationUnit cu = ReorgUtils.getCompilationUnit(element);
            if (cu == null) continue;
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(element);
        }
        return result;
    }
}

