/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.IMarkerSetElement;

public class MarkerSet
implements Cloneable {
    protected static final int MINIMUM_SIZE = 5;
    protected int elementCount = 0;
    protected IMarkerSetElement[] elements;

    public MarkerSet() {
        this(5);
    }

    public MarkerSet(int capacity) {
        this.elements = new IMarkerSetElement[Math.max(5, capacity * 2)];
    }

    public void add(IMarkerSetElement element) {
        int hash;
        int i;
        if (element == null) {
            return;
        }
        for (i = hash = this.hashFor(element.getId()) % this.elements.length; i < this.elements.length; ++i) {
            if (this.elements[i] != null) continue;
            this.elements[i] = element;
            ++this.elementCount;
            if (this.shouldGrow()) {
                this.expand();
            }
            return;
        }
        for (i = 0; i < hash - 1; ++i) {
            if (this.elements[i] != null) continue;
            this.elements[i] = element;
            ++this.elementCount;
            if (this.shouldGrow()) {
                this.expand();
            }
            return;
        }
        this.expand();
        this.add(element);
    }

    public void addAll(IMarkerSetElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            this.add(elements[i]);
        }
    }

    protected Object clone() {
        try {
            MarkerSet copy = (MarkerSet)super.clone();
            copy.elements = (IMarkerSetElement[])this.elements.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean contains(long id) {
        return this.get(id) != null;
    }

    public IMarkerSetElement[] elements() {
        IMarkerSetElement[] result = new IMarkerSetElement[this.elementCount];
        int j = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            IMarkerSetElement element = this.elements[i];
            if (element == null) continue;
            result[j++] = element;
        }
        return result;
    }

    protected void expand() {
        IMarkerSetElement[] array = new IMarkerSetElement[this.elements.length * 2];
        int maxArrayIndex = array.length - 1;
        for (int i = 0; i < this.elements.length; ++i) {
            IMarkerSetElement element = this.elements[i];
            if (element == null) continue;
            int hash = this.hashFor(element.getId()) % array.length;
            while (array[hash] != null) {
                if (++hash <= maxArrayIndex) continue;
                hash = 0;
            }
            array[hash] = element;
        }
        this.elements = array;
    }

    public IMarkerSetElement get(long id) {
        IMarkerSetElement element;
        int hash;
        int i;
        if (this.elementCount == 0) {
            return null;
        }
        for (i = hash = this.hashFor(id) % this.elements.length; i < this.elements.length; ++i) {
            element = this.elements[i];
            if (element == null) {
                return null;
            }
            if (element.getId() != id) continue;
            return element;
        }
        for (i = 0; i < hash - 1; ++i) {
            element = this.elements[i];
            if (element == null) {
                return null;
            }
            if (element.getId() != id) continue;
            return element;
        }
        return null;
    }

    private int hashFor(long id) {
        return Math.abs((int)id);
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    protected void rehashTo(int anIndex) {
        int target = anIndex;
        int index = anIndex + 1;
        if (index >= this.elements.length) {
            index = 0;
        }
        IMarkerSetElement element = this.elements[index];
        while (element != null) {
            boolean match;
            int hashIndex = this.hashFor(element.getId()) % this.elements.length;
            if (index < target) {
                match = hashIndex <= target && hashIndex > index;
            } else {
                boolean bl = match = hashIndex <= target || hashIndex > index;
            }
            if (match) {
                this.elements[target] = element;
                target = index;
            }
            if (++index >= this.elements.length) {
                index = 0;
            }
            element = this.elements[index];
        }
        this.elements[target] = null;
    }

    public void remove(long id) {
        IMarkerSetElement element;
        int hash;
        int i;
        for (i = hash = this.hashFor(id) % this.elements.length; i < this.elements.length; ++i) {
            element = this.elements[i];
            if (element == null) {
                return;
            }
            if (element.getId() != id) continue;
            this.rehashTo(i);
            --this.elementCount;
        }
        for (i = 0; i < hash - 1; ++i) {
            element = this.elements[i];
            if (element == null) {
                return;
            }
            if (element.getId() != id) continue;
            this.rehashTo(i);
            --this.elementCount;
        }
    }

    public void remove(IMarkerSetElement element) {
        this.remove(element.getId());
    }

    public void removeAll(IMarkerSetElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            this.remove(elements[i]);
        }
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }
}

