/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class WorkManager
implements IManager {
    private NotifyRule notifyRule = new NotifyRule();
    private final ThreadLocal checkInFailed = new ThreadLocal();
    private boolean hasBuildChanges = false;
    private IJobManager jobManager;
    private final ILock lock;
    private int nestedOperations = 0;
    private boolean operationCanceled = false;
    private int preparedOperations = 0;
    private Workspace workspace;
    static /* synthetic */ Class class$org$eclipse$core$internal$resources$WorkManager$NotifyRule;

    public WorkManager(Workspace workspace) {
        this.workspace = workspace;
        this.jobManager = Platform.getJobManager();
        this.lock = this.jobManager.newLock();
    }

    public int beginUnprotected() {
        int depth = this.lock.getDepth();
        for (int i = 0; i < depth; ++i) {
            this.lock.release();
        }
        return depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIn(ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        boolean success = false;
        try {
            if (this.workspace.isTreeLocked()) {
                String msg = Policy.bind("resources.cannotModify");
                throw new ResourceException(380, null, msg, null);
            }
            this.jobManager.beginRule(rule, monitor);
            this.lock.acquire();
            this.incrementPreparedOperations();
            success = true;
        }
        finally {
            if (!success) {
                this.checkInFailed.set(Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkOut(ISchedulingRule rule) {
        this.decrementPreparedOperations();
        this.rebalanceNestedOperations();
        if (this.preparedOperations == 0) {
            this.hasBuildChanges = false;
            this.operationCanceled = false;
        }
        try {
            this.lock.release();
        }
        finally {
            this.jobManager.endRule(rule);
        }
    }

    public boolean checkInFailed(ISchedulingRule rule) {
        if (this.checkInFailed.get() != null) {
            this.checkInFailed.set(null);
            if (!this.workspace.isTreeLocked()) {
                this.jobManager.endRule(rule);
            }
            return true;
        }
        return false;
    }

    private void decrementPreparedOperations() {
        --this.preparedOperations;
    }

    public void endUnprotected(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.lock.acquire();
        }
    }

    ILock getLock() {
        return this.lock;
    }

    public synchronized int getPreparedOperationDepth() {
        return this.preparedOperations;
    }

    void incrementNestedOperations() {
        ++this.nestedOperations;
    }

    private void incrementPreparedOperations() {
        ++this.preparedOperations;
    }

    boolean isBalanced() {
        return this.nestedOperations == this.preparedOperations;
    }

    public void operationCanceled() {
        this.operationCanceled = true;
    }

    public void rebalanceNestedOperations() {
        this.nestedOperations = this.preparedOperations;
    }

    public void setBuild(boolean hasChanges) {
        this.hasBuildChanges = this.hasBuildChanges || hasChanges;
    }

    public boolean shouldBuild() {
        if (this.hasBuildChanges) {
            return !this.operationCanceled;
        }
        return false;
    }

    public void shutdown(IProgressMonitor monitor) {
    }

    public void startup(IProgressMonitor monitor) {
    }

    public boolean isLockAlreadyAcquired() {
        boolean result = false;
        try {
            boolean success = this.lock.acquire(0L);
            if (success) {
                result = this.lock.getDepth() > 1;
                this.lock.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    public ISchedulingRule getNotifyRule() {
        return this.notifyRule;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NotifyRule
    implements ISchedulingRule {
        NotifyRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof IResource || rule.getClass().equals(class$org$eclipse$core$internal$resources$WorkManager$NotifyRule == null ? (class$org$eclipse$core$internal$resources$WorkManager$NotifyRule = WorkManager.class$("org.eclipse.core.internal.resources.WorkManager$NotifyRule")) : class$org$eclipse$core$internal$resources$WorkManager$NotifyRule);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }
}

