/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class MailSessionFactory
implements ObjectFactory {
    protected static final String factoryType = "javax.mail.Session";

    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable env) throws Exception {
        final Reference ref = (Reference)refObj;
        if (!ref.getClassName().equals(factoryType)) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Properties props = new Properties();
                props.put("mail.transport.protocol", "smtp");
                props.put("mail.smtp.host", "localhost");
                Enumeration<RefAddr> attrs = ref.getAll();
                while (attrs.hasMoreElements()) {
                    RefAddr attr = attrs.nextElement();
                    if ("factory".equals(attr.getType())) continue;
                    props.put(attr.getType(), (String)attr.getContent());
                }
                Session session = Session.getInstance((Properties)props, null);
                return session;
            }
        });
    }
}

