/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.IRangeComparator;

public final class DocLineComparator
implements IRangeComparator {
    private final IDocument fDocument;
    private final int fLineOffset;
    private final int fLineCount;
    private final int fLength;
    private final boolean fIgnoreWhiteSpace;
    private final int fMaxOffset;
    private boolean fSkip = false;
    private int fLastOffset;
    private int fLastLength;
    private DocumentCharSequence fThisBuffer = new DocumentCharSequence();
    private DocumentCharSequence fOtherBuffer = new DocumentCharSequence();

    public DocLineComparator(IDocument document, IRegion region, boolean ignoreWhiteSpace) {
        this.fDocument = document;
        this.fIgnoreWhiteSpace = ignoreWhiteSpace;
        if (region != null) {
            this.fLength = region.getLength();
            int start = region.getOffset();
            int lineOffset = 0;
            try {
                lineOffset = this.fDocument.getLineOfOffset(start);
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            this.fLineOffset = lineOffset;
            this.fMaxOffset = start + this.fLength;
            if (this.fLength == 0) {
                this.fLineCount = 0;
            } else {
                int endLine = this.fDocument.getNumberOfLines();
                try {
                    endLine = this.fDocument.getLineOfOffset(start + this.fLength);
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
                this.fLineCount = endLine - this.fLineOffset + 1;
            }
        } else {
            this.fLineOffset = 0;
            this.fLength = document.getLength();
            this.fLineCount = this.fDocument.getNumberOfLines();
            this.fMaxOffset = this.fDocument.getLength();
        }
    }

    public int getRangeCount() {
        return this.fLineCount;
    }

    private int getLineLength(int line) {
        if (line >= this.fLineCount) {
            return 0;
        }
        try {
            int docLine = this.fLineOffset + line;
            String delim = this.fDocument.getLineDelimiter(docLine);
            int length = this.fDocument.getLineLength(docLine) - (delim == null ? 0 : delim.length());
            if (line == this.fLineCount - 1) {
                this.fLastOffset = this.fDocument.getLineOffset(docLine);
                this.fLastLength = Math.min(length, this.fMaxOffset - this.fLastOffset);
            } else {
                this.fLastOffset = -1;
                this.fLastLength = length;
            }
            return this.fLastLength;
        }
        catch (BadLocationException e) {
            this.fLastOffset = 0;
            this.fLastLength = 0;
            this.fSkip = true;
            return 0;
        }
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        if (other != null && other.getClass() == this.getClass()) {
            int olen;
            DocLineComparator dlc = (DocLineComparator)other;
            if (this.fIgnoreWhiteSpace) {
                this.extract(thisIndex, this.fThisBuffer);
                dlc.extract(otherIndex, this.fOtherBuffer);
                return this.compare(this.fThisBuffer, this.fOtherBuffer);
            }
            int tlen = this.getLineLength(thisIndex);
            if (tlen == (olen = dlc.getLineLength(otherIndex))) {
                this.extract(thisIndex, this.fThisBuffer);
                dlc.extract(otherIndex, this.fOtherBuffer);
                return this.fThisBuffer.equals(this.fOtherBuffer);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int max, IRangeComparator other) {
        return this.fSkip;
    }

    private void extract(int line, DocumentCharSequence buffer) {
        if (line < this.fLineCount) {
            try {
                int docLine = this.fLineOffset + line;
                if (this.fLastOffset == -1) {
                    this.fLastOffset = this.fDocument.getLineOffset(docLine);
                }
                buffer.setDocument(this.fDocument);
                buffer.setOffset(this.fLastOffset);
                buffer.setLength(this.fLastLength);
                return;
            }
            catch (BadLocationException e) {
                this.fSkip = true;
            }
        }
        buffer.setDocument(this.fDocument);
        buffer.setOffset(0);
        buffer.setLength(0);
    }

    private boolean compare(CharSequence s1, CharSequence s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        int c1 = 0;
        int c2 = 0;
        int i1 = 0;
        int i2 = 0;
        while (c1 != -1) {
            char c;
            c1 = -1;
            while (i1 < l1) {
                if (Character.isWhitespace(c = s1.charAt(i1++))) continue;
                c1 = c;
                break;
            }
            c2 = -1;
            while (i2 < l2) {
                if (Character.isWhitespace(c = s2.charAt(i2++))) continue;
                c2 = c;
                break;
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static class DocumentCharSequence
    implements CharSequence {
        private IDocument fDocument;
        private int fOffset;
        private int fLength;

        public DocumentCharSequence() {
        }

        public DocumentCharSequence(IDocument document, int offset, int length) {
            this.fDocument = document;
            this.fOffset = offset;
            this.fLength = length;
        }

        public int length() {
            return this.fLength;
        }

        public char charAt(int index) {
            try {
                return this.fDocument.getChar(this.fOffset + index);
            }
            catch (BadLocationException e) {
                throw new IndexOutOfBoundsException();
            }
        }

        public CharSequence subSequence(int start, int end) {
            return new DocumentCharSequence(this.fDocument, start, end - start);
        }

        public int hashCode() {
            int hash = 0;
            int n = this.fLength;
            for (int i = 0; i < n; ++i) {
                hash = 29 * hash + this.charAt(i);
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DocumentCharSequence)) {
                return false;
            }
            DocumentCharSequence buffer = (DocumentCharSequence)obj;
            int length = buffer.length();
            if (length != this.fLength) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (buffer.charAt(i) == this.charAt(i)) continue;
                return false;
            }
            return true;
        }

        public void setDocument(IDocument document) {
            this.fDocument = document;
        }

        public void setOffset(int offset) {
            this.fOffset = offset;
        }

        public void setLength(int length) {
            this.fLength = length;
        }
    }
}

