/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.TextEditorAction;

public class MoveLinesAction
extends TextEditorAction {
    private static final String ILLEGAL_MOVE = "Editor.MoveLines.IllegalMove.status";
    private final boolean fUpwards;
    private final boolean fCopy;
    private final AbstractTextEditor fEditor;
    private final ExitStrategy fExitStrategy = new ExitStrategy();
    private boolean fAddDelimiter;
    private boolean fEditInProgress = false;
    private int fStateMask;
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;
    static /* synthetic */ Class class$org$eclipse$ui$texteditor$IEditorStatusLine;

    public MoveLinesAction(ResourceBundle bundle, String prefix, AbstractTextEditor editor, boolean upwards, boolean copy) {
        super(bundle, prefix, editor);
        this.fEditor = editor;
        this.fUpwards = upwards;
        this.fCopy = copy;
        this.update();
    }

    private void beginCompoundEdit() {
        if (this.fEditInProgress || this.fEditor == null) {
            return;
        }
        this.fEditInProgress = true;
        this.fExitStrategy.install();
        IRewriteTarget target = (IRewriteTarget)this.fEditor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = MoveLinesAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget);
        if (target != null) {
            target.beginCompoundChange();
        }
    }

    private boolean containedByVisibleRegion(ITextSelection selection, ISourceViewer viewer) {
        int min = selection.getOffset();
        int max = min + selection.getLength();
        IDocument document = viewer.getDocument();
        IRegion visible = viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)viewer).getModelCoverage() : viewer.getVisibleRegion();
        int visOffset = visible.getOffset();
        try {
            int visEnd;
            if (visOffset > min) {
                if (document.getLineOfOffset(visOffset) != selection.getStartLine()) {
                    return false;
                }
                if (!this.isWhitespace(document.get(min, visOffset - min))) {
                    this.showStatus();
                    return false;
                }
            }
            if ((visEnd = visOffset + visible.getLength()) < max) {
                if (document.getLineOfOffset(visEnd) != selection.getEndLine()) {
                    return false;
                }
                if (!this.isWhitespace(document.get(visEnd, max - visEnd))) {
                    this.showStatus();
                    return false;
                }
            }
            return true;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private void endCompoundEdit() {
        if (!this.fEditInProgress || this.fEditor == null) {
            return;
        }
        this.fExitStrategy.uninstall();
        IRewriteTarget target = (IRewriteTarget)this.fEditor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = MoveLinesAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget);
        if (target != null) {
            target.endCompoundChange();
        }
        this.fEditInProgress = false;
    }

    private ITextSelection getMovingSelection(IDocument document, ITextSelection selection, ISourceViewer viewer) throws BadLocationException {
        int low = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int high = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String delim = document.getLineDelimiter(endLine);
        if (delim != null) {
            high -= delim.length();
        }
        this.fAddDelimiter = delim != null && document.getLineLength(endLine) == delim.length();
        return new TextSelection(document, low, high - low);
    }

    private ITextSelection getSkippedLine(IDocument document, ITextSelection selection) {
        int skippedLineN;
        int n = skippedLineN = this.fUpwards ? selection.getStartLine() - 1 : selection.getEndLine() + 1;
        if (skippedLineN < 0 || skippedLineN >= document.getNumberOfLines()) {
            return null;
        }
        try {
            IRegion line = document.getLineInformation(skippedLineN);
            return new TextSelection(document, line.getOffset(), line.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    public void runWithEvent(Event event) {
        this.updateShortCut(event);
        if (this.fEditor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getSourceViewer();
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText widget = viewer.getTextWidget();
        if (widget == null) {
            return;
        }
        Point p = viewer.getSelectedRange();
        if (p == null) {
            return;
        }
        TextSelection sel = new TextSelection(document, p.x, p.y);
        ITextSelection skippedLine = this.getSkippedLine(document, (ITextSelection)sel);
        if (skippedLine == null) {
            return;
        }
        try {
            int deviation;
            int offset;
            String insertion;
            String delim;
            ITextSelection movingArea = this.getMovingSelection(document, (ITextSelection)sel, viewer);
            if (!this.containedByVisibleRegion(movingArea, viewer) || !this.containedByVisibleRegion(skippedLine, viewer)) {
                return;
            }
            String moving = movingArea.getText();
            String skipped = skippedLine.getText();
            if (moving == null || skipped == null) {
                return;
            }
            if (this.fUpwards) {
                delim = document.getLineDelimiter(skippedLine.getEndLine());
                Assert.isNotNull((Object)delim);
                if (this.fCopy) {
                    insertion = moving + delim;
                    offset = movingArea.getOffset();
                    deviation = 0;
                } else {
                    insertion = moving + delim + skipped;
                    offset = skippedLine.getOffset();
                    deviation = -skippedLine.getLength() - delim.length();
                }
            } else {
                delim = document.getLineDelimiter(movingArea.getEndLine());
                Assert.isNotNull((Object)delim);
                if (this.fCopy) {
                    insertion = moving + delim;
                    offset = skippedLine.getOffset();
                    deviation = movingArea.getLength() + delim.length();
                } else {
                    insertion = skipped + delim + moving;
                    offset = movingArea.getOffset();
                    deviation = skipped.length() + delim.length();
                }
            }
            this.beginCompoundEdit();
            if (this.fCopy) {
                document.replace(offset, 0, insertion);
            } else {
                document.replace(offset, insertion.length(), insertion);
            }
            int selOffset = movingArea.getOffset() + deviation;
            int selLength = movingArea.getLength() + (this.fAddDelimiter ? delim.length() : 0);
            if (!(viewer instanceof ITextViewerExtension5)) {
                selLength = Math.min(selLength, viewer.getVisibleRegion().getOffset() + viewer.getVisibleRegion().getLength() - selOffset);
            }
            this.selectAndReveal((ITextViewer)viewer, selOffset, selLength);
        }
        catch (BadLocationException x) {
            return;
        }
    }

    private void updateShortCut(Event event) {
        this.fStateMask = event.stateMask;
    }

    private void selectAndReveal(ITextViewer viewer, int offset, int length) {
        viewer.setSelectedRange(offset + length, -length);
        StyledText st = viewer.getTextWidget();
        if (st != null) {
            st.showSelection();
        }
    }

    private void showStatus() {
        IEditorStatusLine status = (IEditorStatusLine)this.fEditor.getAdapter(class$org$eclipse$ui$texteditor$IEditorStatusLine == null ? (class$org$eclipse$ui$texteditor$IEditorStatusLine = MoveLinesAction.class$("org.eclipse.ui.texteditor.IEditorStatusLine")) : class$org$eclipse$ui$texteditor$IEditorStatusLine);
        if (status == null) {
            return;
        }
        status.setMessage(false, EditorMessages.getString(ILLEGAL_MOVE), null);
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ExitStrategy
    implements VerifyKeyListener,
    MouseListener,
    FocusListener,
    IDocumentListener {
        private StyledText fWidgetEventSource;
        private IDocument fDocumentEventSource;
        private boolean fIsInstalled;

        private ExitStrategy() {
        }

        public void install() {
            if (this.fIsInstalled) {
                this.uninstall();
            }
            this.fIsInstalled = true;
            ISourceViewer viewer = MoveLinesAction.this.fEditor.getSourceViewer();
            if (viewer == null) {
                return;
            }
            this.fWidgetEventSource = viewer.getTextWidget();
            if (this.fWidgetEventSource == null) {
                return;
            }
            this.fWidgetEventSource.addVerifyKeyListener((VerifyKeyListener)this);
            this.fWidgetEventSource.addMouseListener((MouseListener)this);
            this.fWidgetEventSource.addFocusListener((FocusListener)this);
            this.fDocumentEventSource = viewer.getDocument();
            if (this.fDocumentEventSource != null) {
                this.fDocumentEventSource.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            if (this.fWidgetEventSource != null) {
                this.fWidgetEventSource.removeVerifyKeyListener((VerifyKeyListener)this);
                this.fWidgetEventSource.removeMouseListener((MouseListener)this);
                this.fWidgetEventSource.removeFocusListener((FocusListener)this);
                this.fWidgetEventSource = null;
            }
            if (this.fDocumentEventSource != null) {
                this.fDocumentEventSource.removeDocumentListener((IDocumentListener)this);
                this.fDocumentEventSource = null;
            }
            this.fIsInstalled = false;
        }

        public void verifyKey(VerifyEvent event) {
            if (event.stateMask != MoveLinesAction.this.fStateMask) {
                MoveLinesAction.this.endCompoundEdit();
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            MoveLinesAction.this.endCompoundEdit();
        }

        public void mouseDown(MouseEvent e) {
            MoveLinesAction.this.endCompoundEdit();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusLost(FocusEvent e) {
            MoveLinesAction.this.endCompoundEdit();
        }

        public void focusGained(FocusEvent e) {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
        }
    }
}

