/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.Theme;
import org.eclipse.ui.themes.ITheme;

public final class ThemeElementHelper {
    public static void populateRegistry(ITheme theme, FontDefinition[] definitions, IPreferenceStore store) {
        FontDefinition[] copyOfDefinitions = null;
        if (!theme.getId().equals("org.eclipse.ui.defaultTheme")) {
            definitions = ThemeElementHelper.addDefaulted(definitions);
        }
        copyOfDefinitions = new FontDefinition[definitions.length];
        System.arraycopy(definitions, 0, copyOfDefinitions, 0, definitions.length);
        Arrays.sort(copyOfDefinitions, new IThemeRegistry.HierarchyComparator(definitions));
        for (int i = 0; i < copyOfDefinitions.length; ++i) {
            FontDefinition definition = copyOfDefinitions[i];
            ThemeElementHelper.installFont(definition, theme, store);
        }
    }

    private static FontDefinition[] addDefaulted(FontDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        IHierarchalThemeElementDefinition[] allDefs = registry.getFonts();
        SortedSet set = ThemeElementHelper.addDefaulted(definitions, allDefs);
        return set.toArray(new FontDefinition[set.size()]);
    }

    private static void installFont(FontDefinition definition, ITheme theme, IPreferenceStore store) {
        FontRegistry registry = theme.getFontRegistry();
        String id = definition.getId();
        String key = ThemeElementHelper.createPreferenceKey(theme, id);
        FontData[] prefFont = store != null ? PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)key) : null;
        FontData[] defaultFont = null;
        defaultFont = definition.getValue() != null ? definition.getValue() : (definition.getDefaultsTo() != null ? registry.bestDataArray(registry.getFontData(definition.getDefaultsTo()), Workbench.getInstance().getDisplay()) : registry.bestDataArray(registry.getFontData(key), Workbench.getInstance().getDisplay()));
        if (prefFont == null || prefFont == PreferenceConverter.FONTDATA_ARRAY_DEFAULT_DEFAULT) {
            prefFont = defaultFont;
        }
        if (defaultFont != null && store != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (FontData[])defaultFont);
        }
        if (prefFont != null) {
            registry.put(id, prefFont);
        }
    }

    public static void populateRegistry(ITheme theme, ColorDefinition[] definitions, IPreferenceStore store) {
        ColorDefinition[] copyOfDefinitions = null;
        if (!theme.getId().equals("org.eclipse.ui.defaultTheme")) {
            definitions = ThemeElementHelper.addDefaulted(definitions);
        }
        copyOfDefinitions = new ColorDefinition[definitions.length];
        System.arraycopy(definitions, 0, copyOfDefinitions, 0, definitions.length);
        Arrays.sort(copyOfDefinitions, new IThemeRegistry.HierarchyComparator(definitions));
        for (int i = 0; i < copyOfDefinitions.length; ++i) {
            ColorDefinition definition = copyOfDefinitions[i];
            ThemeElementHelper.installColor(definition, theme, store);
        }
    }

    private static ColorDefinition[] addDefaulted(ColorDefinition[] definitions) {
        IThemeRegistry registry = WorkbenchPlugin.getDefault().getThemeRegistry();
        IHierarchalThemeElementDefinition[] allDefs = registry.getColors();
        SortedSet set = ThemeElementHelper.addDefaulted(definitions, allDefs);
        return set.toArray(new ColorDefinition[set.size()]);
    }

    private static SortedSet addDefaulted(IHierarchalThemeElementDefinition[] definitions, IHierarchalThemeElementDefinition[] allDefs) {
        TreeSet<IHierarchalThemeElementDefinition> set = new TreeSet<IHierarchalThemeElementDefinition>(IThemeRegistry.ID_COMPARATOR);
        set.addAll(Arrays.asList(definitions));
        Arrays.sort(allDefs, new IThemeRegistry.HierarchyComparator(allDefs));
        for (int i = 0; i < allDefs.length; ++i) {
            IHierarchalThemeElementDefinition def = allDefs[i];
            if (def.getDefaultsTo() == null || !set.contains(def.getDefaultsTo())) continue;
            set.add(def);
        }
        return set;
    }

    private static void installColor(ColorDefinition definition, ITheme theme, IPreferenceStore store) {
        ColorRegistry registry = theme.getColorRegistry();
        String id = definition.getId();
        String key = ThemeElementHelper.createPreferenceKey(theme, id);
        RGB prefColor = store != null ? PreferenceConverter.getColor((IPreferenceStore)store, (String)key) : null;
        RGB defaultColor = null;
        defaultColor = definition.getValue() != null ? definition.getValue() : registry.getRGB(definition.getDefaultsTo());
        if (prefColor == null || prefColor == PreferenceConverter.COLOR_DEFAULT_DEFAULT) {
            prefColor = defaultColor;
        }
        if (defaultColor != null && store != null) {
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)defaultColor);
        }
        if (prefColor != null) {
            registry.put(id, prefColor);
        }
    }

    public static String createPreferenceKey(ITheme theme, String id) {
        String themeId = theme.getId();
        if (themeId.equals("org.eclipse.ui.defaultTheme")) {
            return id;
        }
        return themeId + '.' + id;
    }

    public static String[] splitPropertyName(Theme theme, String property) {
        String themeId = theme.getId();
        if (themeId.equals("org.eclipse.ui.defaultTheme")) {
            return new String[]{null, property};
        }
        if (property.startsWith(themeId + '.')) {
            return new String[]{property.substring(0, themeId.length()), property.substring(themeId.length() + 1)};
        }
        return new String[]{null, property};
    }

    private ThemeElementHelper() {
    }
}

