/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMarkerActionFilter;
import org.eclipse.ui.actions.SimpleWildcardTester;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchAdapter;

public class WorkbenchMarker
extends WorkbenchAdapter
implements IMarkerActionFilter {
    public ImageDescriptor getImageDescriptor(Object o) {
        if (!(o instanceof IMarker)) {
            return null;
        }
        return IDEWorkbenchPlugin.getDefault().getMarkerImageProviderRegistry().getImageDescriptor((IMarker)o);
    }

    public String getLabel(Object o) {
        IMarker marker = (IMarker)o;
        return marker.getAttribute("message", "");
    }

    public Object getParent(Object o) {
        return ((IMarker)o).getResource();
    }

    public boolean testAttribute(Object target, String name, String value) {
        IMarker marker = (IMarker)target;
        if (name.equals("type")) {
            try {
                return value.equals(marker.getType());
            }
            catch (CoreException e) {
                return false;
            }
        }
        if (name.equals("superType")) {
            try {
                return marker.isSubtypeOf(value);
            }
            catch (CoreException e) {
                return false;
            }
        }
        if (name.equals("priority")) {
            return this.testIntegerAttribute(marker, "priority", value);
        }
        if (name.equals("severity")) {
            return this.testIntegerAttribute(marker, "severity", value);
        }
        if (name.equals("message")) {
            try {
                String msg = (String)marker.getAttribute("message");
                if (msg == null) {
                    return false;
                }
                return SimpleWildcardTester.testWildcardIgnoreCase((String)value, (String)msg);
            }
            catch (CoreException e) {
                return false;
            }
        }
        if (name.equals("done")) {
            try {
                value = value.toLowerCase();
                Boolean done = (Boolean)marker.getAttribute("done");
                if (done == null) {
                    return false;
                }
                return done.booleanValue() == value.equals("true");
            }
            catch (CoreException e) {
                return false;
            }
        }
        if (name.equals("resourceType")) {
            int desiredType = 0;
            try {
                desiredType = Integer.parseInt(value);
            }
            catch (NumberFormatException eNumberFormat) {
                // empty catch block
            }
            if (desiredType != 1 && desiredType != 2 && desiredType != 4 && desiredType != 8) {
                return false;
            }
            return (marker.getResource().getType() & desiredType) > 0;
        }
        return false;
    }

    private boolean testIntegerAttribute(IMarker marker, String attrName, String value) {
        Integer i2;
        Integer i1;
        try {
            i1 = (Integer)marker.getAttribute(attrName);
            if (i1 == null) {
                return false;
            }
        }
        catch (CoreException e) {
            return false;
        }
        try {
            i2 = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return i1.equals(i2);
    }
}

