/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import jargs.gnu.CmdLineParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.videolan.vlma.daemon.VlData;

public class VLMad {
    private static final Logger logger = Logger.getLogger(VLMad.class);
    static VlData data;

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option springxml = parser.addStringOption("springxml");
        CmdLineParser.Option IPsDevel = parser.addBooleanOption("IPsDevel");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            logger.log(Level.ERROR, "Erreur dans la ligne de commande : " + e.getMessage());
            logger.log(Level.INFO, "Usage: VLMad [{--springxml} daemon.xml]\n");
            System.exit(2);
        }
        String springxmlvalue = (String)parser.getOptionValue(springxml);
        if (springxmlvalue == null) {
            springxmlvalue = "daemon.xml";
        }
        boolean IPsDevelvalue = parser.getOptionValue(IPsDevel) != null;
        logger.log(Level.DEBUG, "D\u00e9but de l'application");
        logger.log(Level.DEBUG, "Chargement de l'application Spring \u00e0 partir du fichier de config XML : " + springxmlvalue);
        ClassPathXmlApplicationContext ac = new ClassPathXmlApplicationContext(springxmlvalue);
        data = (VlData)ac.getBean("dataSource");
        data.initIPs(IPsDevelvalue);
        logger.log(Level.DEBUG, "Lancement du thread de surveillance des serveurs");
        data.startServerMonitoringDaemon();
        logger.log(Level.DEBUG, "Lancement du thread de surveillance de la diffusion");
        data.startOrderMonitoringDaemon();
    }
}

