/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrobin.core.RrdException;
import org.jrobin.graph.ValueFormatter;

class Print {
    private static final String SCALE_MARKER = "@s";
    private static final String UNIFORM_SCALE_MARKER = "@S";
    private static final String VALUE_MARKER = "@([0-9]*\\.[0-9]{1}|[0-9]{1}|\\.[0-9]{1})";
    private static final Pattern VALUE_PATTERN = Pattern.compile("@([0-9]*\\.[0-9]{1}|[0-9]{1}|\\.[0-9]{1})");
    private int numDec = 3;
    private int strLen = -1;
    private boolean normalScale = false;
    private boolean uniformScale = false;
    private ValueFormatter vFormat;

    Print(double d, int n) {
        this.vFormat = new ValueFormatter(d, n);
    }

    String getFormattedString(double d, String string, double d2) throws RrdException {
        this.checkValuePlacement(string);
        double d3 = this.vFormat.getBase();
        this.vFormat.setBase(d2);
        this.vFormat.setFormat(d, this.numDec, this.strLen);
        this.vFormat.setScaling(this.normalScale, this.uniformScale);
        String string2 = this.vFormat.getFormattedValue();
        String string3 = this.vFormat.getPrefix();
        this.vFormat.setBase(d3);
        String string4 = string;
        string4 = string4.replaceAll(VALUE_MARKER, string2);
        if (this.normalScale) {
            string4 = string4.replaceAll(SCALE_MARKER, string3);
        }
        if (this.uniformScale) {
            string4 = string4.replaceAll(UNIFORM_SCALE_MARKER, string3);
        }
        return string4;
    }

    private void checkValuePlacement(String string) throws RrdException {
        Matcher matcher = VALUE_PATTERN.matcher(string);
        if (matcher.find()) {
            this.normalScale = string.indexOf(SCALE_MARKER) >= 0;
            boolean bl = this.uniformScale = string.indexOf(UNIFORM_SCALE_MARKER) >= 0;
            if (this.normalScale && this.uniformScale) {
                throw new RrdException("Can't specify normal scaling and uniform scaling at the same time.");
            }
            String[] stringArray = matcher.group(1).split("\\.");
            this.strLen = -1;
            this.numDec = 0;
            if (stringArray.length > 1) {
                if (stringArray[0].length() > 0) {
                    this.strLen = Integer.parseInt(stringArray[0]);
                    this.numDec = Integer.parseInt(stringArray[1]);
                } else {
                    this.numDec = Integer.parseInt(stringArray[1]);
                }
            } else {
                this.numDec = Integer.parseInt(stringArray[0]);
            }
        } else {
            throw new RrdException("Could not find where to place value. No @ placeholder found.");
        }
    }
}

