/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.jrobin.graph.ExportData;
import org.jrobin.graph.RrdGraphDef;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdGraphDefTemplate
extends XmlTemplate {
    private RrdGraphDef rrdGraphDef;

    public RrdGraphDefTemplate(InputSource inputSource) throws IOException, RrdException {
        super(inputSource);
    }

    public RrdGraphDefTemplate(File file) throws IOException, RrdException {
        super(file);
    }

    public RrdGraphDefTemplate(String string) throws IOException, RrdException {
        super(string);
    }

    public RrdGraphDef getRrdGraphDef() throws RrdException {
        if (!this.root.getTagName().equals("rrd_graph_def")) {
            throw new RrdException("XML definition must start with <rrd_graph_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"span", "options", "datasources", "graph"});
        this.rrdGraphDef = new RrdGraphDef();
        Node[] nodeArray = RrdGraphDefTemplate.getChildNodes(this.root);
        for (int i = 0; i < nodeArray.length; ++i) {
            String string = nodeArray[i].getNodeName();
            if (string.equals("span")) {
                this.resolveSpan(nodeArray[i]);
                continue;
            }
            if (string.equals("options")) {
                this.resolveOptions(nodeArray[i]);
                continue;
            }
            if (string.equals("datasources")) {
                this.resolveDatasources(nodeArray[i]);
                continue;
            }
            if (!string.equals("graph")) continue;
            this.resolveGraphElements(nodeArray[i]);
        }
        return this.rrdGraphDef;
    }

    private void resolveGraphElements(Node node) throws RrdException {
        this.validateTagsOnlyOnce(node, new String[]{"area*", "line*", "stack*", "gprint*", "hrule*", "vrule*", "comment*", "time*"});
        Node[] nodeArray = RrdGraphDefTemplate.getChildNodes(node);
        for (int i = 0; i < nodeArray.length; ++i) {
            int n;
            String string;
            Object object;
            Object object2;
            Object object3;
            String string2;
            String string3 = nodeArray[i].getNodeName();
            if (string3.equals("area")) {
                this.resolveArea(nodeArray[i]);
                continue;
            }
            if (string3.equals("line")) {
                this.resolveLine(nodeArray[i]);
                continue;
            }
            if (string3.equals("stack")) {
                this.validateTagsOnlyOnce(nodeArray[i], new String[]{"datasource", "color", "legend"});
                string2 = this.getChildValue(nodeArray[i], "datasource");
                object3 = this.getChildValue(nodeArray[i], "color");
                object2 = Color.decode((String)object3);
                object = this.getChildValue(nodeArray[i], "legend", false);
                this.rrdGraphDef.stack(string2, (Color)object2, (String)object);
                continue;
            }
            if (string3.equals("comment")) {
                string2 = this.getValue(nodeArray[i], false);
                this.rrdGraphDef.comment(string2);
                continue;
            }
            if (string3.equals("gprint")) {
                this.validateTagsOnlyOnce(nodeArray[i], new String[]{"datasource", "cf", "format", "base"});
                string2 = this.getChildValue(nodeArray[i], "datasource");
                object3 = this.getChildValue(nodeArray[i], "cf");
                object2 = this.getChildValue(nodeArray[i], "format", false);
                if (!this.hasChildNode(nodeArray[i], "base")) {
                    this.rrdGraphDef.gprint(string2, (String)object3, (String)object2);
                    continue;
                }
                this.rrdGraphDef.gprint(string2, (String)object3, (String)object2, this.getChildValueAsDouble(nodeArray[i], "base"));
                continue;
            }
            if (string3.equals("time")) {
                this.validateTagsOnlyOnce(nodeArray[i], new String[]{"format", "pattern", "value"});
                string2 = this.getChildValue(nodeArray[i], "format", false);
                object3 = this.getChildValue(nodeArray[i], "pattern");
                if (Util.Xml.hasChildNode(nodeArray[i], "value")) {
                    object2 = this.getChildValue(nodeArray[i], "value");
                    this.rrdGraphDef.time(string2, (String)object3, (Calendar)Util.getGregorianCalendar((String)object2));
                    continue;
                }
                this.rrdGraphDef.time(string2, (String)object3);
                continue;
            }
            if (string3.equals("hrule")) {
                this.validateTagsOnlyOnce(nodeArray[i], new String[]{"value", "color", "legend", "width"});
                double d = this.getChildValueAsDouble(nodeArray[i], "value");
                object2 = this.getChildValue(nodeArray[i], "color");
                object = Color.decode((String)object2);
                string = this.getChildValue(nodeArray[i], "legend", false);
                n = 1;
                try {
                    n = this.getChildValueAsInt(nodeArray[i], "width");
                }
                catch (RrdException rrdException) {
                    // empty catch block
                }
                this.rrdGraphDef.hrule(d, (Color)object, string, n);
                continue;
            }
            if (!string3.equals("vrule")) continue;
            this.validateTagsOnlyOnce(nodeArray[i], new String[]{"time", "color", "legend", "width"});
            string2 = this.getChildValue(nodeArray[i], "time");
            object3 = Util.getGregorianCalendar(string2);
            object2 = this.getChildValue(nodeArray[i], "color");
            object = Color.decode((String)object2);
            string = this.getChildValue(nodeArray[i], "legend", false);
            n = 1;
            try {
                n = this.getChildValueAsInt(nodeArray[i], "width");
            }
            catch (RrdException rrdException) {
                // empty catch block
            }
            this.rrdGraphDef.vrule((GregorianCalendar)object3, (Color)object, string, n);
        }
    }

    private void resolveLine(Node node) throws RrdException {
        if (this.hasChildNode(node, "datasource")) {
            this.validateTagsOnlyOnce(node, new String[]{"datasource", "color", "legend", "width"});
            String string = this.getChildValue(node, "datasource");
            String string2 = this.getChildValue(node, "color");
            Color color = Color.decode(string2);
            String string3 = this.getChildValue(node, "legend", false);
            int n = 1;
            try {
                n = this.getChildValueAsInt(node, "width");
            }
            catch (RrdException rrdException) {
                // empty catch block
            }
            this.rrdGraphDef.line(string, color, string3, n);
        } else if (this.hasChildNode(node, "time1")) {
            this.validateTagsOnlyOnce(node, new String[]{"time1", "time2", "value1", "value2", "color", "legend", "width"});
            String string = this.getChildValue(node, "time1");
            GregorianCalendar gregorianCalendar = Util.getGregorianCalendar(string);
            String string4 = this.getChildValue(node, "time2");
            GregorianCalendar gregorianCalendar2 = Util.getGregorianCalendar(string4);
            double d = this.getChildValueAsDouble(node, "value1");
            double d2 = this.getChildValueAsDouble(node, "value2");
            String string5 = this.getChildValue(node, "color");
            Color color = Color.decode(string5);
            String string6 = this.getChildValue(node, "legend", false);
            int n = 1;
            try {
                n = this.getChildValueAsInt(node, "width");
            }
            catch (RrdException rrdException) {
                // empty catch block
            }
            this.rrdGraphDef.line(gregorianCalendar, d, gregorianCalendar2, d2, color, string6, n);
        } else {
            throw new RrdException("Unrecognized <line> format");
        }
    }

    private void resolveArea(Node node) throws RrdException {
        if (this.hasChildNode(node, "datasource")) {
            this.validateTagsOnlyOnce(node, new String[]{"datasource", "color", "legend"});
            String string = this.getChildValue(node, "datasource");
            String string2 = this.getChildValue(node, "color");
            Color color = Color.decode(string2);
            String string3 = this.getChildValue(node, "legend", false);
            this.rrdGraphDef.area(string, color, string3);
        } else if (this.hasChildNode(node, "time1")) {
            this.validateTagsOnlyOnce(node, new String[]{"time1", "time2", "value1", "value2", "color", "legend", "width"});
            String string = this.getChildValue(node, "time1");
            GregorianCalendar gregorianCalendar = Util.getGregorianCalendar(string);
            String string4 = this.getChildValue(node, "time2");
            GregorianCalendar gregorianCalendar2 = Util.getGregorianCalendar(string4);
            double d = this.getChildValueAsDouble(node, "value1");
            double d2 = this.getChildValueAsDouble(node, "value2");
            String string5 = this.getChildValue(node, "color");
            Color color = Color.decode(string5);
            String string6 = this.getChildValue(node, "legend", false);
            this.rrdGraphDef.area(gregorianCalendar, d, gregorianCalendar2, d2, color, string6);
        } else {
            throw new RrdException("Unrecognized <area> format");
        }
    }

    private void resolveDatasources(Node node) throws RrdException {
        String string;
        String string2;
        int n;
        this.validateTagsOnlyOnce(node, new String[]{"def*", "export_data*"});
        Node[] nodeArray = RrdGraphDefTemplate.getChildNodes(node, "def");
        for (n = 0; n < nodeArray.length; ++n) {
            String string3;
            if (this.hasChildNode(nodeArray[n], "rrd")) {
                this.validateTagsOnlyOnce(nodeArray[n], new String[]{"name", "rrd", "source", "cf", "backend"});
                string2 = this.getChildValue(nodeArray[n], "name");
                string = this.getChildValue(nodeArray[n], "rrd");
                string3 = this.getChildValue(nodeArray[n], "source");
                String string4 = this.getChildValue(nodeArray[n], "cf");
                if (Util.Xml.hasChildNode(nodeArray[n], "backend")) {
                    String string5 = this.getChildValue(nodeArray[n], "backend");
                    this.rrdGraphDef.datasource(string2, string, string3, string4, string5);
                    continue;
                }
                this.rrdGraphDef.datasource(string2, string, string3, string4);
                continue;
            }
            if (this.hasChildNode(nodeArray[n], "rpn")) {
                this.validateTagsOnlyOnce(nodeArray[n], new String[]{"name", "rpn"});
                string2 = this.getChildValue(nodeArray[n], "name");
                string = this.getChildValue(nodeArray[n], "rpn");
                this.rrdGraphDef.datasource(string2, string);
                continue;
            }
            if (this.hasChildNode(nodeArray[n], "cf") || this.hasChildNode(nodeArray[n], "datasource")) {
                this.validateTagsOnlyOnce(nodeArray[n], new String[]{"name", "datasource", "cf"});
                string2 = this.getChildValue(nodeArray[n], "name");
                string = this.getChildValue(nodeArray[n], "datasource");
                string3 = this.getChildValue(nodeArray[n], "cf");
                this.rrdGraphDef.datasource(string2, string, string3);
                continue;
            }
            throw new RrdException("Unrecognized <def> format");
        }
        nodeArray = RrdGraphDefTemplate.getChildNodes(node, "export_data");
        for (n = 0; n < nodeArray.length; ++n) {
            this.validateTagsOnlyOnce(nodeArray[n], new String[]{"file", "ds_name_prefix", "use_legend_names"});
            string2 = this.getChildValue(nodeArray[n], "file");
            string = "d";
            boolean bl = false;
            if (Util.Xml.hasChildNode(nodeArray[n], "ds_name_prefix")) {
                string = this.getChildValue(nodeArray[n], "ds_name_prefix");
            }
            if (Util.Xml.hasChildNode(nodeArray[n], "use_legend_names")) {
                bl = this.getChildValueAsBoolean(nodeArray[n], "use_legend_names");
            }
            try {
                if (!string.equals("d")) {
                    this.rrdGraphDef.addExportData(new ExportData(new File(string2), string));
                    continue;
                }
                this.rrdGraphDef.addExportData(new ExportData(new File(string2), bl));
                continue;
            }
            catch (IOException iOException) {
                throw new RrdException(iOException);
            }
        }
    }

    private void resolveOptions(Node node) throws RrdException {
        this.validateTagsOnlyOnce(node, new String[]{"anti_aliasing", "arrow_color", "axis_color", "back_color", "background", "base_value", "canvas", "left_padding", "default_font", "default_font_color", "frame_color", "front_grid", "grid_range", "grid_x", "grid_y", "border", "major_grid_color", "major_grid_x", "major_grid_y", "minor_grid_color", "minor_grid_x", "minor_grid_y", "overlay", "show_legend", "show_signature", "time_axis", "time_axis_label", "title", "title_font", "title_font_color", "units_exponent", "value_axis", "vertical_label", "strict_export", "resolution", "lower_limit"});
        Node[] nodeArray = RrdGraphDefTemplate.getChildNodes(node);
        for (int i = 0; i < nodeArray.length; ++i) {
            int n;
            double d;
            String string = nodeArray[i].getNodeName();
            Node node2 = nodeArray[i];
            if (string.equals("anti_aliasing")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setAntiAliasing(bl);
                continue;
            }
            if (string.equals("arrow_color")) {
                String string2 = this.getValue(node2);
                this.rrdGraphDef.setArrowColor(Color.decode(string2));
                continue;
            }
            if (string.equals("axis_color")) {
                String string3 = this.getValue(node2);
                this.rrdGraphDef.setAxisColor(Color.decode(string3));
                continue;
            }
            if (string.equals("back_color")) {
                String string4 = this.getValue(node2);
                this.rrdGraphDef.setBackColor(Color.decode(string4));
                continue;
            }
            if (string.equals("background")) {
                String string5 = this.getValue(node2);
                this.rrdGraphDef.setBackground(string5);
                continue;
            }
            if (string.equals("base_value")) {
                double d2 = this.getValueAsDouble(node2);
                this.rrdGraphDef.setBaseValue(d2);
                continue;
            }
            if (string.equals("canvas")) {
                String string6 = this.getValue(node2);
                this.rrdGraphDef.setCanvasColor(Color.decode(string6));
                continue;
            }
            if (string.equals("left_padding")) {
                int n2 = this.getValueAsInt(node2);
                this.rrdGraphDef.setChartLeftPadding(n2);
                continue;
            }
            if (string.equals("default_font")) {
                Font font = this.resolveFont(node2);
                this.rrdGraphDef.setDefaultFont(font);
                continue;
            }
            if (string.equals("default_font_color")) {
                String string7 = this.getValue(node2);
                this.rrdGraphDef.setDefaultFontColor(Color.decode(string7));
                continue;
            }
            if (string.equals("frame_color")) {
                String string8 = this.getValue(node2);
                this.rrdGraphDef.setFrameColor(Color.decode(string8));
                continue;
            }
            if (string.equals("front_grid")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setFrontGrid(bl);
                continue;
            }
            if (string.equals("grid_range")) {
                this.validateTagsOnlyOnce(node2, new String[]{"lower", "upper", "rigid"});
                double d3 = this.getChildValueAsDouble(node2, "lower");
                d = this.getChildValueAsDouble(node2, "upper");
                boolean bl = this.getChildValueAsBoolean(node2, "rigid");
                this.rrdGraphDef.setGridRange(d3, d, bl);
                continue;
            }
            if (string.equals("lower_limit")) {
                double d4 = this.getValueAsDouble(node2);
                this.rrdGraphDef.setLowerLimit(d4);
                continue;
            }
            if (string.equals("grid_x")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setGridX(bl);
                continue;
            }
            if (string.equals("grid_y")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setGridY(bl);
                continue;
            }
            if (string.equals("border")) {
                this.validateTagsOnlyOnce(node2, new String[]{"color", "width"});
                String string9 = this.getChildValue(node2, "color");
                n = this.getChildValueAsInt(node2, "width");
                this.rrdGraphDef.setImageBorder(Color.decode(string9), n);
                continue;
            }
            if (string.equals("major_grid_color")) {
                String string10 = this.getValue(node2);
                this.rrdGraphDef.setMajorGridColor(Color.decode(string10));
                continue;
            }
            if (string.equals("major_grid_x")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setMajorGridX(bl);
                continue;
            }
            if (string.equals("major_grid_y")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setMajorGridY(bl);
                continue;
            }
            if (string.equals("minor_grid_color")) {
                String string11 = this.getValue(node2);
                this.rrdGraphDef.setMinorGridColor(Color.decode(string11));
                continue;
            }
            if (string.equals("minor_grid_x")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setMinorGridX(bl);
                continue;
            }
            if (string.equals("minor_grid_y")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setMinorGridY(bl);
                continue;
            }
            if (string.equals("overlay")) {
                String string12 = this.getValue(node2);
                this.rrdGraphDef.setOverlay(string12);
                continue;
            }
            if (string.equals("show_legend")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setShowLegend(bl);
                continue;
            }
            if (string.equals("show_signature")) {
                boolean bl = this.getValueAsBoolean(node2);
                this.rrdGraphDef.setShowSignature(bl);
                continue;
            }
            if (string.equals("time_axis")) {
                this.validateTagsOnlyOnce(node2, new String[]{"min_grid_time_unit", "min_grid_unit_steps", "maj_grid_time_unit", "maj_grid_unit_steps", "date_format", "center_labels", "first_day_of_week"});
                if (this.hasChildNode(node2, "min_grid_time_unit")) {
                    int n3 = this.resolveUnit(this.getChildValue(node2, "min_grid_time_unit"));
                    n = this.getChildValueAsInt(node2, "min_grid_unit_steps");
                    int n4 = this.resolveUnit(this.getChildValue(node2, "maj_grid_time_unit"));
                    int n5 = this.getChildValueAsInt(node2, "maj_grid_unit_steps");
                    String string13 = this.getChildValue(node2, "date_format");
                    boolean bl = this.getChildValueAsBoolean(node2, "center_labels");
                    this.rrdGraphDef.setTimeAxis(n3, n, n4, n5, string13, bl);
                }
                if (!this.hasChildNode(node2, "first_day_of_week")) continue;
                int n6 = this.resolveDayUnit(this.getChildValue(node2, "first_day_of_week"));
                this.rrdGraphDef.setFirstDayOfWeek(n6);
                continue;
            }
            if (string.equals("time_axis_label")) {
                String string14 = this.getValue(node2);
                this.rrdGraphDef.setTimeAxisLabel(string14);
                continue;
            }
            if (string.equals("title")) {
                String string15 = this.getValue(node2);
                this.rrdGraphDef.setTitle(string15);
                continue;
            }
            if (string.equals("title_font")) {
                Font font = this.resolveFont(node2);
                this.rrdGraphDef.setTitleFont(font);
                continue;
            }
            if (string.equals("title_font_color")) {
                String string16 = this.getValue(node2);
                this.rrdGraphDef.setTitleFontColor(Color.decode(string16));
                continue;
            }
            if (string.equals("units_exponent")) {
                int n7 = this.getValueAsInt(node2);
                this.rrdGraphDef.setUnitsExponent(n7);
                continue;
            }
            if (string.equals("value_axis")) {
                this.validateTagsOnlyOnce(node2, new String[]{"grid_step", "label_step"});
                double d5 = this.getChildValueAsDouble(node2, "grid_step");
                d = this.getChildValueAsDouble(node2, "label_step");
                this.rrdGraphDef.setValueAxis(d5, d);
                continue;
            }
            if (string.equals("vertical_label")) {
                String string17 = this.getValue(node2);
                this.rrdGraphDef.setVerticalLabel(string17);
                continue;
            }
            if (string.equals("strict_export")) {
                this.rrdGraphDef.setStrictExport(this.getValueAsBoolean(node2));
                continue;
            }
            if (!string.equals("resolution")) continue;
            this.rrdGraphDef.setResolution(this.getValueAsInt(node2));
        }
    }

    private int resolveUnit(String string) {
        if (string.equalsIgnoreCase("second")) {
            return 0;
        }
        if (string.equalsIgnoreCase("minute")) {
            return 1;
        }
        if (string.equalsIgnoreCase("hour")) {
            return 2;
        }
        if (string.equalsIgnoreCase("day")) {
            return 3;
        }
        if (string.equalsIgnoreCase("week")) {
            return 4;
        }
        if (string.equalsIgnoreCase("month")) {
            return 5;
        }
        if (string.equalsIgnoreCase("year")) {
            return 6;
        }
        throw new IllegalArgumentException("Invalid unit specified: " + string);
    }

    private int resolveDayUnit(String string) {
        if (string.equalsIgnoreCase("monday")) {
            return 2;
        }
        if (string.equalsIgnoreCase("tuesday")) {
            return 3;
        }
        if (string.equalsIgnoreCase("wednesday")) {
            return 4;
        }
        if (string.equalsIgnoreCase("thursday")) {
            return 5;
        }
        if (string.equalsIgnoreCase("friday")) {
            return 6;
        }
        if (string.equalsIgnoreCase("saturday")) {
            return 7;
        }
        if (string.equalsIgnoreCase("sunday")) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid day unit specified: " + string);
    }

    private void resolveSpan(Node node) throws RrdException {
        this.validateTagsOnlyOnce(node, new String[]{"start", "end"});
        String string = this.getChildValue(node, "start");
        String string2 = this.getChildValue(node, "end");
        GregorianCalendar gregorianCalendar = Util.getGregorianCalendar(string);
        GregorianCalendar gregorianCalendar2 = Util.getGregorianCalendar(string2);
        this.rrdGraphDef.setTimePeriod(gregorianCalendar, gregorianCalendar2);
    }

    private Font resolveFont(Node node) throws RrdException {
        this.validateTagsOnlyOnce(node, new String[]{"name", "style", "size"});
        String string = this.getChildValue(node, "name");
        String string2 = this.getChildValue(node, "style");
        int n = this.getChildValueAsInt(node, "size");
        int n2 = 0;
        if (string2.equalsIgnoreCase("BOLD")) {
            n2 = 1;
        } else if (string2.equalsIgnoreCase("ITALIC")) {
            n2 = 2;
        } else if (string2.equalsIgnoreCase("BOLDITALIC") || string2.equalsIgnoreCase("ITALICBOLD") || string2.equalsIgnoreCase("BOLD ITALIC") || string2.equalsIgnoreCase("ITALIC BOLD")) {
            n2 = 3;
        }
        return new Font(string, n2, n);
    }
}

